/*
 * Decompiled with CFR 0.152.
 */
package org.nico.ourbatis.el;

import java.util.List;
import java.util.function.Function;
import org.nico.ourbatis.Ourbatis;
import org.nico.ourbatis.adapter.AssistAdapter;
import org.nico.ourbatis.el.NoelFormat;
import org.nico.ourbatis.xml.Document;
import org.nico.ourbatis.xml.DocumentType;

public class NoelWriter {
    private List<Document> documents;
    private StringBuilder builder = new StringBuilder();

    public NoelWriter(List<Document> documents) {
        this.documents = documents;
    }

    public void append(String body) {
        this.builder.append(body);
    }

    public String body() {
        return this.builder.toString();
    }

    public NoelWriter write(Function<Document, String> specialCallBack, Function<String, String> thenCallBack) {
        this.write(this.documents, specialCallBack);
        this.builder = new StringBuilder(thenCallBack.apply(this.body()));
        return this;
    }

    public NoelWriter writeProperties(AssistAdapter adapter) {
        return this;
    }

    public String format() {
        return new NoelFormat(this.body()).format().result();
    }

    private NoelWriter write(List<Document> documents, Function<Document, String> specialCallBack) {
        for (int index = 0; index < documents.size(); ++index) {
            Document document = documents.get(index);
            this.builder.append(document.getBeforeContent());
            if (Ourbatis.ASSIST_ADAPTERS.containsKey(document.getName())) {
                this.builder.append(specialCallBack.apply(document));
            } else {
                String paramStr = document.getParameterString();
                if (document.getType() == DocumentType.SINGLE) {
                    this.builder.append("<" + document.getName() + " " + paramStr + document.getTail() + ">");
                } else {
                    this.builder.append("<" + document.getName() + " " + paramStr + " >");
                    if (document.getChilds() != null && !document.getChilds().isEmpty()) {
                        this.write(document.getChilds(), specialCallBack);
                    } else {
                        this.builder.append(document.getContent());
                    }
                    this.builder.append("</" + document.getName() + ">");
                }
            }
            if (index != documents.size() - 1) continue;
            this.builder.append(document.getAfterContent());
        }
        return this;
    }
}

