/*
 * Decompiled with CFR 0.152.
 */
package org.nico.ourbatis.loader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.nico.ourbatis.Ourbatis;
import org.nico.ourbatis.el.Noel;
import org.nico.ourbatis.el.NoelResult;
import org.nico.ourbatis.entity.Table;
import org.nico.ourbatis.mapping.MapperMapping;
import org.nico.ourbatis.utils.ClassUtils;
import org.nico.ourbatis.utils.StreamUtils;

public class OurbatisLoader {
    private static final Log log = LogFactory.getLog(OurbatisLoader.class);
    private Map<Table, String> mappers;
    private MapperMapping mapper;
    private Noel noel;
    private SqlSessionFactory sqlSessionFactory;
    private Configuration configuration;
    private String baseTemplateUri;
    private String baseTemplateContent;
    private String mapperLocations;

    public OurbatisLoader(SqlSessionFactory sqlSessionFactory, String baseTemplateUri, String mapperLocations) {
        this.sqlSessionFactory = sqlSessionFactory;
        this.configuration = sqlSessionFactory.getConfiguration();
        this.mappers = new LinkedHashMap<Table, String>();
        this.mapper = new MapperMapping();
        this.noel = new Noel();
        this.baseTemplateUri = baseTemplateUri;
        this.mapperLocations = mapperLocations;
        this.baseTemplateContent = StreamUtils.convertToString(this.baseTemplateUri);
        log.debug("Start processing the data source session factory " + sqlSessionFactory);
    }

    public OurbatisLoader add(Class<?> clazz) {
        log.debug(">>  Loading " + clazz.getName());
        Table entityInfo = this.mapper.mappingTable(clazz, this.mapperLocations);
        if (ClassUtils.forName(entityInfo.getMapperClassName()) != null) {
            NoelResult result = this.noel.el(this.baseTemplateContent, entityInfo);
            this.mappers.put(entityInfo, result.getFormat());
        }
        return this;
    }

    public OurbatisLoader add(String packet) {
        try {
            List<Class<?>> classes = ClassUtils.getClasses(packet);
            if (classes != null && !classes.isEmpty()) {
                classes.forEach(clazz -> this.add((Class<?>)clazz));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void build() {
        if (!this.mappers.isEmpty()) {
            boolean openPrint = Ourbatis.print != null;
            this.mappers.forEach((entityInfo, mapper) -> {
                try {
                    if (openPrint) {
                        StreamUtils.write(Ourbatis.print, entityInfo.getDomainClassName(), ".xml", mapper);
                        log.debug(">>  Writing  " + entityInfo.getDomainClassName());
                    }
                }
                catch (Exception arg6) {
                    arg6.printStackTrace();
                }
                log.debug(">>  Building " + entityInfo.getDomainClassName());
                ByteArrayInputStream mapperStream = new ByteArrayInputStream(mapper.getBytes());
                XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder((InputStream)mapperStream, this.configuration, mapperStream.toString(), this.configuration.getSqlFragments());
                xmlMapperBuilder.parse();
            });
        }
    }

    public Map<Table, String> getMappers() {
        return this.mappers;
    }

    public void setMappers(Map<Table, String> mappers) {
        this.mappers = mappers;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }
}

