/*
 * Decompiled with CFR 0.152.
 */
package org.nico.ourbatis.mapping;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.nico.ourbatis.entity.Column;
import org.nico.ourbatis.entity.Table;
import org.nico.ourbatis.utils.ArrayUtils;
import org.nico.ourbatis.utils.AssertUtils;
import org.nico.ourbatis.utils.ReflectUtils;
import org.nico.ourbatis.wrapper.JdbcNameWrapper;
import org.nico.ourbatis.wrapper.JdbcTypeWrapper;
import org.nico.ourbatis.wrapper.MapperNameWrapper;
import org.nico.ourbatis.wrapper.TableNameWrapper;
import org.nico.ourbatis.wrapper.Wrapper;

public class MapperMapping {
    private Wrapper<Class<?>> tableNameWrapper = new TableNameWrapper();
    private Wrapper<Class<?>> mapperNameWrapper;
    private Wrapper<Field> JdbcNameWrapper = new JdbcNameWrapper();
    private Wrapper<Class<?>> JdbcTypeWrapper = new JdbcTypeWrapper();

    public MapperMapping() {
        this.mapperNameWrapper = new MapperNameWrapper();
    }

    public Table mappingTable(Class<?> domainClass, String mapperLocations) {
        Table table = new Table();
        Object[] classFields = ReflectUtils.getFields(domainClass);
        ArrayList<Column> normalColumns = new ArrayList<Column>(classFields.length);
        ArrayList<Column> primaryColumns = new ArrayList<Column>(classFields.length);
        ArrayList<Column> allColumns = new ArrayList<Column>(classFields.length);
        if (ArrayUtils.isNotEmpty(classFields)) {
            for (Object field : classFields) {
                if (ReflectUtils.isRenderIgnore((Field)field)) continue;
                Column column = this.mappingColumnEntity((Field)field);
                if (ReflectUtils.isRenderPrimary((Field)field)) {
                    primaryColumns.add(column);
                } else {
                    normalColumns.add(column);
                }
                allColumns.add(column);
            }
        }
        AssertUtils.assertNotEmpty(primaryColumns, "The entity class [" + domainClass.getName() + "] needs at least one primary key.");
        AssertUtils.assertNotEmpty(normalColumns, "The entity class [" + domainClass.getName() + "] needs at least one field.");
        table.setTableName(this.tableNameWrapper.wrapping(domainClass));
        table.setPrimaryColumns(primaryColumns);
        table.setNormalColumns(normalColumns);
        table.setAllColumns(allColumns);
        table.setDomainClass(domainClass);
        table.setDomainSimpleClassName(domainClass.getSimpleName());
        table.setDomainClassName(domainClass.getName());
        if (ReflectUtils.isMapperBy(domainClass)) {
            table.setMapperClassName(ReflectUtils.getMapperBy(domainClass).getName());
        } else {
            table.setMapperClassName(mapperLocations + "." + this.mapperNameWrapper.wrapping(domainClass));
        }
        return table;
    }

    private Column mappingColumnEntity(Field field) {
        Column column = new Column();
        column.setJdbcName(this.JdbcNameWrapper.wrapping(field));
        column.setJdbcType(this.JdbcTypeWrapper.wrapping(field.getType()));
        column.setJavaName(field.getName());
        column.setJavaType(field.getType().getSimpleName());
        return column;
    }
}

