/*
 * Decompiled with CFR 0.152.
 */
package org.nico.ourbatis.xml;

import java.util.List;
import org.nico.ourbatis.xml.Document;

public abstract class SmartScanner {
    private String value;
    private int pos = 0;
    protected StringBuilder builder = new StringBuilder();
    private Status status = Status.START;

    public SmartScanner(String value) {
        this.value = value;
    }

    public SmartScanner scan() {
        if (this.value != null) {
            char[] chars = this.value.toCharArray();
            Status tempStatus = null;
            while (this.pos < chars.length) {
                char c = chars[this.pos];
                if (this.status == Status.START) {
                    tempStatus = this.parseStart(c);
                } else if (this.status == Status.HEAD) {
                    tempStatus = this.parseHead(c);
                } else if (this.status == Status.ANNOTATION) {
                    tempStatus = this.parseAnnotation(c);
                }
                if (this.status == Status.PARAM) {
                    tempStatus = this.parseParam(c);
                } else if (this.status == Status.BODY) {
                    tempStatus = this.parseBody(c);
                }
                this.status = tempStatus;
                ++this.pos;
            }
        }
        return this;
    }

    protected abstract Status parseStart(char var1);

    protected abstract Status parseHead(char var1);

    protected abstract Status parseAnnotation(char var1);

    protected abstract Status parseParam(char var1);

    protected abstract Status parseBody(char var1);

    protected abstract Status parseFinished();

    public abstract List<Document> results();

    protected void append(char c) {
        this.builder.append(c);
    }

    protected String cut(int start, int length) {
        return this.value.substring(start, start + length);
    }

    protected String cut(int length) {
        return this.cut(this.pos, length);
    }

    protected boolean isLast() {
        return this.pos == this.value.length() - 1;
    }

    protected boolean move(int length) {
        this.pos += length;
        return true;
    }

    public static enum Status {
        START,
        HEAD,
        PARAM,
        BODY,
        ANNOTATION;

    }
}

