/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.directory;

import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.impl.directory.DefaultCustomData;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.lang.Assert;
import java.util.Map;

public abstract class AbstractDirectoryEntity
extends AbstractInstanceResource {
    public static final ResourceReference<CustomData> CUSTOM_DATA = new ResourceReference<CustomData>("customData", CustomData.class);

    protected AbstractDirectoryEntity(InternalDataStore dataStore) {
        super(dataStore);
    }

    protected AbstractDirectoryEntity(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore);
        if (properties != null && properties.containsKey(CUSTOM_DATA.getName())) {
            Object object = properties.get(CUSTOM_DATA.getName());
            Assert.isInstanceOf(Map.class, (Object)object);
            CustomData customData = this.getDataStore().instantiate(CustomData.class, (Map)properties.get(CUSTOM_DATA.getName()));
            properties.put(CUSTOM_DATA.getName(), customData);
        }
        this.setProperties(properties);
    }

    protected CustomData getCustomData() {
        if (this.isNew() && this.getResourceProperty(CUSTOM_DATA) == null) {
            this.setProperty(CUSTOM_DATA, (Object)this.getDataStore().instantiate(CustomData.class));
        }
        return this.getResourceProperty(CUSTOM_DATA);
    }

    protected void applyCustomDataUpdatesIfNecessary() {
        CustomData customData = this.getCustomData();
        Assert.isInstanceOf(DefaultCustomData.class, (Object)customData);
        DefaultCustomData customDataImpl = (DefaultCustomData)customData;
        if (customDataImpl.isDirty()) {
            if (customDataImpl.hasRemovedProperties()) {
                customDataImpl.deleteRemovedProperties();
            }
            if (customDataImpl.hasNewProperties()) {
                this.setProperty(CUSTOM_DATA, (Object)customData);
            }
        }
    }
}

