/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.directory;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountCriteria;
import com.stormpath.sdk.account.AccountList;
import com.stormpath.sdk.account.Accounts;
import com.stormpath.sdk.account.CreateAccountRequest;
import com.stormpath.sdk.directory.AccountStoreVisitor;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.directory.DirectoryStatus;
import com.stormpath.sdk.group.CreateGroupRequest;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupCriteria;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.group.Groups;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.tenant.Tenant;
import java.util.Map;

public class DefaultDirectory
extends AbstractInstanceResource
implements Directory {
    static final StringProperty NAME = new StringProperty("name");
    static final StringProperty DESCRIPTION = new StringProperty("description");
    static final StatusProperty<DirectoryStatus> STATUS = new StatusProperty<DirectoryStatus>(DirectoryStatus.class);
    static final ResourceReference<Tenant> TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
    static final CollectionReference<AccountList, Account> ACCOUNTS = new CollectionReference<AccountList, Account>("accounts", AccountList.class, Account.class);
    static final CollectionReference<GroupList, Group> GROUPS = new CollectionReference<GroupList, Group>("groups", GroupList.class, Group.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultDirectory.createPropertyDescriptorMap(NAME, DESCRIPTION, STATUS, TENANT, ACCOUNTS, GROUPS);

    public DefaultDirectory(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultDirectory(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public void setName(String name) {
        this.setProperty(NAME, (Object)name);
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.setProperty(DESCRIPTION, (Object)description);
    }

    public DirectoryStatus getStatus() {
        String value = this.getStringProperty(STATUS.getName());
        if (value == null) {
            return null;
        }
        return DirectoryStatus.valueOf((String)value.toUpperCase());
    }

    public void setStatus(DirectoryStatus status) {
        this.setProperty(STATUS, (Object)status.name());
    }

    public void createAccount(Account account) {
        Assert.notNull((Object)account, (String)"account cannot be null.");
        this.createAccount(Accounts.newCreateRequestFor((Account)account).build());
    }

    public void createAccount(Account account, boolean registrationWorkflowEnabled) {
        Assert.notNull((Object)account, (String)"account cannot be null.");
        this.createAccount(Accounts.newCreateRequestFor((Account)account).setRegistrationWorkflowEnabled(registrationWorkflowEnabled).build());
    }

    public void createAccount(CreateAccountRequest request) {
        Assert.notNull((Object)request, (String)"Request cannot be null.");
        Account account = request.getAccount();
        String href = this.getAccounts().getHref();
        if (request.isRegistrationWorkflowOptionSpecified()) {
            href = href + "?registrationWorkflowEnabled=" + request.isRegistrationWorkflowEnabled();
        }
        if (request.isAccountOptionsSpecified()) {
            this.getDataStore().create(href, account, (Options)request.getAccountOptions());
            return;
        }
        this.getDataStore().create(href, account);
    }

    public AccountList getAccounts() {
        return (AccountList)this.getResourceProperty(ACCOUNTS);
    }

    public AccountList getAccounts(Map<String, Object> queryParams) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, queryParams);
    }

    public AccountList getAccounts(AccountCriteria criteria) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, (Criteria)criteria);
    }

    public GroupList getGroups() {
        return (GroupList)this.getResourceProperty(GROUPS);
    }

    public GroupList getGroups(Map<String, Object> queryParams) {
        GroupList list = this.getGroups();
        return this.getDataStore().getResource(list.getHref(), GroupList.class, queryParams);
    }

    public GroupList getGroups(GroupCriteria criteria) {
        GroupList list = this.getGroups();
        return this.getDataStore().getResource(list.getHref(), GroupList.class, (Criteria)criteria);
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }

    public void createGroup(Group group) {
        Assert.notNull((Object)group, (String)"Group cannot be null.");
        this.createGroup(Groups.newCreateRequestFor((Group)group).build());
    }

    public void createGroup(CreateGroupRequest request) {
        Assert.notNull((Object)request, (String)"Request cannot be null.");
        Group group = request.getGroup();
        String href = this.getGroups().getHref();
        if (request.isGroupOptionsSpecified()) {
            this.getDataStore().create(href, group, (Options)request.getGroupOptions());
            return;
        }
        this.getDataStore().create(href, group);
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    public void accept(AccountStoreVisitor visitor) {
        visitor.visit((Directory)this);
    }
}

