/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.util;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Objects;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class Duration
implements Comparable<Duration>,
Cloneable {
    private final long value;
    private final TimeUnit timeUnit;

    public Duration(long value, TimeUnit timeUnit) {
        Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit argument cannot be null.");
        this.value = value;
        this.timeUnit = timeUnit;
    }

    public long getValue() {
        return this.value;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public int compareTo(Duration duration) {
        long converted = this.timeUnit.convert(duration.getValue(), duration.getTimeUnit());
        if (this.value < converted) {
            return -1;
        }
        if (this.value > converted) {
            return 1;
        }
        return 0;
    }

    public boolean isLessThan(Duration duration) {
        return this.compareTo(duration) < 0;
    }

    public boolean isGreaterThan(Duration duration) {
        return this.compareTo(duration) > 0;
    }

    public boolean isEquivalentTo(Duration duration) {
        return this.compareTo(duration) == 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Duration) {
            Duration d = (Duration)o;
            return this.value == d.value && this.timeUnit.equals((Object)d.timeUnit);
        }
        return false;
    }

    public String toString() {
        return this.value + " " + this.timeUnit.name().toLowerCase(Locale.ENGLISH);
    }

    public int hashCode() {
        return Objects.hashCode((long)this.value) * 37 + Objects.nullSafeHashCode((Object)((Object)this.timeUnit));
    }

    public Duration clone() {
        try {
            return (Duration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Unable to clone Object direct subclass! " + e.getMessage());
        }
    }
}

