/*
 * Copyright 2017 Ping Identity Corporation
 * All Rights Reserved.
 */
/*
 * Copyright (C) 2017 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.ldap.sdk;



import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;



/**
 * This class provides information about the current version of the UnboundID
 * LDAP SDK for Java.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Version
{
  //
  // NOTE -- This file is dynamically generated.  Do not edit it.  If you need
  //         to add something to it, then add it to the
  //         resource/Version.java.stub file below the LDAP SDK build root.
  //



  /**
   * The official full product name for the LDAP SDK.  For this build, the
   * value is "UnboundID LDAP SDK for Java".
   */
  public static final String PRODUCT_NAME =
       "UnboundID LDAP SDK for Java";



  /**
   * The short product name for the LDAP SDK.  This will not have any spaces.
   * For this build, the value is "unboundid-ldapsdk".
   */
  public static final String SHORT_NAME =
       "unboundid-ldapsdk";



  /**
   * The major version number for the LDAP SDK.  For this build, the value is
   * 4.
   */
  public static final int MAJOR_VERSION = 4;



  /**
   * The minor version number for the LDAP SDK.  For this build, the value is
   * 0.
   */
  public static final int MINOR_VERSION = 0;



  /**
   * The point version number for the LDAP SDK.  For this build, the value is
   * 1.
   */
  public static final int POINT_VERSION = 1;



  /**
   * The version qualifier string for the LDAP SDK.  It will often be a
   * zero-length string, but may be non-empty for special builds that should be
   * tagged in some way (e.g., "-beta1" or "-rc2").  For this build, the value
   * is "".
   */
  public static final String VERSION_QUALIFIER =
       "";



  /**
   * A timestamp that indicates when this build of the LDAP SDK was generated.
   * For this build, the value is "20170905185405Z".
   */
  public static final String BUILD_TIMESTAMP = "20170905185405Z";



  /**
   * The type of repository from which the source code used to build the LDAP
   * SDK was retrieved.  It will be one of "subversion", "git", or "{unknown}".
   * For this build, the value is "subversion".
   */
  public static final String REPOSITORY_TYPE = "subversion";



  /**
   * The URL for the repository from which the source code used to build the
   * LDAP SDK was retrieved.  If repository information could not be determined
   * at build time, then this will be a file URL that references the path to the
   * source code on the system used to build the LDAP SDK library.  For this
   * build, the value is
   * "https://svn.unboundid.lab/directory/tags/ldapsdk/ldapsdk-4.0.1".
   */
  public static final String REPOSITORY_URL =
       "https://svn.unboundid.lab/directory/tags/ldapsdk/ldapsdk-4.0.1";



  /**
   * The path to the LDAP SDK source code in the repository.  If repository
   * information could not be determined at build time, then this will be "/".
   * For this build, the value is
   * "/directory/tags/ldapsdk/ldapsdk-4.0.1".
   */
  public static final String REPOSITORY_PATH =
       "/directory/tags/ldapsdk/ldapsdk-4.0.1";



  /**
   * The string representation of the source revision from which this build of
   * the LDAP SDK was generated.  For a subversion repository, this will be the
   * string representation of the revision number.  For a git repository, this
   * will be the hexadecimal representation of the digest for the most recent
   * commit.  If repository information could not be determined at build time,
   * the value will be "{unknown}".  For this build, the value is
   * "26090".
   */
  public static final String REVISION_ID =
       "26090";



  /**
   * The revision number for the source revision from which this build of the
   * LDAP SDK was generated.  For a subversion repository, this will be the
   * revision number.  For a git repository (which uses a hexadecimal digest to
   * indicate revisions), or if repository information could not be determined
   * at build time, the value will be -1.  For this build, the value is
   * 26090.
   *
   * @deprecated  Use the {@link #REVISION_ID} property instead, since it can
   *              handle non-numeric revision identifiers.
   */
  @Deprecated()
  public static final long REVISION_NUMBER = 26090;



  /**
   * The full version string for the LDAP SDK.  For this build, the value is
   * "UnboundID LDAP SDK for Java 4.0.1".
   */
  public static final String FULL_VERSION_STRING =
       PRODUCT_NAME + ' ' + MAJOR_VERSION + '.' + MINOR_VERSION + '.' +
       POINT_VERSION + VERSION_QUALIFIER;



  /**
   * The short version string for the LDAP SDK.  This will not have any spaces.
   * For this build, the value is
   * "unboundid-ldapsdk-4.0.1".
   */
  public static final String SHORT_VERSION_STRING =
       SHORT_NAME + '-' + MAJOR_VERSION + '.' + MINOR_VERSION + '.' +
       POINT_VERSION + VERSION_QUALIFIER;



  /**
   *The version number string for the LDAP SDK, which contains just the major,
   * minor, and point version, and optional version qualifier.  For this build,
   * the version string is
   * "4.0.1".
   */
  public static final String NUMERIC_VERSION_STRING =
       MAJOR_VERSION + "." + MINOR_VERSION + '.' +
       POINT_VERSION + VERSION_QUALIFIER;



  /**
   * Prevent this class from being instantiated.
   */
  private Version()
  {
    // No implementation is required.
  }



  /**
   * Prints version information from this class to standard output.
   *
   * @param  args  The command-line arguments provided to this program.
   */
  public static void main(final String... args)
  {
    for (final String line : getVersionLines())
    {
      System.out.println(line);
    }
  }



  /**
   * Retrieves a list of lines containing information about the LDAP SDK
   * version.
   *
   * @return  A list of lines containing information about the LDAP SDK
   *          version.
   */
  public static List<String> getVersionLines()
  {
    final ArrayList<String> versionLines = new ArrayList<String>(11);

    versionLines.add("Full Version String:   " + FULL_VERSION_STRING);
    versionLines.add("Short Version String:  " + SHORT_VERSION_STRING);
    versionLines.add("Product Name:          " + PRODUCT_NAME);
    versionLines.add("Short Name:            " + SHORT_NAME);
    versionLines.add("Major Version:         " + MAJOR_VERSION);
    versionLines.add("Minor Version:         " + MINOR_VERSION);
    versionLines.add("Point Version:         " + POINT_VERSION);
    versionLines.add("Version Qualifier:     " + VERSION_QUALIFIER);
    versionLines.add("Build Timestamp:       " + BUILD_TIMESTAMP);
    versionLines.add("Repository Type:       " + REPOSITORY_TYPE);
    versionLines.add("Repository URL:        " + REPOSITORY_URL);
    versionLines.add("Repository Path:       " + REPOSITORY_PATH);
    versionLines.add("Revision:              " + REVISION_ID);

    return Collections.unmodifiableList(versionLines);
  }
}
