/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.cache;

import com.wizzardo.tools.cache.CacheCleaner;
import com.wizzardo.tools.cache.Computable;
import com.wizzardo.tools.cache.Holder;
import com.wizzardo.tools.misc.Unchecked;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Cache<K, V> {
    private final ConcurrentHashMap<K, Holder<K, V>> map = new ConcurrentHashMap();
    private final Queue<TimingsHolder> timings = new ConcurrentLinkedQueue<TimingsHolder>();
    private long ttl;
    private Computable<? super K, ? extends V> computable;
    private volatile boolean removeOnException = true;
    private volatile boolean destroyed;

    public Cache(long ttlSec, Computable<? super K, ? extends V> computable) {
        this.ttl = ttlSec * 1000L;
        this.computable = computable;
        this.timings.add(new TimingsHolder(this.ttl));
        CacheCleaner.addCache(this);
    }

    public Cache(long ttlSec) {
        this(ttlSec, null);
    }

    public V get(K k) {
        return this.getFromCache(k, this.computable, false);
    }

    public V get(K k, boolean updateTTL) {
        return this.getFromCache(k, this.computable, updateTTL);
    }

    public V get(K k, Computable<? super K, ? extends V> computable) {
        return this.getFromCache(k, computable, false);
    }

    public V get(K k, Computable<? super K, ? extends V> computable, boolean updateTTL) {
        return this.getFromCache(k, computable, updateTTL);
    }

    public void setRemoveOnException(boolean removeOnException) {
        this.removeOnException = removeOnException;
    }

    public boolean isRemoveOnException() {
        return this.removeOnException;
    }

    public V remove(K k) {
        Holder<K, V> holder = this.map.remove(k);
        if (holder == null) {
            return null;
        }
        holder.setRemoved();
        this.onRemoveItem(holder.getKey(), holder.get());
        return holder.get();
    }

    long refresh(long time) {
        long nextWakeUp = Long.MAX_VALUE;
        for (TimingsHolder timingsHolder : this.timings) {
            Map.Entry entry;
            Queue timings = timingsHolder.timings;
            while ((entry = timings.peek()) != null && entry.getValue().compareTo(time) <= 0) {
                Holder h = timings.poll().getKey();
                if (h.validUntil > time || !this.map.remove(h.getKey(), h)) continue;
                this.onRemoveItem(h.getKey(), h.get());
            }
            if (entry == null) continue;
            nextWakeUp = Math.min(nextWakeUp, entry.getValue());
        }
        return nextWakeUp;
    }

    public void destroy() {
        this.destroyed = true;
        this.clear();
    }

    public void clear() {
        this.timings.clear();
        this.map.clear();
    }

    public void onRemoveItem(K k, V v) {
    }

    public void onAddItem(K k, V v) {
    }

    private V getFromCache(K key, Computable<? super K, ? extends V> c, boolean updateTTL) {
        Holder<K, V> f = this.map.get(key);
        if (f == null) {
            if (c == null || this.destroyed) {
                return null;
            }
            Holder<? super K, ? extends V> ft = new Holder<K, V>(key, this.timings.peek());
            f = this.map.putIfAbsent(key, ft);
            boolean failed = true;
            if (f == null) {
                f = ft;
                try {
                    ft.run(c, (K)key);
                    failed = false;
                }
                catch (Exception e) {
                    throw Unchecked.rethrow((Exception)e);
                }
                finally {
                    ft.done();
                    if (failed && this.removeOnException) {
                        this.map.remove(key);
                        f.setRemoved();
                    } else {
                        this.updateTimingCache(f);
                        this.onAddItem(f.getKey(), f.get());
                    }
                }
            }
        } else if (updateTTL) {
            this.updateTimingCache(f);
        }
        return f.get();
    }

    public void put(K key, V value) {
        this.put(key, value, this.ttl);
    }

    public void put(K key, V value, long ttl) {
        Holder<K, V> h = new Holder<K, V>(key, value, this.findTimingsHolder(ttl));
        Holder<K, V> old = this.map.put(key, h);
        this.onAddItem(key, value);
        this.updateTimingCache(h);
        if (old != null) {
            old.setRemoved();
            this.onRemoveItem(old.k, old.v);
        }
    }

    public boolean putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.ttl);
    }

    public boolean putIfAbsent(K key, V value, long ttl) {
        Holder<K, V> h = new Holder<K, V>(key, value, this.findTimingsHolder(ttl));
        if (this.map.putIfAbsent(key, h) == null) {
            this.updateTimingCache(h);
            this.onAddItem(key, value);
            return true;
        }
        return false;
    }

    private TimingsHolder findTimingsHolder(long ttl) {
        for (TimingsHolder holder : this.timings) {
            if (holder.ttl != ttl) continue;
            return holder;
        }
        TimingsHolder holder = new TimingsHolder(ttl);
        this.timings.add(holder);
        return holder;
    }

    private void updateTimingCache(final Holder<K, V> key) {
        TimingsHolder timingsHolder = key.getTimingsHolder();
        if (timingsHolder.ttl <= 0L) {
            return;
        }
        final Long timing = timingsHolder.ttl + System.currentTimeMillis();
        key.setValidUntil(timing);
        CacheCleaner.updateWakeUp(timing);
        timingsHolder.timings.add(new Map.Entry<Holder<K, V>, Long>(){

            @Override
            public Holder<K, V> getKey() {
                return key;
            }

            @Override
            public Long getValue() {
                return timing;
            }

            @Override
            public Long setValue(Long value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
    }

    public int size() {
        return this.map.size();
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public long getTTL() {
        return this.ttl;
    }

    public long getTTL(K k) {
        Holder<K, V> holder = this.map.get(k);
        if (holder != null) {
            return holder.getTimingsHolder().ttl;
        }
        return this.ttl;
    }

    public void removeOldest() {
        Holder holder = null;
        block0: for (TimingsHolder th : this.timings) {
            for (Map.Entry entry : th.timings) {
                if ((Long)entry.getValue() != ((Holder)entry.getKey()).validUntil || ((Holder)entry.getKey()).isRemoved()) continue;
                if (holder != null && ((Holder)entry.getKey()).validUntil >= holder.validUntil) continue block0;
                holder = (Holder)entry.getKey();
                continue block0;
            }
        }
        if (holder != null) {
            this.remove(holder.getKey());
        }
    }

    class TimingsHolder {
        Queue<Map.Entry<Holder<K, V>, Long>> timings = new ConcurrentLinkedQueue();
        long ttl;

        private TimingsHolder(long ttl) {
            this.ttl = ttl;
        }
    }
}

