/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.cache;

import com.wizzardo.tools.cache.Cache;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class CacheCleaner
extends Thread {
    private Set<Cache> caches = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile long wakeup = -1L;
    private volatile boolean sleeping = false;
    private static final CacheCleaner instance = new CacheCleaner();

    private CacheCleaner() {
        this.setDaemon(true);
        this.setName(this.getClass().getName());
    }

    static void addCache(Cache cache) {
        CacheCleaner.instance.caches.add(cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateWakeUp(long wakeup) {
        if (CacheCleaner.instance.wakeup < wakeup && CacheCleaner.instance.wakeup > 0L) {
            return;
        }
        CacheCleaner cacheCleaner = instance;
        synchronized (cacheCleaner) {
            if (CacheCleaner.instance.wakeup < wakeup && CacheCleaner.instance.wakeup > 0L) {
                return;
            }
            CacheCleaner.instance.wakeup = wakeup;
            if (CacheCleaner.instance.sleeping) {
                instance.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block5: while (true) {
            Long time = System.currentTimeMillis();
            Iterator<Cache> iterator = this.caches.iterator();
            Long wakeup = time + 86400000L;
            while (iterator.hasNext()) {
                Cache cache = iterator.next();
                if (cache.isDestroyed()) {
                    iterator.remove();
                    continue;
                }
                long l = cache.refresh(time);
                if (l <= 0L || l >= wakeup) continue;
                wakeup = l;
            }
            while (true) {
                if (wakeup.compareTo(time = Long.valueOf(System.currentTimeMillis())) <= 0) continue block5;
                CacheCleaner cacheCleaner = this;
                synchronized (cacheCleaner) {
                    if (this.wakeup < wakeup && this.wakeup > time) {
                        wakeup = this.wakeup;
                    } else {
                        this.wakeup = wakeup;
                    }
                    this.sleeping = true;
                    if (wakeup - time > 0L) {
                        try {
                            this.wait(wakeup - time);
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                    this.sleeping = false;
                }
            }
            break;
        }
    }

    static {
        instance.start();
    }
}

