/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.cache;

import com.wizzardo.tools.cache.Cache;
import com.wizzardo.tools.cache.Computable;

class Holder<K, V> {
    protected V v;
    protected K k;
    protected volatile boolean done = false;
    protected volatile long validUntil;
    private Cache.TimingsHolder timingsHolder;

    public Holder(K k, Cache.TimingsHolder timingsHolder) {
        this.k = k;
        this.timingsHolder = timingsHolder;
    }

    public Holder(K k, V v, Cache.TimingsHolder timingsHolder) {
        this.v = v;
        this.k = k;
        this.timingsHolder = timingsHolder;
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get() {
        if (!this.done) {
            Holder holder = this;
            synchronized (holder) {
                while (!this.done) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return this.v;
    }

    public void run(Computable<? super K, ? extends V> c, K k) throws Exception {
        this.v = c.compute(k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done() {
        Holder holder = this;
        synchronized (holder) {
            this.done = true;
            this.notifyAll();
        }
    }

    public void setValidUntil(long validUntil) {
        this.validUntil = validUntil;
    }

    public K getKey() {
        return this.k;
    }

    Cache.TimingsHolder getTimingsHolder() {
        return this.timingsHolder;
    }

    boolean isRemoved() {
        return this.timingsHolder == null;
    }

    void setRemoved() {
        this.timingsHolder = null;
        this.done = true;
    }
}

