/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.cache;

import com.wizzardo.tools.cache.Cache;
import com.wizzardo.tools.cache.Computable;
import java.util.concurrent.atomic.AtomicLong;

public class MemoryLimitedCache<K, V extends SizeProvider>
extends Cache<K, V> {
    private final long limit;
    private AtomicLong size = new AtomicLong();

    public MemoryLimitedCache(long limit, long ttlSec, Computable<? super K, ? extends V> computable) {
        super(ttlSec, computable);
        this.limit = limit;
    }

    public MemoryLimitedCache(long limit, long ttlSec) {
        this(limit, ttlSec, null);
    }

    @Override
    public void onAddItem(K k, V v) {
        if (v == null) {
            return;
        }
        this.updateSize(v, true);
    }

    private void updateSize(V v, boolean increment) {
        long add;
        long l = add = increment ? this.checkAndGetSize(v) : -this.checkAndGetSize(v);
        if (this.size.addAndGet(add) > this.limit) {
            this.removeOldest();
        }
    }

    @Override
    public void onRemoveItem(K k, V v) {
        if (v == null) {
            return;
        }
        this.updateSize(v, false);
    }

    private long checkAndGetSize(V v) {
        long l = v.size();
        if (l < 0L) {
            throw new IllegalStateException("value size must be > 0");
        }
        return l;
    }

    public long limit() {
        return this.limit;
    }

    public long memoryUsed() {
        return this.size.get();
    }

    public static interface SizeProvider {
        public long size();
    }
}

