/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.collections;

import com.wizzardo.tools.collections.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class CollectionTools {
    public static <T> void each(Iterable<T> c, Closure<Void, ? super T> closure) {
        for (T t : c) {
            closure.execute(t);
        }
    }

    public static <T> void eachWithIndex(Iterable<T> c, Closure2<Void, Integer, ? super T> closure) {
        int i = 0;
        for (T t : c) {
            closure.execute(i, t);
            ++i;
        }
    }

    public static <T, R> List<R> collect(Iterable<T> c, Closure<R, ? super T> closure) {
        ArrayList<R> l = new ArrayList<R>();
        for (T t : c) {
            l.add(closure.execute(t));
        }
        return l;
    }

    public static <T> List<T> grep(Iterable<T> c, Object expression) {
        ArrayList<T> l = new ArrayList<T>();
        for (T t : c) {
            if (!t.equals(expression)) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> List<T> grep(Iterable<T> c, Closure<Boolean, ? super T> closure) {
        ArrayList<T> l = new ArrayList<T>();
        for (T t : c) {
            if (!closure.execute(t).booleanValue()) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> List<T> grep(Iterable<T> c, Range r) {
        ArrayList<T> l = new ArrayList<T>();
        for (T t : c) {
            if (!r.contains(t)) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> List<T> grep(Iterable<T> c, Collection r) {
        ArrayList<T> l = new ArrayList<T>();
        for (T t : c) {
            if (!r.contains(t)) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> List<T> grep(Iterable<T> c, Pattern p) {
        ArrayList<T> l = new ArrayList<T>();
        for (T t : c) {
            if (!t.toString().matches(p.pattern())) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> List<T> grep(Iterable<T> c, Class clazz) {
        ArrayList<T> l = new ArrayList<T>();
        for (T t : c) {
            if (!clazz.isAssignableFrom(t.getClass())) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> List<T> findAll(Iterable<T> c, Closure<Boolean, ? super T> closure) {
        ArrayList<T> l = new ArrayList<T>();
        for (T t : c) {
            if (!closure.execute(t).booleanValue()) continue;
            l.add(t);
        }
        return l;
    }

    public static <T> T find(Iterable<T> c, Closure<Boolean, ? super T> closure) {
        for (T t : c) {
            if (!closure.execute(t).booleanValue()) continue;
            return t;
        }
        return null;
    }

    public static <T> boolean every(Iterable<T> c, Closure<Boolean, ? super T> closure) {
        boolean b = true;
        for (T t : c) {
            if (b &= closure.execute(t).booleanValue()) continue;
            return false;
        }
        return b;
    }

    public static <T> boolean any(Iterable<T> c, Closure<Boolean, ? super T> closure) {
        for (T t : c) {
            if (!closure.execute(t).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <T> String join(Iterable<T> c, String separator) {
        StringBuilder sb = new StringBuilder();
        for (T t : c) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(t);
        }
        return sb.toString();
    }

    public static interface Closure10<R, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> {
        public R execute(T1 var1, T2 var2, T3 var3, T4 var4, T5 var5, T6 var6, T7 var7, T8 var8, T9 var9, T10 var10);
    }

    public static interface Closure9<R, T1, T2, T3, T4, T5, T6, T7, T8, T9> {
        public R execute(T1 var1, T2 var2, T3 var3, T4 var4, T5 var5, T6 var6, T7 var7, T8 var8, T9 var9);
    }

    public static interface Closure8<R, T1, T2, T3, T4, T5, T6, T7, T8> {
        public R execute(T1 var1, T2 var2, T3 var3, T4 var4, T5 var5, T6 var6, T7 var7, T8 var8);
    }

    public static interface Closure7<R, T1, T2, T3, T4, T5, T6, T7> {
        public R execute(T1 var1, T2 var2, T3 var3, T4 var4, T5 var5, T6 var6, T7 var7);
    }

    public static interface Closure6<R, T1, T2, T3, T4, T5, T6> {
        public R execute(T1 var1, T2 var2, T3 var3, T4 var4, T5 var5, T6 var6);
    }

    public static interface Closure5<R, T1, T2, T3, T4, T5> {
        public R execute(T1 var1, T2 var2, T3 var3, T4 var4, T5 var5);
    }

    public static interface Closure4<R, T1, T2, T3, T4> {
        public R execute(T1 var1, T2 var2, T3 var3, T4 var4);
    }

    public static interface Closure3<R, T1, T2, T3> {
        public R execute(T1 var1, T2 var2, T3 var3);
    }

    public static interface Closure2<R, T1, T2> {
        public R execute(T1 var1, T2 var2);
    }

    public static interface Closure<R, T> {
        public R execute(T var1);
    }
}

