/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class Range
implements Iterable<Integer>,
List<Integer> {
    private int from;
    private int to;

    public Range(int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("from must be lower then to. " + from + " - " + to);
        }
        this.from = from;
        this.to = to;
    }

    @Override
    public int size() {
        return this.to - this.from;
    }

    @Override
    public boolean isEmpty() {
        return this.size() > 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return i >= this.from && i < this.to;
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int cur;
            {
                this.cur = Range.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.cur < Range.this.to;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("iteration has no more elements");
                }
                return this.cur++;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Integer[this.size()];
        for (int i = this.from; i < this.to; ++i) {
            arr[i - this.from] = i;
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.getClass().getName().equals("[Ljava.lang.Integer;")) {
            Integer[] arr = a.length == 0 ? new Integer[this.size()] : (Integer[])a;
            for (int i = this.from; i < this.to; ++i) {
                arr[i - this.from] = i;
            }
            return arr;
        }
        return a;
    }

    @Override
    public boolean add(Integer integer) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean b = true;
        for (Object i : c) {
            if (b &= this.contains(i)) continue;
            return false;
        }
        return b;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public Integer get(int index) {
        return this.from + index;
    }

    @Override
    public Integer set(int index, Integer element) {
        return null;
    }

    @Override
    public void add(int index, Integer element) {
    }

    @Override
    public Integer remove(int index) {
        return null;
    }

    @Override
    public int indexOf(Object o) {
        int i;
        if (o.getClass() == Integer.class && (i = ((Integer)o).intValue()) >= this.from && i < this.to) {
            return i - this.from;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<Integer> listIterator() {
        return null;
    }

    @Override
    public ListIterator<Integer> listIterator(int index) {
        return null;
    }

    @Override
    public List<Integer> subList(int fromIndex, int toIndex) {
        return new Range(this.from + fromIndex, fromIndex + toIndex);
    }

    public String toString() {
        return this.from + ".." + this.to;
    }
}

