/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.evaluation;

import com.wizzardo.tools.evaluation.Expression;
import com.wizzardo.tools.evaluation.Variable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public class AsBooleanExpression
extends Expression {
    private Expression condition;
    private Boolean result;

    public AsBooleanExpression(Expression condition) {
        this.condition = condition;
    }

    @Override
    public void setVariable(Variable v) {
        this.condition.setVariable(v);
    }

    @Override
    public Expression clone() {
        return new AsBooleanExpression(this.condition.clone());
    }

    @Override
    public Object get(Map<String, Object> model) {
        if (this.result != null) {
            return this.result;
        }
        Object r = this.condition.get(model);
        Boolean result = AsBooleanExpression.toBoolean(r);
        if (this.condition.hardcoded) {
            this.result = result;
        }
        return result;
    }

    public static Boolean toBoolean(Object r) {
        if (r == null) {
            return false;
        }
        if (r instanceof Boolean) {
            return (Boolean)r;
        }
        if (r instanceof String) {
            return ((String)r).length() > 0;
        }
        if (r instanceof Collection) {
            return !((Collection)r).isEmpty();
        }
        if (r instanceof Map) {
            return !((Map)r).isEmpty();
        }
        if (r instanceof Number) {
            return ((Number)r).doubleValue() != 0.0;
        }
        if (r instanceof Iterator) {
            return ((Iterator)r).hasNext();
        }
        if (r instanceof Enumeration) {
            return ((Enumeration)r).hasMoreElements();
        }
        return true;
    }
}

