/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.evaluation;

import com.wizzardo.tools.collections.Pair;
import com.wizzardo.tools.evaluation.EvalTools;
import com.wizzardo.tools.evaluation.Expression;
import com.wizzardo.tools.evaluation.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClosureExpression
extends Expression {
    private List<Expression> expressions = new ArrayList<Expression>();
    private Pair<String, Class>[] args;

    @Override
    public void setVariable(Variable v) {
        for (Expression e : this.expressions) {
            e.setVariable(v);
        }
    }

    @Override
    public Expression clone() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public Object get(Map<String, Object> model) {
        Object ob = null;
        for (Expression expression : this.expressions) {
            ob = expression.get(model);
        }
        return ob;
    }

    public Object get(Map<String, Object> model, Object ... arg) {
        HashMap<String, Object> local = new HashMap<String, Object>(model);
        if (this.args != null) {
            if (this.args.length != arg.length) {
                throw new IllegalArgumentException("wrong number of arguments! there were " + arg.length + ", but must be " + this.args.length);
            }
            for (int i = 0; i < this.args.length; ++i) {
                local.put((String)this.args[i].key, arg[i]);
            }
        }
        Object ob = null;
        for (Expression expression : this.expressions) {
            ob = expression.get(local);
        }
        return ob;
    }

    public void add(Expression expression) {
        this.expressions.add(expression);
    }

    public String parseArguments(String firstLine) {
        int i = firstLine.indexOf("->");
        if (i > 0 && !EvalTools.inString(firstLine, 0, i)) {
            String args = firstLine.substring(0, i).trim();
            firstLine = firstLine.substring(i + 2).trim();
            String[] pairs = args.split(",");
            this.args = new Pair[pairs.length];
            for (i = 0; i < pairs.length; ++i) {
                String[] kv = pairs[i].trim().split(" ");
                this.args[i] = kv.length == 2 ? new Pair((Object)kv[1], Object.class) : new Pair((Object)kv[0], Object.class);
            }
        } else {
            this.args = new Pair[1];
            this.args[0] = new Pair((Object)"it", Object.class);
        }
        return firstLine;
    }

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }
}

