/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.evaluation;

import com.wizzardo.tools.collections.CollectionTools;
import com.wizzardo.tools.evaluation.AsBooleanExpression;
import com.wizzardo.tools.evaluation.ClosureExpression;
import com.wizzardo.tools.evaluation.Expression;
import com.wizzardo.tools.evaluation.Function;
import com.wizzardo.tools.evaluation.IfExpression;
import com.wizzardo.tools.evaluation.MissingMethodException;
import com.wizzardo.tools.evaluation.Operation;
import com.wizzardo.tools.evaluation.Operator;
import com.wizzardo.tools.evaluation.TemplateBuilder;
import com.wizzardo.tools.evaluation.UserFunction;
import com.wizzardo.tools.misc.Unchecked;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EvalTools {
    static final String CONSTRUCTOR = "%constructor%";
    static EvaluatingStrategy defaultEvaluatingStrategy;
    private static AtomicInteger variableCounter;
    private static final Pattern CLEAN_CLASS;
    private static final Pattern NEW;
    private static final Pattern CLASS;
    private static final Pattern CAST;
    private static final Pattern FUNCTION;
    private static final Pattern COMMA;
    private static final Pattern MAP_KEY_VALUE;
    private static final Pattern IF_FOR_WHILE;
    private static final Pattern LIST;
    private static final Pattern VARIABLE;
    private static final Pattern ACTIONS;
    private static final Pattern DEF;
    private static final Pattern BRACKETS;

    protected static int countOpenBrackets(String s, int from, int to) {
        int n = 0;
        for (int i = from; i < to; ++i) {
            if (s.charAt(i) == '(' || s.charAt(i) == '[' || s.charAt(i) == '{') {
                ++n;
                continue;
            }
            if (s.charAt(i) != ')' && s.charAt(i) != ']' && s.charAt(i) != '}') continue;
            --n;
        }
        return n;
    }

    protected static int findCloseBracket(String s, int from) {
        return EvalTools.findCloseBracket(s, from, s.length());
    }

    protected static int findCloseBracket(String s, int from, int to) {
        int i;
        int n = 1;
        boolean inString = false;
        char quote = '\u0000';
        for (i = from; i < to && n > 0; ++i) {
            if (!inString) {
                if ((s.charAt(i) == '\'' || s.charAt(i) == '\"') && (i == 0 || i >= 1 && s.charAt(i - 1) != '\\')) {
                    quote = s.charAt(i);
                    inString = true;
                    continue;
                }
                if (s.charAt(i) == '(' || s.charAt(i) == '[' || s.charAt(i) == '{') {
                    ++n;
                    continue;
                }
                if (s.charAt(i) != ')' && s.charAt(i) != ']' && s.charAt(i) != '}') continue;
                --n;
                continue;
            }
            if (s.charAt(i) != quote || i < 1 || s.charAt(i - 1) == '\\') continue;
            inString = false;
        }
        if (n == 0) {
            return i - 1;
        }
        return -1;
    }

    protected static String getTempVariableName() {
        return "__tempVariable_" + variableCounter.incrementAndGet();
    }

    protected static boolean inString(String s, int from, int to) {
        boolean inString = false;
        char quote = '\u0000';
        for (int i = from; i < to; ++i) {
            if (!inString) {
                if (s.charAt(i) != '\'' && s.charAt(i) != '\"' || i != 0 && (i < 1 || s.charAt(i - 1) == '\\')) continue;
                quote = s.charAt(i);
                inString = true;
                continue;
            }
            if (s.charAt(i) != quote || i < 1 || s.charAt(i - 1) == '\\') continue;
            inString = false;
        }
        return inString;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static LinkedList<String> getParts(String s) {
        LinkedList<String> l = new LinkedList<String>();
        boolean inString = false;
        char quote = '\u0000';
        char[] chars = s.toCharArray();
        int from = 0;
        int brackets = 0;
        int squareBrackets = 0;
        int curlyBraces = 0;
        block10: for (int i = 0; i < chars.length; ++i) {
            if (!inString) {
                switch (chars[i]) {
                    case '\"': 
                    case '\'': {
                        quote = chars[i];
                        inString = true;
                        continue block10;
                    }
                    case '(': {
                        if (brackets == 0 && curlyBraces == 0 && squareBrackets == 0 && i != from) {
                            l.add(new String(chars, from, i - from));
                            from = i;
                        }
                        ++brackets;
                        continue block10;
                    }
                    case '{': {
                        if (brackets == 0 && curlyBraces == 0 && squareBrackets == 0 && i != from) {
                            l.add(new String(chars, from, i - from));
                            from = i;
                        }
                        ++curlyBraces;
                        continue block10;
                    }
                    case '[': {
                        if (brackets == 0 && curlyBraces == 0 && squareBrackets == 0 && i != from) {
                            l.add(new String(chars, from, i - from));
                            from = i;
                        }
                        ++squareBrackets;
                        continue block10;
                    }
                    case ')': {
                        if (--brackets != 0 || curlyBraces != 0 || squareBrackets != 0) break;
                        l.add(new String(chars, from, i + 1 - from));
                        from = i + 1;
                        continue block10;
                    }
                    case '}': {
                        if (brackets != 0 || --curlyBraces != 0 || squareBrackets != 0) break;
                        l.add(new String(chars, from, i + 1 - from));
                        from = i + 1;
                        continue block10;
                    }
                    case ']': {
                        if (brackets != 0 || curlyBraces != 0 || --squareBrackets != 0) break;
                        l.add(new String(chars, from, i + 1 - from));
                        from = i + 1;
                        continue block10;
                    }
                    case '.': {
                        if (brackets != 0 || curlyBraces != 0 || squareBrackets != 0 || i == from) break;
                        if (i > 0 && (chars[i - 1] == '*' || chars[i - 1] == '?')) {
                            if (i - from == 1) continue block10;
                            --i;
                        }
                        l.add(new String(chars, from, i - from));
                        from = i;
                    }
                }
                continue;
            }
            if (chars[i] != quote || i <= 1 || chars[i - 1] == '\\') continue;
            inString = false;
        }
        if (from != chars.length) {
            l.add(new String(chars, from, chars.length - from));
        }
        return l;
    }

    public static void setDefaultEvaluatingStrategy(EvaluatingStrategy defaultEvaluatingStrategy) {
        EvalTools.defaultEvaluatingStrategy = defaultEvaluatingStrategy;
    }

    public static String trimBrackets(String s) {
        int db = s.indexOf("((");
        if (db != -1) {
            String t = s.substring(db + 2);
            Matcher m = BRACKETS.matcher(t);
            int brackets = 2;
            boolean innerBrackets = false;
            while (m.find()) {
                if (m.group().equals("(")) {
                    if (brackets < 2) {
                        innerBrackets = true;
                    }
                    ++brackets;
                } else if (m.group().equals(")")) {
                    --brackets;
                }
                if (innerBrackets || brackets != 0 || m.start() <= 0 || t.charAt(m.start() - 1) != ')') continue;
                return EvalTools.trimBrackets(s.substring(0, db + 1) + t.substring(0, m.start() - 1) + t.substring(m.start()));
            }
        }
        if (s.startsWith("(") && s.endsWith(")")) {
            Matcher m = BRACKETS.matcher(s);
            int brackets = 0;
            while (m.find()) {
                if (m.group().equals("(")) {
                    ++brackets;
                } else if (m.group().equals(")")) {
                    --brackets;
                }
                if (brackets != 0 || m.end() == s.length()) continue;
                return s;
            }
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static boolean isMap(String s) {
        if (!s.startsWith("[") || !s.endsWith("]")) {
            return false;
        }
        boolean quotesSingle = false;
        boolean quotesDouble = false;
        int brackets = 0;
        block7: for (int i = 1; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\'': {
                    if (quotesDouble) continue block7;
                    quotesSingle = !quotesSingle;
                    continue block7;
                }
                case '\"': {
                    if (quotesSingle) continue block7;
                    quotesDouble = !quotesDouble;
                    continue block7;
                }
                case '[': {
                    if (quotesSingle || quotesDouble) continue block7;
                    ++brackets;
                    continue block7;
                }
                case ']': {
                    if (quotesSingle || quotesDouble) continue block7;
                    --brackets;
                    continue block7;
                }
                case ':': {
                    if (quotesSingle || quotesDouble || brackets != 0) continue block7;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isList(String s) {
        return s.startsWith("[") && s.endsWith("]");
    }

    private static boolean isClosure(String exp) {
        return exp.startsWith("{") && exp.endsWith("}");
    }

    static List<String> getLines(String exp) {
        return EvalTools.getLines(exp, false);
    }

    static List<Statement> getStatements(String s) {
        String sub;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        Matcher m = IF_FOR_WHILE.matcher(s);
        int start = 0;
        int to = s.length();
        while (m.find(start)) {
            if (m.start() != start) {
                statements.add(new Statement(s.substring(start, m.start())));
            }
            Statement statement = new Statement();
            start = EvalTools.getBlock(s, m.start(), to, statement);
            statements.add(statement.bodyStatement);
        }
        if (start != to && (sub = s.substring(start, to).trim()).length() > 0) {
            statements.add(new Statement(sub));
        }
        return statements;
    }

    static int getBlock(String s, int from, int to, Statement statement) {
        int start;
        Matcher m = IF_FOR_WHILE.matcher(s);
        if (m.find(start = from)) {
            String before = s.substring(start, m.start()).trim();
            if (before.length() > 0) {
                return EvalTools.getStringBlock(s, from, to, statement);
            }
            if (m.start() >= to || m.end() >= to) {
                return -1;
            }
            int close = EvalTools.findCloseBracket(s, m.end());
            if (close < 0) {
                throw new IllegalStateException("can't find closing bracket in expression: " + s);
            }
            Statement inner = new Statement();
            if (statement.bodyStatement == null && statement.body == null) {
                statement.bodyStatement = inner;
            } else {
                statement.optionalStatement = inner;
            }
            inner.type = Statement.Type.valueOf(m.group(1).toUpperCase());
            inner.statement = s.substring(m.end(), close);
            char ch = '\u0000';
            for (start = close + 1; start < to && ((ch = s.charAt(start)) == ' ' || ch == '\n' || ch == '\t'); ++start) {
            }
            if (start == to) {
                throw new IllegalStateException("can't find block: " + s.substring(from, to));
            }
            if (ch == '{') {
                if ((close = EvalTools.findCloseBracket(s, ++start, to)) < 0) {
                    throw new IllegalStateException("can't find closing bracket in expression: " + s.substring(from, to));
                }
                inner.body = s.substring(start, close);
                start = close + 1;
                if (inner.type == Statement.Type.IF) {
                    return EvalTools.getElse(s, start, to, inner);
                }
                return start;
            }
            start = EvalTools.getBlock(s, start, to, inner);
            if (inner.type == Statement.Type.IF) {
                return EvalTools.getElse(s, start, to, inner);
            }
            return start;
        }
        return EvalTools.getStringBlock(s, from, to, statement);
    }

    static int getStringBlock(String s, int from, int to, Statement statement) {
        char last = '\u0000';
        char stringChar = '\u0000';
        boolean inString = false;
        int brackets = 0;
        for (int i = from; i < to; ++i) {
            char c = s.charAt(i);
            if (inString) {
                if (c == stringChar && last != '\\') {
                    inString = false;
                }
            } else {
                if (c == '(' || c == '[' || c == '{') {
                    ++brackets;
                } else if (c == ')' || c == ']' || c == '}') {
                    --brackets;
                }
                if (brackets == 0) {
                    if (c == ';' || c == '\n') {
                        if (statement.bodyStatement == null && statement.body == null) {
                            statement.body = s.substring(from, i).trim();
                        } else {
                            statement.optional = s.substring(from, i).trim();
                        }
                        return i + (c == ';' ? 1 : 0);
                    }
                    if (c == '\"' || c == '\'') {
                        inString = true;
                    }
                }
            }
            last = c;
        }
        if (statement.bodyStatement == null && statement.body == null) {
            statement.body = s.substring(from, to).trim();
        } else {
            statement.optional = s.substring(from, to).trim();
        }
        return to;
    }

    static int getElse(String s, int from, int to, Statement statement) {
        char ch;
        int start;
        for (start = from; start < to && ((ch = s.charAt(start)) == ' ' || ch == '\n' || ch == '\t'); ++start) {
        }
        if (start >= to - 4 || !s.startsWith("else", start)) {
            return start;
        }
        ch = s.charAt(start += 4);
        if (ch != ' ' && ch != '\n' && ch != '\t' && ch != '{' && ch != ';') {
            return start - 4;
        }
        while (start < to && ((ch = s.charAt(start)) == ' ' || ch == '\n' || ch == '\t')) {
            ++start;
        }
        if (start == to) {
            throw new IllegalStateException("can't find block: " + s.substring(from, to));
        }
        if (ch == '{') {
            int close;
            if ((close = EvalTools.findCloseBracket(s, ++start, to)) < 0) {
                throw new IllegalStateException("can't find closing bracket in expression: " + s.substring(from, to));
            }
            statement.optional = s.substring(start, close);
            return close + 1;
        }
        return EvalTools.getBlock(s, start, to, statement);
    }

    static List<String> getLines(String exp, boolean ignoreNewLine) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char stringChar = '\u0000';
        boolean inString = false;
        int brackets = 0;
        for (char c : exp.toCharArray()) {
            if (inString) {
                if (c == stringChar && last != '\\') {
                    inString = false;
                }
            } else {
                if (c == '(' || c == '[' || c == '{') {
                    ++brackets;
                } else if (c == ')' || c == ']' || c == '}') {
                    --brackets;
                }
                if (ignoreNewLine && c == '\n') continue;
                if (brackets == 0) {
                    if (c == ';' || c == '\n') {
                        String value = sb.toString().trim();
                        if (value.length() > 0) {
                            list.add(value);
                        }
                        sb.setLength(0);
                        continue;
                    }
                    if (c == '\"' || c == '\'') {
                        stringChar = c;
                        inString = true;
                    }
                }
            }
            last = c;
            sb.append(c);
        }
        String value = sb.toString().trim();
        if (value.length() > 0) {
            list.add(sb.toString().trim());
        }
        return list;
    }

    public static Expression prepareTemplate(String exp) {
        return EvalTools.prepare(exp, null, null, null, true);
    }

    public static Expression prepare(String exp) {
        return EvalTools.prepare(exp, null);
    }

    public static Expression prepare(String exp, Map<String, Object> model) {
        return EvalTools.prepare(exp, model, null);
    }

    public static Expression prepare(String exp, Map<String, Object> model, Map<String, UserFunction> functions) {
        return EvalTools.prepare(exp, model, functions, null, false);
    }

    public static Expression prepare(String exp, Map<String, Object> model, Map<String, UserFunction> functions, List<String> imports) {
        return EvalTools.prepare(exp, model, functions, imports, false);
    }

    public static Expression prepare(String exp, Map<String, Object> model, Map<String, UserFunction> functions, List<String> imports, boolean isTemplate) {
        Matcher m;
        if (exp == null) {
            return null;
        }
        if (!isTemplate) {
            exp = exp.trim();
            String trimmed = EvalTools.trimBrackets(exp);
            while (trimmed != exp) {
                exp = trimmed;
                trimmed = EvalTools.trimBrackets(exp);
            }
            if (exp.length() == 0) {
                return null;
            }
        }
        if (isTemplate && exp.length() == 0) {
            return new Expression.Holder("", true);
        }
        if (model == null) {
            model = new HashMap<String, Object>();
        }
        if (functions == null) {
            functions = new HashMap<String, UserFunction>();
        }
        if (!isTemplate && exp.startsWith("\"") && exp.endsWith("\"") && EvalTools.inString(exp, 0, exp.length() - 1)) {
            return EvalTools.prepare(exp.substring(1, exp.length() - 1), model, functions, imports, true);
        }
        if (isTemplate) {
            m = VARIABLE.matcher(exp);
            TemplateBuilder tb = new TemplateBuilder();
            int last = 0;
            while (m.find()) {
                String sub;
                if (m.start() != last) {
                    tb.append(exp.substring(last, m.start()));
                }
                if ((sub = m.group(1)) == null) {
                    sub = m.group(2);
                }
                tb.append(EvalTools.prepare(sub, model, functions, imports, false));
                last = m.end();
            }
            if (last != exp.length()) {
                tb.append(exp.substring(last, exp.length()));
            }
            return tb;
        }
        if (EvalTools.isClosure(exp)) {
            exp = exp.substring(1, exp.length() - 1).trim();
            ClosureExpression closure = new ClosureExpression();
            List<String> lines = EvalTools.getLines(exp);
            String firstLine = lines.get(0);
            if ((firstLine = closure.parseArguments(firstLine)).length() == 0) {
                lines.remove(0);
            } else {
                lines.set(0, firstLine);
            }
            for (String s : lines) {
                closure.add(EvalTools.prepare(s, model, functions, imports, isTemplate));
            }
            return closure;
        }
        List<Statement> statements = EvalTools.getStatements(exp);
        ClosureExpression closure = new ClosureExpression();
        block7: for (Statement s : statements) {
            switch (s.type) {
                case IF: 
                case FOR: 
                case WHILE: {
                    closure.add(s.prepare(model, functions, imports));
                    continue block7;
                }
                case BLOCK: {
                    List<String> lines = EvalTools.getLines(s.statement);
                    if (lines.size() > 1) {
                        ClosureExpression inner = new ClosureExpression();
                        for (String line : lines) {
                            inner.add(EvalTools.prepare(line, model, functions, imports, isTemplate));
                        }
                        closure.add(inner);
                        continue block7;
                    }
                    if (statements.size() <= 1) continue block7;
                    closure.add(EvalTools.prepare(s.statement, model, functions, imports, isTemplate));
                    continue block7;
                }
            }
            throw new IllegalStateException("not implemented yet");
        }
        if (!closure.isEmpty()) {
            return closure;
        }
        if (exp.equals("null")) {
            return Expression.Holder.NULL;
        }
        Object obj = Expression.parse(exp);
        if (obj != null) {
            return new Expression.Holder(exp);
        }
        if (model.containsKey(exp)) {
            return new Expression.Holder(exp);
        }
        Matcher m2 = DEF.matcher(exp);
        if (m2.find()) {
            model.put(m2.group(1), null);
            return new Expression.Holder(m2.group(1));
        }
        m = ACTIONS.matcher(exp);
        ArrayList<String> exps = new ArrayList<String>();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        int last = 0;
        Operation operation = null;
        Expression lastExpressionHolder = null;
        boolean ternary = false;
        int ternaryInner = 0;
        while (m.find()) {
            if (ternary) {
                if (m.group().equals("?")) {
                    ++ternaryInner;
                    continue;
                }
                if (!m.group().equals(":")) continue;
                if (ternaryInner > 0) {
                    --ternaryInner;
                    continue;
                }
            }
            if ("?.".equals(m.group()) || EvalTools.countOpenBrackets(exp, last, m.start()) != 0 || EvalTools.inString(exp, last, m.start())) continue;
            exps.add(exp.substring(last, m.start()).trim());
            lastExpressionHolder = EvalTools.prepare(exp.substring(last, m.start()), model, functions, imports, isTemplate);
            if (operation != null) {
                operation.end(m.start());
                operation.rightPart(lastExpressionHolder);
            }
            operation = new Operation(lastExpressionHolder, Operator.get(m.group()), last, m.end());
            operations.add(operation);
            last = m.end();
            if (ternary) {
                lastExpressionHolder = EvalTools.prepare(exp.substring(last, exp.length()), model, functions, imports, isTemplate);
                operation.rightPart(lastExpressionHolder);
                break;
            }
            if (!m.group().equals("?")) continue;
            ternary = true;
        }
        if (operation != null) {
            if (last != exp.length()) {
                exps.add(exp.substring(last).trim());
                operation.end(exp.length());
                operation.rightPart(EvalTools.prepare(exp.substring(last), model, functions, imports, isTemplate));
            }
            Expression eh = null;
            while (operations.size() > 0) {
                operation = null;
                int n = 0;
                for (int i = 0; i < operations.size(); ++i) {
                    if (operation != null && ((Operation)operations.get((int)i)).operator().priority <= operation.operator().priority) continue;
                    operation = (Operation)operations.get(i);
                    n = i;
                }
                if (operation.operator() == Operator.TERNARY) {
                    int ternaryIndex = n;
                    operation = null;
                    n = 0;
                    for (int i = 0; i < ternaryIndex; ++i) {
                        if (operation != null && ((Operation)operations.get((int)i)).operator().priority <= operation.operator().priority) continue;
                        operation = (Operation)operations.get(i);
                        n = i;
                    }
                    if (operation == null) {
                        operation = (Operation)operations.get(0);
                    }
                }
                if (operation.operator() == Operator.TERNARY) {
                    operation.rightPart((Expression)operations.remove(n + 1));
                }
                if (n > 0) {
                    ((Operation)operations.get(n - 1)).rightPart(operation);
                }
                if (n < operations.size() - 1) {
                    ((Operation)operations.get(n + 1)).leftPart(operation);
                }
                eh = (Expression)operations.remove(n);
            }
            return eh;
        }
        if (exp.equals("[]")) {
            return new Expression.CollectionExpression();
        }
        if (exp.equals("[:]")) {
            return new Expression.MapExpression();
        }
        if (EvalTools.isMap(exp)) {
            LinkedHashMap<String, Expression> map = new LinkedHashMap<String, Expression>();
            for (Map.Entry<String, String> entry : EvalTools.parseMap(exp).entrySet()) {
                map.put(entry.getKey(), EvalTools.prepare(entry.getValue(), model, functions, imports, isTemplate));
            }
            return new Expression.MapExpression(map);
        }
        if (EvalTools.isList(exp)) {
            ArrayList<Expression> l = new ArrayList<Expression>();
            exp = exp.substring(1, exp.length() - 1);
            List<String> arr = EvalTools.parseArgs(exp);
            for (String anArr : arr) {
                l.add(EvalTools.prepare(anArr, model, functions, imports, isTemplate));
            }
            return new Expression.CollectionExpression(l);
        }
        Expression thatObject = null;
        String methodName = null;
        Matcher m3 = NEW.matcher(exp);
        if (m3.find()) {
            Class clazz = EvalTools.findClass(m3.group().substring(4), imports);
            if (clazz != null) {
                thatObject = new Expression.Holder(clazz);
                exp = exp.substring(m3.end());
                methodName = CONSTRUCTOR;
            } else {
                Unchecked.rethrow((Exception)new ClassNotFoundException("Can not find class '" + m3.group().substring(4) + "'"));
            }
        }
        if (thatObject == null && (m3 = LIST.matcher(exp)).find()) {
            thatObject = new Expression.Holder(m3.group(1));
            exp = exp.substring(m3.group(1).length());
        }
        if (thatObject == null) {
            String s = exp;
            Matcher m4 = CLASS.matcher(exp);
            while (m4.find()) {
                String className = m4.start(3) >= 0 ? exp.substring(0, m4.start(3)) + "$" + exp.substring(m4.start(3) + 1, m4.end(3)) : m4.group();
                Class clazz = EvalTools.findClass(className, imports);
                if (clazz != null) {
                    thatObject = new Expression.Holder(clazz);
                    exp = exp.substring(m4.end());
                    break;
                }
                int i = s.lastIndexOf(".");
                if (i <= 0) continue;
                s = s.substring(0, i);
                m4 = CLASS.matcher(s);
            }
        }
        if (thatObject == null) {
            m3 = CAST.matcher(exp);
            while (m3.find()) {
                if (m3.start(4) >= 0) {
                    exp = exp.substring(0, m3.start(4)) + exp.substring(m3.end(4));
                    m3 = CAST.matcher(exp);
                    continue;
                }
                String className = m3.group();
                className = m3.start(3) >= 0 ? exp.substring(1, m3.start(3)) + "$" + exp.substring(m3.start(3) + 1, m3.end(3)) : className.substring(1, className.length() - 1);
                Class clazz = EvalTools.findClass(className, imports);
                if (clazz == null) continue;
                exp = exp.substring(m3.end());
                return new Expression.CastExpression(clazz, EvalTools.prepare(exp, model, functions, imports, isTemplate));
            }
        }
        if (thatObject == null && (m3 = FUNCTION.matcher(exp)).find()) {
            UserFunction function = functions.get(m3.group(1)).clone();
            thatObject = function;
            exp = exp.substring(function.getName().length());
        }
        LinkedList<String> parts = EvalTools.getParts(exp);
        String last2 = null;
        while (!parts.isEmpty()) {
            String field;
            int i;
            Expression[] args;
            String temp = ((Object)parts).toString();
            if (temp.equals(last2)) {
                throw new IllegalStateException("loop at " + exp + "\t\t" + parts);
            }
            last2 = temp;
            if (thatObject == null && parts.size() == 1 && ((String)parts.get(0)).equals(exp)) {
                thatObject = new Expression.Holder((String)parts.remove(0));
                continue;
            }
            if (thatObject == null) {
                thatObject = EvalTools.prepare((String)parts.remove(0), model, functions, imports, isTemplate);
                continue;
            }
            if (parts.size() >= 2 && ((String)parts.get(0)).startsWith(".") && (((String)parts.get(1)).startsWith("(") && ((String)parts.get(1)).endsWith(")") || ((String)parts.get(1)).startsWith("{") && ((String)parts.get(1)).endsWith("}"))) {
                methodName = ((String)parts.remove(0)).substring(1);
                args = null;
                String argsRaw = EvalTools.trimBrackets((String)parts.remove(0));
                if (argsRaw.length() > 0) {
                    List<String> arr = EvalTools.parseArgs(argsRaw);
                    args = new Expression[arr.size()];
                    for (i = 0; i < arr.size(); ++i) {
                        args[i] = EvalTools.prepare(arr.get(i), model, functions, imports, isTemplate);
                    }
                }
                thatObject = new Function(thatObject, methodName, args);
                continue;
            }
            if (parts.size() >= 2 && ((String)parts.get(0)).startsWith("?.") && (((String)parts.get(1)).startsWith("(") && ((String)parts.get(1)).endsWith(")") || ((String)parts.get(1)).startsWith("{") && ((String)parts.get(1)).endsWith("}"))) {
                methodName = ((String)parts.remove(0)).substring(2);
                args = null;
                String argsRaw = EvalTools.trimBrackets((String)parts.remove(0));
                if (argsRaw.length() > 0) {
                    List<String> arr = EvalTools.parseArgs(argsRaw);
                    args = new Expression[arr.size()];
                    for (i = 0; i < arr.size(); ++i) {
                        args[i] = EvalTools.prepare(arr.get(i), model, functions, imports, isTemplate);
                    }
                }
                thatObject = new Function(thatObject, methodName, args, true);
                continue;
            }
            if (parts.size() >= 1 && ((String)parts.get(0)).startsWith("*.")) {
                String var = EvalTools.getTempVariableName();
                Expression[] args2 = new Expression[1];
                methodName = ((String)parts.remove(0)).substring(1);
                String argsRaw = parts.size() >= 1 && ((String)parts.get(0)).startsWith("(") && ((String)parts.get(0)).endsWith(")") ? (String)parts.remove(0) : "";
                args2[0] = EvalTools.prepare("{" + var + " -> " + var + methodName + argsRaw + "}", model, functions, imports, isTemplate);
                thatObject = new Function(thatObject, "collect", args2);
                continue;
            }
            if (((String)parts.get(0)).startsWith("(") && ((String)parts.get(0)).endsWith(")")) {
                args = null;
                String argsRaw = EvalTools.trimBrackets((String)parts.remove(0));
                if (argsRaw.length() > 0) {
                    List<String> arr = EvalTools.parseArgs(argsRaw);
                    args = new Expression[arr.size()];
                    for (i = 0; i < arr.size(); ++i) {
                        args[i] = EvalTools.prepare(arr.get(i), model, functions, imports, isTemplate);
                    }
                }
                if (thatObject instanceof UserFunction) {
                    UserFunction function = (UserFunction)thatObject;
                    function.setArgs(args);
                    function.setUserFunctions(functions);
                    continue;
                }
                thatObject = new Function(thatObject, methodName, args);
                continue;
            }
            if (((String)parts.get(0)).startsWith(".")) {
                field = ((String)parts.remove(0)).substring(1);
                thatObject = new Function(thatObject, field);
                continue;
            }
            if (((String)parts.get(0)).startsWith("?.")) {
                field = ((String)parts.remove(0)).substring(2);
                thatObject = new Function(thatObject, field, true);
                continue;
            }
            if (!((String)parts.get(0)).startsWith("[") || !((String)parts.get(0)).endsWith("]")) continue;
            String argsRaw = (String)parts.remove(0);
            argsRaw = argsRaw.substring(1, argsRaw.length() - 1);
            thatObject = new Operation(thatObject, EvalTools.prepare(argsRaw, model, functions, imports, isTemplate), Operator.GET);
        }
        return thatObject;
    }

    private static Class findClass(String s) {
        return EvalTools.findClass(s, null);
    }

    private static Class findClass(String s, List<String> imports) {
        try {
            return ClassLoader.getSystemClassLoader().loadClass(s);
        }
        catch (ClassNotFoundException ignored) {
            try {
                return ClassLoader.getSystemClassLoader().loadClass("java.lang." + s);
            }
            catch (ClassNotFoundException ignored2) {
                try {
                    return ClassLoader.getSystemClassLoader().loadClass("java.util." + s);
                }
                catch (ClassNotFoundException ignored3) {
                    if (imports != null) {
                        String subClass;
                        String mainClass;
                        for (String imp : imports) {
                            if (imp.endsWith("." + s)) {
                                try {
                                    return ClassLoader.getSystemClassLoader().loadClass(imp);
                                }
                                catch (ClassNotFoundException ignored4) {
                                    // empty catch block
                                }
                            }
                            if (!imp.endsWith(".*")) continue;
                            try {
                                return ClassLoader.getSystemClassLoader().loadClass(imp.substring(0, imp.length() - 1) + s);
                            }
                            catch (ClassNotFoundException ignored5) {
                            }
                        }
                        if (s.contains("$")) {
                            mainClass = s.substring(0, s.indexOf(36));
                            subClass = s.substring(s.indexOf(36) + 1);
                            for (String imp : imports) {
                                if (!imp.endsWith("." + mainClass)) continue;
                                try {
                                    return ClassLoader.getSystemClassLoader().loadClass(imp + "$" + subClass);
                                }
                                catch (ClassNotFoundException ignored6) {
                                }
                            }
                        }
                        if (s.contains(".")) {
                            mainClass = s.substring(0, s.indexOf(46));
                            subClass = s.substring(s.indexOf(46) + 1);
                            for (String imp : imports) {
                                if (!imp.endsWith("." + mainClass)) continue;
                                try {
                                    return ClassLoader.getSystemClassLoader().loadClass(imp + "$" + subClass);
                                }
                                catch (ClassNotFoundException ignored7) {
                                }
                            }
                        }
                    }
                    return null;
                }
            }
        }
    }

    private static List<String> parseArgs(String argsRaw) {
        ArrayList<String> l = new ArrayList<String>();
        Matcher m = COMMA.matcher(argsRaw);
        int last = 0;
        while (m.find()) {
            if (EvalTools.countOpenBrackets(argsRaw, last, m.start()) != 0) continue;
            l.add(argsRaw.substring(last, m.start()).trim());
            last = m.end();
        }
        if (last > 0) {
            l.add(argsRaw.substring(last).trim());
        } else if (last == 0 && argsRaw.length() > 0) {
            l.add(argsRaw.trim());
        }
        int mapStart = -1;
        int mapEnd = -1;
        while (mapStart == -1) {
            for (int i = 0; i < l.size(); ++i) {
                String arg = l.get(i);
                if (MAP_KEY_VALUE.matcher(arg).matches()) {
                    if (mapStart == -1) {
                        mapStart = mapEnd = i;
                        continue;
                    }
                    mapEnd = i;
                    continue;
                }
                if (mapStart != -1) break;
            }
            if (mapStart == -1) break;
            StringBuilder sb = new StringBuilder("[");
            for (int i = mapStart; i <= mapEnd; ++i) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(l.remove(mapStart));
            }
            sb.append("]");
            l.add(mapStart, sb.toString());
            mapStart = -1;
            mapEnd = -1;
        }
        return l;
    }

    private static Map<String, String> parseMap(String s) {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        s = s.substring(1, s.length() - 1);
        boolean quotesSingle = false;
        boolean quotesDouble = false;
        StringBuilder sb = new StringBuilder();
        String key = null;
        boolean escape = false;
        int brackets = 0;
        block11: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\'': {
                    sb.append(ch);
                    if (!quotesDouble && !escape) {
                        quotesSingle = !quotesSingle;
                    }
                    escape = false;
                    continue block11;
                }
                case '\"': {
                    sb.append(ch);
                    if (!quotesSingle && !escape) {
                        quotesDouble = !quotesDouble;
                    }
                    escape = false;
                    continue block11;
                }
                case '(': {
                    if (!quotesSingle && !quotesDouble) {
                        ++brackets;
                    }
                    sb.append(ch);
                    continue block11;
                }
                case '[': {
                    if (!quotesSingle && !quotesDouble) {
                        ++brackets;
                    }
                    sb.append(ch);
                    continue block11;
                }
                case ')': {
                    if (!quotesSingle && !quotesDouble) {
                        --brackets;
                    }
                    sb.append(ch);
                    continue block11;
                }
                case ']': {
                    if (!quotesSingle && !quotesDouble) {
                        --brackets;
                    }
                    sb.append(ch);
                    continue block11;
                }
                case ':': {
                    if (brackets > 0) {
                        sb.append(ch);
                        continue block11;
                    }
                    if (!quotesSingle && !quotesDouble) {
                        key = sb.toString().trim();
                        sb.setLength(0);
                        continue block11;
                    }
                    sb.append(ch);
                    continue block11;
                }
                case ',': {
                    if (brackets > 0) {
                        sb.append(ch);
                        continue block11;
                    }
                    if (!quotesSingle && !quotesDouble) {
                        String value = sb.toString().trim();
                        m.put(key, value);
                        key = null;
                        sb.setLength(0);
                        continue block11;
                    }
                    sb.append(ch);
                    continue block11;
                }
                case '\\': {
                    boolean bl = escape = !escape;
                    if (escape) continue block11;
                    sb.append(ch);
                    continue block11;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        if (sb.length() > 0) {
            String value = sb.toString().trim();
            m.put(key, value);
        }
        return m;
    }

    public static <T> T evaluate(String exp) {
        Expression ex = EvalTools.prepare(exp, null);
        return (T)ex.get(null);
    }

    public static <T> T evaluate(String exp, Map<String, Object> model) {
        Expression ex = EvalTools.prepare(exp, model);
        return (T)ex.get(model);
    }

    public static <T> T evaluate(String exp, Map<String, Object> model, Map<String, UserFunction> functions) {
        Expression ex = EvalTools.prepare(exp, model, functions);
        return (T)ex.get(model);
    }

    static {
        variableCounter = new AtomicInteger();
        CLEAN_CLASS = Pattern.compile("([a-z]+\\.)*(\\b[A-Z][a-zA-Z\\d]+)(\\.[A-Z][a-zA-Z\\d]+)*");
        NEW = Pattern.compile("^new +" + CLEAN_CLASS.pattern());
        CLASS = Pattern.compile("^" + CLEAN_CLASS.pattern());
        CAST = Pattern.compile("^\\(" + CLEAN_CLASS.pattern() + "(\\<(\\s*" + CLEAN_CLASS.pattern() + "\\s*,*)+\\>)*" + "\\)");
        FUNCTION = Pattern.compile("^([a-z_]+\\w*)\\(.+");
        COMMA = Pattern.compile(",");
        MAP_KEY_VALUE = Pattern.compile("[a-zA-Z\\d]+ *: *.+");
        IF_FOR_WHILE = Pattern.compile("(if|for|while) *\\(");
        LIST = Pattern.compile("([a-z]+[a-zA-Z\\d]*)\\[");
        VARIABLE = Pattern.compile("\\$\\{([^\\{\\}]+)\\}|\\$([\\.a-z]+[\\.a-zA-Z]*)");
        ACTIONS = Pattern.compile("\\+\\+|--|\\.\\.|\\?:|\\?\\.|\\*=|\\*(?!\\.)|/=?|\\+=?|-=?|:|<<|<=?|>=?|==?|%|!=?|\\?|&&?|\\|\\|?");
        DEF = Pattern.compile("def +([a-z]+[a-zA-Z_\\d]*)$");
        BRACKETS = Pattern.compile("[\\(\\)]");
        Function.setMethod(Collection.class, "collect", new CollectionTools.Closure3<Object, Object, Map, Expression[]>(){

            public Object execute(Object it, Map model, Expression[] args) {
                ArrayList<Object> l = new ArrayList<Object>();
                ClosureExpression closure = (ClosureExpression)args[0];
                Collection c = (Collection)it;
                for (Object ob : c) {
                    l.add(closure.get(model, ob));
                }
                return l;
            }
        });
        Function.setMethod(Collection.class, "find", new CollectionTools.Closure3<Object, Object, Map, Expression[]>(){

            public Object execute(Object it, Map model, Expression[] args) {
                Collection c = (Collection)it;
                ClosureExpression closure = (ClosureExpression)args[0];
                for (Object ob : c) {
                    if (!((Boolean)closure.get(model, ob)).booleanValue()) continue;
                    return ob;
                }
                return null;
            }
        });
        Function.setMethod(Collection.class, "findAll", new CollectionTools.Closure3<Object, Object, Map, Expression[]>(){

            public Object execute(Object it, Map model, Expression[] args) {
                ArrayList l = new ArrayList();
                Collection c = (Collection)it;
                ClosureExpression closure = (ClosureExpression)args[0];
                for (Object ob : c) {
                    if (!((Boolean)closure.get(model, ob)).booleanValue()) continue;
                    l.add(ob);
                }
                return l;
            }
        });
        Function.setMethod(Collection.class, "findIndexOf", new CollectionTools.Closure3<Object, Object, Map, Expression[]>(){

            public Object execute(Object it, Map model, Expression[] args) {
                Collection c = (Collection)it;
                ClosureExpression closure = (ClosureExpression)args[0];
                int i = 0;
                for (Object ob : c) {
                    if (((Boolean)closure.get(model, ob)).booleanValue()) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        });
        Function.setMethod(Collection.class, "each", new CollectionTools.Closure3<Object, Object, Map, Expression[]>(){

            public Object execute(Object it, Map model, Expression[] args) {
                Collection c = (Collection)it;
                ClosureExpression closure = (ClosureExpression)args[0];
                for (Object ob : c) {
                    closure.get(model, ob);
                }
                return null;
            }
        });
        Function.setMethod(Collection.class, "eachWithIndex", new CollectionTools.Closure3<Object, Object, Map, Expression[]>(){

            public Object execute(Object it, Map model, Expression[] args) {
                Collection c = (Collection)it;
                ClosureExpression closure = (ClosureExpression)args[0];
                int i = 0;
                for (Object ob : c) {
                    closure.get(model, ob, i++);
                }
                return null;
            }
        });
        Function.setMethod(Collection.class, "every", new CollectionTools.Closure3<Object, Object, Map, Expression[]>(){

            public Object execute(Object it, Map model, Expression[] args) {
                Collection c = (Collection)it;
                ClosureExpression closure = (ClosureExpression)args[0];
                for (Object ob : c) {
                    if (((Boolean)closure.get(model, ob)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        });
        Function.setMethod(Collection.class, "any", new CollectionTools.Closure3<Object, Object, Map, Expression[]>(){

            public Object execute(Object it, Map model, Expression[] args) {
                Collection c = (Collection)it;
                ClosureExpression closure = (ClosureExpression)args[0];
                for (Object ob : c) {
                    if (!((Boolean)closure.get(model, ob)).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        });
        Function.setMethod(Collection.class, "join", new CollectionTools.Closure3<Object, Object, Map, Expression[]>(){

            public Object execute(Object it, Map model, Expression[] args) {
                StringBuilder sb = new StringBuilder();
                Collection c = (Collection)it;
                for (Object ob : c) {
                    if (sb.length() != 0) {
                        sb.append(args[0].get(model));
                    }
                    sb.append(ob);
                }
                return sb.toString();
            }
        });
        Function.setMethod(Number.class, "multiply", new CollectionTools.Closure3<Object, Object, Map, Expression[]>(){

            public Object execute(Object it, Map model, Expression[] args) {
                if (args.length != 1) {
                    throw new MissingMethodException(it.getClass(), "multiply", args);
                }
                return Operation.multiply(it, args[0].get(model));
            }
        });
    }

    static class Statement {
        Type type = Type.BLOCK;
        String statement;
        String body;
        String optional;
        Statement bodyStatement;
        Statement optionalStatement;

        public Statement(String statement) {
            this.statement = statement;
        }

        public Statement() {
        }

        public Expression prepare(Map<String, Object> model, Map<String, UserFunction> functions, List<String> imports) {
            switch (this.type) {
                case IF: {
                    Expression elseExpression;
                    List<String> args = EvalTools.getLines(this.statement, true);
                    if (args.size() > 1) {
                        throw new IllegalStateException("more then one statement in condition: " + this.statement);
                    }
                    AsBooleanExpression condition = new AsBooleanExpression(EvalTools.prepare(args.get(0), model, functions, imports));
                    Expression then = this.bodyStatement != null ? this.bodyStatement.prepare(model, functions, imports) : EvalTools.prepare(this.body, model, functions, imports);
                    Expression expression = elseExpression = this.optionalStatement != null ? this.optionalStatement.prepare(model, functions, imports) : EvalTools.prepare(this.optional, model, functions, imports);
                    if (elseExpression == null) {
                        return new IfExpression(condition, then);
                    }
                    return new IfExpression(condition, then, elseExpression);
                }
            }
            throw new IllegalStateException("not implemented yet");
        }

        static enum Type {
            FOR,
            WHILE,
            IF,
            BLOCK;

        }
    }

    public static enum EvaluatingStrategy {
        DEFAULT_JAVA,
        FLOAT,
        DOUBLE;

    }
}

