/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.evaluation;

import com.wizzardo.tools.evaluation.Variable;
import com.wizzardo.tools.misc.Unchecked;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Expression {
    protected String exp;
    protected Object result;
    protected boolean hardcoded = false;
    private static final Pattern string = Pattern.compile("\"(.*)\"|'(.*)'");
    private static final Pattern number = Pattern.compile("(\\d+\\.?\\d*)([dflb]?)");
    private static final Pattern bool = Pattern.compile("true|false", 2);

    public String raw() {
        return this.exp;
    }

    public abstract void setVariable(Variable var1);

    public abstract Expression clone();

    public abstract Object get(Map<String, Object> var1);

    public Object get() {
        return this.get(null);
    }

    public boolean isHardcoded() {
        return this.hardcoded;
    }

    static Object parse(String exp) {
        if (exp == null) {
            return null;
        }
        Matcher m = string.matcher(exp);
        if (m.matches()) {
            return m.group(1) == null ? m.group(2).replace("\\'", "'") : m.group(1).replace("\\\"", "\"");
        }
        m = number.matcher(exp);
        if (m.matches()) {
            if (m.groupCount() > 1 && m.group(2).length() > 0) {
                if ("d".equals(m.group(2))) {
                    return Double.valueOf(m.group(1));
                }
                if ("f".equals(m.group(2))) {
                    return Float.valueOf(m.group(1));
                }
                if ("l".equals(m.group(2))) {
                    return Long.valueOf(m.group(1));
                }
                if ("b".equals(m.group(2))) {
                    return Byte.valueOf(m.group(1));
                }
            } else {
                try {
                    return Integer.valueOf(exp);
                }
                catch (NumberFormatException e) {
                    return Double.valueOf(exp);
                }
            }
        }
        if ((m = bool.matcher(exp)).matches()) {
            return Boolean.valueOf(exp);
        }
        return null;
    }

    public String toString() {
        return this.exp;
    }

    public static class CastExpression
    extends Expression {
        protected Class clazz;
        protected Expression inner;

        public CastExpression(Class clazz, Expression inner) {
            this.clazz = clazz;
            this.inner = inner;
        }

        @Override
        public void setVariable(Variable v) {
            this.inner.setVariable(v);
        }

        @Override
        public Expression clone() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        @Override
        public Object get(Map<String, Object> model) {
            Object o = this.inner.get(model);
            try {
                return this.clazz.cast(o);
            }
            catch (ClassCastException e) {
                throw new ClassCastException(o.getClass().getCanonicalName() + " cannot be cast to " + this.clazz.getCanonicalName());
            }
        }
    }

    public static class CollectionExpression
    extends Expression {
        protected Collection<Expression> collection;

        public CollectionExpression(Collection<Expression> collection) {
            this.collection = collection;
        }

        public CollectionExpression() {
        }

        @Override
        public String toString() {
            if (this.collection != null) {
                return "new " + this.collection.getClass();
            }
            return "new ArrayList";
        }

        @Override
        public void setVariable(Variable v) {
            if (this.collection == null) {
                return;
            }
            for (Expression e : this.collection) {
                e.setVariable(v);
            }
        }

        @Override
        public Expression clone() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        @Override
        public Object get(Map<String, Object> model) {
            if (this.collection == null) {
                return new ArrayList();
            }
            Collection r = null;
            try {
                r = (Collection)this.collection.getClass().newInstance();
            }
            catch (InstantiationException e) {
                throw Unchecked.rethrow((Exception)e);
            }
            catch (IllegalAccessException e) {
                throw Unchecked.rethrow((Exception)e);
            }
            Iterator<Expression> i = this.collection.iterator();
            while (i.hasNext()) {
                r.add(i.next().get(model));
            }
            return r;
        }
    }

    public static class MapExpression
    extends Expression {
        protected Map<String, Expression> map;

        public MapExpression(Map<String, Expression> map) {
            this.map = map;
        }

        public MapExpression() {
        }

        @Override
        public void setVariable(Variable v) {
            if (this.map == null) {
                return;
            }
            for (Map.Entry<String, Expression> e : this.map.entrySet()) {
                e.getValue().setVariable(v);
            }
        }

        @Override
        public Expression clone() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        @Override
        public Object get(Map<String, Object> model) {
            if (this.map == null) {
                return new HashMap();
            }
            Map r = null;
            try {
                r = (Map)this.map.getClass().newInstance();
            }
            catch (InstantiationException e) {
                throw Unchecked.rethrow((Exception)e);
            }
            catch (IllegalAccessException e) {
                throw Unchecked.rethrow((Exception)e);
            }
            for (Map.Entry<String, Expression> entry : this.map.entrySet()) {
                r.put(String.valueOf(entry.getKey()), entry.getValue().get(model));
            }
            return r;
        }

        @Override
        public String toString() {
            if (this.map != null) {
                return "new " + this.map.getClass();
            }
            return "new LinkedHashMap";
        }
    }

    public static class Holder
    extends Expression {
        public static final Expression NULL = new Holder(){
            {
                this.hardcoded = true;
            }
        };
        protected Expression inner;
        protected boolean parsed = false;
        protected Variable variable;

        private Holder() {
        }

        public Holder(String exp) {
            this.exp = exp;
        }

        public Holder(String exp, boolean hardcoded) {
            if (hardcoded) {
                this.result = exp;
            }
            this.exp = exp;
            this.hardcoded = hardcoded;
        }

        public Holder(Class clazz) {
            this.hardcoded = true;
            this.result = clazz;
        }

        public Holder(Expression inner) {
            this.inner = inner;
        }

        public Holder(Object result) {
            this.hardcoded = true;
            this.result = result;
        }

        @Override
        public String toString() {
            if (this.hardcoded) {
                return String.valueOf(this.result);
            }
            if (this.exp != null) {
                return this.exp;
            }
            if (this.inner != null) {
                return this.inner.toString();
            }
            return super.toString();
        }

        @Override
        public void setVariable(Variable v) {
            if (this.hardcoded) {
                return;
            }
            if (this.exp.equals(v.getName())) {
                this.variable = v;
            }
        }

        @Override
        public Expression clone() {
            if (this.inner != null) {
                return new Holder(this.inner.clone());
            }
            if (this.exp != null) {
                if (this.hardcoded) {
                    return new Holder(this.result);
                }
                return new Holder(this.exp);
            }
            return null;
        }

        @Override
        public Object get(Map<String, Object> model) {
            if (this.hardcoded) {
                return this.result;
            }
            if (this.variable != null) {
                return this.variable.get();
            }
            if (this.exp != null) {
                if (!this.parsed) {
                    Object result = Holder.parse(this.exp);
                    this.parsed = true;
                    if (result != null) {
                        this.hardcoded = true;
                        this.result = result;
                        return result;
                    }
                }
                return model.get(this.exp);
            }
            if (this.inner != null) {
                return this.inner.get(model);
            }
            return null;
        }
    }
}

