/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.evaluation;

import com.wizzardo.tools.collections.CollectionTools;
import com.wizzardo.tools.evaluation.ClosureExpression;
import com.wizzardo.tools.evaluation.Expression;
import com.wizzardo.tools.evaluation.Variable;
import com.wizzardo.tools.misc.Unchecked;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class Function
extends Expression {
    private Expression thatObject;
    private Method method;
    private Constructor constructor;
    private Field field;
    private Getter getter;
    private Setter setter;
    private String methodName;
    private Expression[] args;
    private String fieldName;
    private boolean hardcodeChecked = false;
    private boolean metaChecked = false;
    private boolean safeNavigation = false;
    private CollectionTools.Closure3<Object, Object, Map, Expression[]> metaMethod;
    private static Map<Class, Map<String, CollectionTools.Closure3<Object, Object, Map, Expression[]>>> metaMethods = new HashMap<Class, Map<String, CollectionTools.Closure3<Object, Object, Map, Expression[]>>>();
    private ThreadLocal<Object[]> tempArray = new ThreadLocal();
    private static final Map<Class, Class> boxing = new HashMap<Class, Class>(){
        {
            this.put(Integer.TYPE, Integer.class);
            this.put(Double.TYPE, Double.class);
            this.put(Float.TYPE, Float.class);
            this.put(Long.TYPE, Long.class);
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Character.TYPE, Character.class);
            this.put(Short.TYPE, Short.class);
        }
    };
    private static final Class[] primitives = new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Class[] Boxed = new Class[]{Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class};

    public Function(Expression thatObject, Method method, Expression[] args) {
        this.thatObject = thatObject;
        this.method = method;
        this.args = args;
    }

    public Function(Expression thatObject, Method method, Expression[] args, boolean safeNavigation) {
        this.thatObject = thatObject;
        this.method = method;
        this.args = args;
        this.safeNavigation = safeNavigation;
    }

    public Function(Expression thatObject, String methodName, Expression[] args) {
        this.thatObject = thatObject;
        this.args = args;
        this.methodName = methodName;
    }

    public Function(Expression thatObject, String methodName, Expression[] args, boolean safeNavigation) {
        this.thatObject = thatObject;
        this.args = args;
        this.methodName = methodName;
        this.safeNavigation = safeNavigation;
    }

    public Function(Constructor constructor, Expression[] args) {
        this.args = args;
        this.constructor = constructor;
    }

    public Function(Expression object, Method method) {
        this.thatObject = object;
        this.method = method;
    }

    public Function(Expression thatObject, String fieldName) {
        this.thatObject = thatObject;
        this.fieldName = fieldName;
    }

    public Function(Expression thatObject, String fieldName, boolean safeNavigation) {
        this.thatObject = thatObject;
        this.fieldName = fieldName;
        this.safeNavigation = safeNavigation;
    }

    public Function(Expression thatObject, Field field) {
        this.thatObject = thatObject;
        this.field = field;
    }

    public Function(Expression thatObject, Field field, boolean safeNavigation) {
        this.thatObject = thatObject;
        this.field = field;
        this.safeNavigation = safeNavigation;
    }

    @Override
    public void setVariable(Variable v) {
        if (this.thatObject != null) {
            this.thatObject.setVariable(v);
        }
        if (this.args != null) {
            for (Expression e : this.args) {
                e.setVariable(v);
            }
        }
    }

    @Override
    public Function clone() {
        Expression[] args = null;
        if (this.args != null) {
            args = new Expression[this.args.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.args[i].clone();
            }
        }
        if (this.constructor != null) {
            return new Function(this.constructor, args);
        }
        if (this.field != null) {
            return new Function(this.thatObject, this.field, this.safeNavigation);
        }
        if (this.fieldName != null) {
            return new Function(this.thatObject, this.fieldName, this.safeNavigation);
        }
        if (this.method != null) {
            return new Function(this.thatObject.clone(), this.method, args, this.safeNavigation);
        }
        return new Function(this.thatObject.clone(), this.methodName, args, this.safeNavigation);
    }

    @Override
    public Object get(Map<String, Object> model) {
        if (this.hardcoded) {
            return this.result;
        }
        try {
            Object[] arr = null;
            Object instance = this.thatObject.get(model);
            if (this.safeNavigation && instance == null) {
                return null;
            }
            if (!this.metaChecked) {
                this.chechMeta(instance);
                this.metaChecked = true;
            }
            if (this.metaMethod != null) {
                return this.metaMethod.execute(instance, model, (Object)this.args);
            }
            if (this.args != null) {
                arr = this.tempArray.get();
                if (arr == null) {
                    arr = new Object[this.args.length];
                    this.tempArray.set(arr);
                }
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = this.args[i] instanceof ClosureExpression ? this.args[i] : this.args[i].get(model);
                }
            }
            if (this.fieldName != null || this.getter != null) {
                return this.getGetter(instance).get(instance);
            }
            if ("%constructor%".equals(this.methodName)) {
                this.constructor = this.findConstructor(this.getClass(instance), arr);
                return this.constructor.newInstance(arr);
            }
            if (this.method == null) {
                this.method = this.findMethod(this.getClass(instance), this.methodName, arr);
                if (this.method == null && instance.getClass() == Class.class) {
                    this.method = this.findMethod(instance.getClass(), this.methodName, arr);
                }
                if (this.method != null && Modifier.isPublic(this.method.getModifiers())) {
                    this.method.setAccessible(true);
                }
            }
            if (this.method == null) {
                throw new NoSuchMethodException("can't find method '" + this.methodName + "' for class " + this.getClass(instance) + " with args: " + Arrays.toString(arr));
            }
            Object result = this.method.invoke(instance, arr);
            if (!this.hardcodeChecked && (this.hardcoded = this.thatObject.hardcoded)) {
                this.hardcodeChecked = true;
                if (this.args != null) {
                    for (Expression arg : this.args) {
                        this.hardcoded = arg.hardcoded;
                        if (!this.hardcoded) break;
                    }
                }
            }
            if (this.hardcoded) {
                this.result = result;
            }
            return result;
        }
        catch (Exception e) {
            throw Unchecked.rethrow((Exception)e);
        }
    }

    public Getter getGetter(Object instance) {
        if (this.getter != null) {
            return this.getter;
        }
        if (this.fieldName == null) {
            return null;
        }
        if (instance instanceof Map) {
            this.getter = new MapGetter(this.fieldName);
            return this.getter;
        }
        Class<?> clazz = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        Field field = this.findField(clazz, this.fieldName);
        if (field != null && Modifier.isPublic(field.getModifiers())) {
            this.getter = new FieldGetter(field);
            return this.getter;
        }
        String methodName = "get" + this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1);
        Method method = this.findMethod(clazz, methodName, 0);
        if (method != null) {
            this.getter = new MethodGetter(method);
            return this.getter;
        }
        if (instance instanceof Class && (method = this.findMethod(clazz = instance.getClass(), methodName, 0)) != null) {
            this.getter = new MethodGetter(method);
            return this.getter;
        }
        throw Unchecked.rethrow((Exception)new NoSuchFieldException(this.fieldName));
    }

    public Setter getSetter(Object instance) {
        if (this.setter != null) {
            return this.setter;
        }
        if (this.fieldName == null) {
            return null;
        }
        if (instance instanceof Map) {
            this.setter = new MapSetter(this.fieldName);
            return this.setter;
        }
        Class<?> clazz = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        Field field = this.findField(clazz, this.fieldName);
        if (field != null && !Modifier.isPrivate(field.getModifiers())) {
            this.setter = new FieldSetter(field);
            return this.setter;
        }
        String methodName = "set" + this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1);
        Method method = this.findMethod(clazz, methodName, 1);
        if (method != null) {
            this.setter = new MethodSetter(method);
            return this.setter;
        }
        throw Unchecked.rethrow((Exception)new NoSuchFieldException(this.fieldName));
    }

    protected Method findMethod(Class clazz, String name, int paramsCount) {
        while (clazz != null) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(name) || paramsCount != m.getParameterTypes().length) continue;
                if (Modifier.isPublic(m.getModifiers())) {
                    m.setAccessible(true);
                }
                return m;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    protected Field findField(Class clazz, String name) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException ignored) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    private boolean chechMeta(Object instance) {
        if (this.args != null && instance != null) {
            Map<String, CollectionTools.Closure3<Object, Object, Map, Expression[]>> methods;
            CollectionTools.Closure3<Object, Object, Map, Expression[]> closure = null;
            for (Class<?> clazz = instance instanceof Class ? (Class<?>)instance : instance.getClass(); clazz != null && ((methods = metaMethods.get(clazz)) == null || (closure = methods.get(this.methodName)) == null); clazz = clazz.getSuperclass()) {
            }
            if (closure != null) {
                this.metaMethod = closure;
                return true;
            }
            Class[] classes = instance.getClass().getInterfaces();
            closure = this.findMeta(classes);
            if (closure != null) {
                this.metaMethod = closure;
                return true;
            }
        }
        return false;
    }

    private CollectionTools.Closure3<Object, Object, Map, Expression[]> findMeta(Class[] classes) {
        CollectionTools.Closure3<Object, Object, Map, Expression[]> closure = null;
        for (Class i : classes) {
            Map<String, CollectionTools.Closure3<Object, Object, Map, Expression[]>> methods;
            if (closure != null || (methods = metaMethods.get(i)) != null && (closure = methods.get(this.methodName)) != null) continue;
            closure = this.findMeta(i.getInterfaces());
        }
        return closure;
    }

    private Class getClass(Object ob) {
        Class<?> clazz = ob.getClass();
        if (clazz == Class.class) {
            return (Class)ob;
        }
        return clazz;
    }

    private Method findMethod(Class clazz, String method, Object[] args) {
        Class[] argsClasses = null;
        if (args != null) {
            argsClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                argsClasses[i] = args[i].getClass();
            }
        }
        try {
            return clazz.getMethod(method, argsClasses);
        }
        catch (NoSuchMethodException e) {
            Method m = this.findExactMatch(clazz, method, argsClasses);
            if (m == null) {
                m = this.findBoxedMatch(clazz, method, argsClasses);
            }
            if (m == null) {
                m = this.findNumberMatch(clazz, method, argsClasses);
            }
            return m;
        }
    }

    private Method findExactMatch(Class clazz, String method, Class[] argsClasses) {
        block0: for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(method) || (m.getParameterTypes().length != 0 || argsClasses != null) && m.getParameterTypes().length != argsClasses.length) continue;
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                Class arg = argsClasses[i];
                Class<?> param = m.getParameterTypes()[i];
                if (arg != param && !param.isAssignableFrom(arg)) continue block0;
            }
            return m;
        }
        return null;
    }

    private Method findBoxedMatch(Class clazz, String method, Class[] argsClasses) {
        block0: for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(method) || (m.getParameterTypes().length != 0 || argsClasses != null) && m.getParameterTypes().length != argsClasses.length) continue;
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                Class arg = argsClasses[i];
                Class<?> param = m.getParameterTypes()[i];
                if (!param.isPrimitive() || boxing.get(param) != arg) continue block0;
            }
            return m;
        }
        return null;
    }

    private Method findNumberMatch(Class clazz, String method, Class[] argsClasses) {
        block0: for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(method) || (m.getParameterTypes().length != 0 || argsClasses != null) && m.getParameterTypes().length != argsClasses.length) continue;
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                int p;
                int a;
                Class arg = argsClasses[i];
                Class<?> param = m.getParameterTypes()[i];
                if (!(param == Character.TYPE && arg == Character.class || param == Boolean.TYPE && arg == Boolean.class || (a = this.indexOfClass(arg, Boxed)) >= 0 && (p = this.indexOfClass(param, primitives)) >= 0 && p >= a)) continue block0;
            }
            return m;
        }
        return null;
    }

    private Constructor findConstructor(Class clazz, Object[] args) {
        Class[] argsClasses = null;
        if (args != null) {
            argsClasses = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                argsClasses[i] = args[i].getClass();
            }
        }
        try {
            return clazz.getConstructor(argsClasses);
        }
        catch (NoSuchMethodException e) {
            block3: for (Constructor<?> c : clazz.getConstructors()) {
                if ((c.getParameterTypes().length != 0 || argsClasses != null) && c.getParameterTypes().length != argsClasses.length) continue;
                for (int i = 0; i < c.getParameterTypes().length; ++i) {
                    if (!(c.getParameterTypes()[i].equals(argsClasses[i]) || boxing.containsKey(c.getParameterTypes()[i]) && boxing.get(c.getParameterTypes()[i]).equals(argsClasses[i]) || boxing.containsKey(c.getParameterTypes()[i]) && boxing.containsValue(argsClasses[i]))) continue block3;
                }
                return c;
            }
            return null;
        }
    }

    private int indexOfClass(Class clazz, Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (clazz != classes[i]) continue;
            return i;
        }
        return -1;
    }

    public Method getMethod() {
        return this.method;
    }

    public Expression getThatObject() {
        return this.thatObject;
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String toString() {
        return "function for: " + this.thatObject + " ." + (this.method == null ? this.methodName : this.method.getName()) + "(" + Arrays.toString(this.args) + ")";
    }

    public Field getField() {
        return this.field;
    }

    public static void setMethod(Class clazz, String methodName, CollectionTools.Closure3<Object, Object, Map, Expression[]> c) {
        Map<String, CollectionTools.Closure3<Object, Object, Map, Expression[]>> methods = metaMethods.get(clazz);
        if (methods == null) {
            methods = new HashMap<String, CollectionTools.Closure3<Object, Object, Map, Expression[]>>();
            metaMethods.put(clazz, methods);
        }
        methods.put(methodName, c);
    }

    static class MapSetter
    implements Setter {
        final Object fieldName;

        MapSetter(Object fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public void set(Object instance, Object value) {
            ((Map)instance).put(this.fieldName, value);
        }
    }

    static class MethodSetter
    implements Setter {
        final Method method;

        MethodSetter(Method method) {
            this.method = method;
        }

        @Override
        public void set(Object instance, Object value) {
            try {
                this.method.invoke(instance, value);
            }
            catch (IllegalAccessException e) {
                throw Unchecked.rethrow((Exception)e);
            }
            catch (InvocationTargetException e) {
                throw Unchecked.rethrow((Exception)e);
            }
        }
    }

    static class FieldSetter
    implements Setter {
        final Field field;

        FieldSetter(Field field) {
            this.field = field;
        }

        @Override
        public void set(Object instance, Object value) {
            try {
                this.field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw Unchecked.rethrow((Exception)e);
            }
        }
    }

    static interface Setter {
        public void set(Object var1, Object var2);
    }

    static class MapGetter
    implements Getter {
        final Object fieldName;

        MapGetter(Object fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public Object get(Object instance) {
            return ((Map)instance).get(this.fieldName);
        }
    }

    static class MethodGetter
    implements Getter {
        final Method method;

        MethodGetter(Method method) {
            this.method = method;
        }

        @Override
        public Object get(Object instance) {
            try {
                return this.method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw Unchecked.rethrow((Exception)e);
            }
            catch (InvocationTargetException e) {
                throw Unchecked.rethrow((Exception)e);
            }
        }
    }

    static class FieldGetter
    implements Getter {
        final Field field;

        FieldGetter(Field field) {
            this.field = field;
        }

        @Override
        public Object get(Object instance) {
            try {
                return this.field.get(instance);
            }
            catch (IllegalAccessException e) {
                throw Unchecked.rethrow((Exception)e);
            }
        }
    }

    static interface Getter {
        public Object get(Object var1);
    }
}

