/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.evaluation;

import com.wizzardo.tools.evaluation.AsBooleanExpression;
import com.wizzardo.tools.evaluation.Expression;
import com.wizzardo.tools.evaluation.Variable;
import java.util.Map;

public class IfExpression
extends Expression {
    private AsBooleanExpression condition;
    private Expression thenStatement;
    private Expression elseStatement;

    public IfExpression(AsBooleanExpression condition, Expression thenStatement) {
        this.condition = condition;
        this.thenStatement = thenStatement;
    }

    public IfExpression(AsBooleanExpression condition, Expression thenStatement, Expression elseStatement) {
        this.condition = condition;
        this.thenStatement = thenStatement;
        this.elseStatement = elseStatement;
    }

    @Override
    public void setVariable(Variable v) {
        this.condition.setVariable(v);
        if (this.elseStatement != null) {
            this.elseStatement.setVariable(v);
        }
    }

    @Override
    public Expression clone() {
        if (this.elseStatement != null) {
            return new IfExpression((AsBooleanExpression)this.condition.clone(), this.thenStatement.clone(), this.elseStatement.clone());
        }
        return new IfExpression((AsBooleanExpression)this.condition.clone(), this.thenStatement.clone());
    }

    @Override
    public Object get(Map<String, Object> model) {
        if (((Boolean)this.condition.get(model)).booleanValue()) {
            return this.thenStatement.get(model);
        }
        if (this.elseStatement != null) {
            return this.elseStatement.get(model);
        }
        return null;
    }
}

