/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.evaluation;

import com.wizzardo.tools.collections.Range;
import com.wizzardo.tools.evaluation.AsBooleanExpression;
import com.wizzardo.tools.evaluation.EvalTools;
import com.wizzardo.tools.evaluation.Expression;
import com.wizzardo.tools.evaluation.Function;
import com.wizzardo.tools.evaluation.Operator;
import com.wizzardo.tools.evaluation.Variable;
import com.wizzardo.tools.misc.Unchecked;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

class Operation
extends Expression {
    private Expression leftPart;
    private Expression rightPart;
    private Operator operator;
    private int start;
    private int end;
    private volatile boolean checkedForSimplify = false;
    private static EnumSet<Operator> leftPartNotIn = EnumSet.of(Operator.EQUAL, new Operator[]{Operator.PLUS2, Operator.MINUS2, Operator.PLUS_EQUAL, Operator.MINUS_EQUAL, Operator.DIVIDE_EQUAL, Operator.MULTIPLY_EQUAL});
    private static EnumSet<Operator> rightPartNotIn = EnumSet.of(Operator.TERNARY, new Operator[]{Operator.ELVIS, Operator.AND2, Operator.OR2, Operator.EQUAL, Operator.PLUS2, Operator.PLUS_EQUAL, Operator.MINUS_EQUAL, Operator.DIVIDE_EQUAL, Operator.MULTIPLY_EQUAL});

    public Operation(Expression leftPart, Expression rightPart, Operator operator) {
        this.leftPart = this.wrapBooleanOperationLeft(leftPart, operator);
        this.rightPart = this.wrapBooleanOperationRight(rightPart, operator);
        this.operator = operator;
    }

    public Operation(Expression leftPart, Operator operator, int start, int end) {
        this.leftPart = this.wrapBooleanOperationLeft(leftPart, operator);
        this.operator = operator;
        this.start = start;
        this.end = end;
    }

    private Expression wrapBooleanOperationLeft(Expression exp, Operator operator) {
        switch (operator) {
            case AND: 
            case AND2: 
            case OR: 
            case OR2: 
            case TERNARY: {
                if (exp == null) break;
                return new AsBooleanExpression(exp);
            }
        }
        return exp;
    }

    private Expression wrapBooleanOperationRight(Expression exp, Operator operator) {
        switch (operator) {
            case AND: 
            case AND2: 
            case OR: 
            case OR2: 
            case NOT: {
                if (exp == null) break;
                return new AsBooleanExpression(exp);
            }
        }
        return exp;
    }

    @Override
    public void setVariable(Variable v) {
        if (this.leftPart != null) {
            this.leftPart.setVariable(v);
        }
        if (this.rightPart != null) {
            this.rightPart.setVariable(v);
        }
    }

    @Override
    public Operation clone() {
        return new Operation(this.leftPart == null ? null : this.leftPart.clone(), this.rightPart == null ? null : this.rightPart.clone(), this.operator);
    }

    @Override
    public String toString() {
        return (this.leftPart == null ? "" : this.leftPart + " ") + this.getOperator().text + (this.rightPart == null ? "" : " " + this.rightPart);
    }

    public Expression getLeftPart() {
        return this.leftPart;
    }

    public void setLeftPart(Expression leftPart) {
        this.leftPart = this.wrapBooleanOperationLeft(leftPart, this.operator);
    }

    public Expression getRightPart() {
        return this.rightPart;
    }

    public void setRightPart(Expression rightPart) {
        this.rightPart = this.wrapBooleanOperationRight(rightPart, this.operator);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression leftPart() {
        return this.leftPart;
    }

    public void leftPart(Expression leftPart) {
        this.setLeftPart(leftPart);
    }

    public Expression rightPart() {
        return this.rightPart;
    }

    public void rightPart(Expression rightPart) {
        this.setRightPart(rightPart);
    }

    public Operator operator() {
        return this.operator;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int end() {
        return this.end;
    }

    public int start() {
        return this.start;
    }

    public void end(int end) {
        this.end = end;
    }

    public void start(int start) {
        this.start = start;
    }

    public boolean isFull() {
        switch (this.operator.requirement) {
            case ANY: {
                return this.leftPart != null || this.rightPart != null;
            }
            case RIGHR: {
                return this.rightPart != null;
            }
            case LEFT: {
                return this.leftPart != null;
            }
            case BOTH: {
                return this.leftPart != null && this.rightPart != null;
            }
        }
        return false;
    }

    @Override
    public Object get(Map<String, Object> model) {
        if (this.hardcoded) {
            return this.result;
        }
        Object ob1 = null;
        Object ob2 = null;
        if (this.leftPart != null && !leftPartNotIn.contains((Object)this.operator)) {
            ob1 = this.leftPart.get(model);
        }
        if (this.rightPart != null && !rightPartNotIn.contains((Object)this.operator)) {
            ob2 = this.rightPart.get(model);
        }
        Object result = null;
        switch (this.operator) {
            case PLUS: {
                result = Operation.plus(ob1, ob2, this.operator);
                break;
            }
            case MINUS: {
                result = Operation.minus(ob1, ob2);
                break;
            }
            case MULTIPLY: {
                result = Operation.multiply(ob1, ob2);
                break;
            }
            case DIVIDE: {
                result = Operation.divide(ob1, ob2);
                break;
            }
            case PLUS_EQUAL: 
            case MINUS_EQUAL: 
            case MULTIPLY_EQUAL: 
            case DIVIDE_EQUAL: 
            case EQUAL: 
            case PLUS2: 
            case MINUS2: {
                result = Operation.set(this.leftPart, this.rightPart, model, this.operator);
                break;
            }
            case NOT: {
                result = (Boolean)ob2 == false;
                break;
            }
            case GREATE: {
                result = Operation.gt(ob1, ob2);
                break;
            }
            case LOWER: {
                result = Operation.lt(ob1, ob2);
                break;
            }
            case GREATE_EQUAL: {
                result = Operation.gte(ob1, ob2);
                break;
            }
            case LOWER_EQUAL: {
                result = Operation.lte(ob1, ob2);
                break;
            }
            case EQUAL2: {
                result = Operation.e(ob1, ob2);
                break;
            }
            case NOT_EQUAL: {
                result = Operation.ne(ob1, ob2);
                break;
            }
            case TERNARY: {
                if (((Boolean)ob1).booleanValue()) {
                    result = ((Operation)this.rightPart).leftPart.get(model);
                    break;
                }
                result = ((Operation)this.rightPart).rightPart.get(model);
                break;
            }
            case OR2: {
                if (((Boolean)ob1).booleanValue()) {
                    result = true;
                    break;
                }
                result = this.rightPart().get(model);
                break;
            }
            case OR: {
                if (((Boolean)ob1).booleanValue()) {
                    result = true;
                    break;
                }
                result = ob2;
                break;
            }
            case AND2: {
                if (!((Boolean)ob1).booleanValue()) {
                    result = false;
                    break;
                }
                result = this.rightPart().get(model);
                break;
            }
            case AND: {
                if (!((Boolean)ob1).booleanValue()) {
                    result = false;
                    break;
                }
                result = ob2;
                break;
            }
            case APPEND: {
                result = Operation.append(ob1, ob2);
                break;
            }
            case GET: {
                result = Operation.get(ob1, ob2);
                break;
            }
            case RANGE: {
                result = Operation.createRange(ob1, ob2);
                break;
            }
            case ELVIS: {
                if (AsBooleanExpression.toBoolean(ob1).booleanValue()) {
                    result = ob1;
                    break;
                }
                result = this.rightPart.get(model);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented:" + (Object)((Object)this.operator));
            }
        }
        boolean bl = this.hardcoded = !(this.leftPart != null && !this.leftPart.hardcoded || this.rightPart != null && !this.rightPart.hardcoded);
        if (this.hardcoded) {
            this.result = result;
            return result;
        }
        this.simplify();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simplify() {
        if (!this.checkedForSimplify) {
            Operation operation = this;
            synchronized (operation) {
                if (!this.checkedForSimplify) {
                    if (this.leftPart != null && this.leftPart.hardcoded && this.leftPart.result instanceof Number) {
                        if (this.checkForSimplify(this.operator, this.rightPart)) {
                            this.switchHardcodedParts(this, (Operation)this.rightPart);
                        }
                    } else if (this.rightPart != null && this.rightPart.hardcoded && this.rightPart.result instanceof Number && this.checkForSimplify(this.operator, this.leftPart)) {
                        this.switchHardcodedParts(this, (Operation)this.leftPart);
                    }
                    this.checkedForSimplify = true;
                }
            }
        }
    }

    private void switchHardcodedParts(Operation from, Operation to) {
        if (from.rightPart != null && from.rightPart.hardcoded) {
            if (!to.leftPart.hardcoded) {
                Expression temp = to.leftPart;
                to.leftPart = from.rightPart;
                from.rightPart = temp;
                if (from.operator != to.operator && (from.operator == Operator.MINUS || from.operator == Operator.DIVIDE)) {
                    this.switchParts(to);
                    this.switchOperators(from, to);
                }
            } else {
                Expression temp = to.rightPart;
                to.rightPart = from.rightPart;
                from.rightPart = temp;
                this.switchOperators(from, to);
            }
        }
    }

    private void switchParts(Operation op) {
        Expression temp = op.leftPart;
        op.leftPart = op.rightPart;
        op.rightPart = temp;
    }

    private void switchOperators(Operation from, Operation to) {
        if (from.operator != to.operator) {
            Operator temp = from.operator;
            from.operator = to.operator;
            to.operator = temp;
        }
    }

    private boolean checkForSimplify(Operator operator, Expression anotherPart) {
        if (operator != Operator.PLUS && operator != Operator.MINUS && operator != Operator.MULTIPLY && operator != Operator.DIVIDE) {
            return false;
        }
        if (anotherPart == null || !(anotherPart instanceof Operation)) {
            return false;
        }
        Operation op = (Operation)anotherPart;
        if (op.operator != Operator.PLUS && op.operator != Operator.MINUS && op.operator != Operator.MULTIPLY && op.operator != Operator.DIVIDE) {
            return false;
        }
        if (!(operator != Operator.PLUS && operator != Operator.MINUS || op.operator != Operator.MULTIPLY && op.operator != Operator.DIVIDE)) {
            return false;
        }
        if (!(operator != Operator.MULTIPLY && operator != Operator.DIVIDE || op.operator != Operator.PLUS && op.operator != Operator.MINUS)) {
            return false;
        }
        return op.leftPart != null && op.leftPart.hardcoded && op.leftPart.result instanceof Number || op.rightPart != null && op.rightPart.hardcoded && op.rightPart.result instanceof Number;
    }

    private static Range createRange(Object ob1, Object ob2) {
        if (ob1 == null || ob2 == null) {
            throw new NullPointerException("can not append to null");
        }
        if (ob1 instanceof Number && ob2 instanceof Number) {
            return new Range(((Number)ob1).intValue(), ((Number)ob2).intValue());
        }
        return null;
    }

    private static Object get(Object ob1, Object ob2) {
        if (ob1 == null) {
            throw new NullPointerException("can not append to null");
        }
        if (ob1 instanceof Map) {
            return ((Map)ob1).get(ob2);
        }
        if (ob1 instanceof List && ob2 instanceof Number) {
            List l = (List)ob1;
            int i = ((Number)ob2).intValue();
            if (i >= l.size()) {
                return null;
            }
            return l.get(i);
        }
        if (ob1.getClass().getName().startsWith("[") && ob2 instanceof Number) {
            return Array.get(ob1, ((Number)ob2).intValue());
        }
        return null;
    }

    private static Object append(Object ob1, Object ob2) {
        if (ob1 == null) {
            throw new NullPointerException("can not append to null");
        }
        if (ob1 instanceof Collection) {
            ((Collection)ob1).add(ob2);
            return ob1;
        }
        if (ob1 instanceof StringBuilder) {
            ((StringBuilder)ob1).append(ob2);
            return ob1;
        }
        return null;
    }

    private static Object set(Expression leftPart, Expression rightPart, Map<String, Object> model, Operator operator) {
        Function function;
        Object ob1 = null;
        Object ob2 = null;
        if (leftPart != null) {
            if (rightPart != null) {
                ob2 = rightPart.get(model);
            }
            function = null;
            if (leftPart instanceof Function) {
                function = (Function)leftPart;
            }
            if (function != null) {
                ob1 = function.getThatObject().get(model);
            }
            if (function != null) {
                Function.Setter setter = function.getSetter(ob1);
                Function.Getter getter = function.getGetter(ob1);
                if (operator != null && getter != null && setter != null) {
                    return Operation.setAndReturn(ob1, setter, getter.get(ob1), ob2, operator);
                }
                return ob2;
            }
            Operation operation = null;
            if (leftPart instanceof Operation) {
                operation = (Operation)leftPart;
            }
            if (operation != null && operation.operator() == Operator.GET) {
                ob1 = operation.leftPart().get(model);
                if (ob1 instanceof Map) {
                    if (operator != null) {
                        Object key = operation.rightPart().get(model);
                        Map m = (Map)ob1;
                        return Operation.setAndReturn(ob1, new Function.MapSetter(key), m.get(key), ob2, operator);
                    }
                    ((Map)ob1).put(operation.rightPart().get(model), ob2);
                    return ob2;
                }
                int index = ((Number)operation.rightPart().get(model)).intValue();
                if (ob1 instanceof List) {
                    List l = (List)ob1;
                    while (index >= l.size()) {
                        l.add(null);
                    }
                    l.set(index, ob2);
                    return ob2;
                }
                if (ob1.getClass().getName().startsWith("[")) {
                    Array.set(ob1, index, ob2);
                    return ob2;
                }
            }
        }
        if (operator != null) {
            function = null;
            if (rightPart != null && rightPart instanceof Function) {
                function = (Function)rightPart;
            }
            if (function != null) {
                Object thatObject = function.getThatObject().get(model);
                Function.Getter getter = function.getGetter(thatObject);
                Function.Setter setter = function.getSetter(thatObject);
                if (getter != null && setter != null) {
                    return Operation.setAndReturn(thatObject, setter, null, getter.get(thatObject), operator);
                }
            } else if (leftPart != null) {
                ob1 = leftPart.get(model);
            } else if (rightPart != null) {
                ob2 = rightPart.get(model);
            }
            Variable v = Operation.getVariable(leftPart, rightPart);
            if (v != null) {
                return Operation.setAndReturn(null, v, ob1, ob2, operator);
            }
            return Operation.setAndReturn(model, new Function.MapSetter(leftPart != null ? leftPart.raw() : rightPart.raw()), ob1, ob2, operator);
        }
        return null;
    }

    private static Variable getVariable(Expression leftPart, Expression rightPart) {
        Object v = null;
        if (leftPart != null) {
            if (leftPart instanceof Expression.Holder) {
                return ((Expression.Holder)leftPart).variable;
            }
        } else if (rightPart != null && rightPart instanceof Expression.Holder) {
            return ((Expression.Holder)rightPart).variable;
        }
        return null;
    }

    private static Object setAndReturn(Object thatObject, Function.Setter setter, Object left, Object right, Operator operator) {
        switch (operator) {
            case PLUS2: {
                if (left != null) {
                    Object r = Operation.increment(left);
                    setter.set(thatObject, r);
                    return left;
                }
                if (right != null) {
                    Object ob = Operation.increment(right);
                    setter.set(thatObject, ob);
                    return ob;
                }
            }
            case MINUS2: {
                if (right != null) {
                    Object ob = Operation.decrement(right);
                    setter.set(thatObject, ob);
                    return ob;
                }
                if (left != null) {
                    Object r = Operation.decrement(left);
                    setter.set(thatObject, r);
                    return left;
                }
            }
            case PLUS_EQUAL: {
                Object r = Operation.plus(left, right, operator);
                setter.set(thatObject, r);
                return r;
            }
            case MINUS_EQUAL: {
                Object r = Operation.minus(left, right);
                setter.set(thatObject, r);
                return r;
            }
            case MULTIPLY_EQUAL: {
                Object r = Operation.multiply(left, right);
                setter.set(thatObject, r);
                return r;
            }
            case DIVIDE_EQUAL: {
                Object r = Operation.divide(left, right);
                setter.set(thatObject, r);
                return r;
            }
            case EQUAL: {
                setter.set(thatObject, right);
                return right;
            }
        }
        throw new UnsupportedOperationException("Not yet implemented:" + (Object)((Object)operator));
    }

    private static Object plus(Object ob1, Object ob2, Operator o) {
        if (ob1 instanceof Number && ob2 instanceof Number) {
            if (ob1 instanceof Double || ob2 instanceof Double) {
                return ((Number)ob1).doubleValue() + ((Number)ob2).doubleValue();
            }
            if (ob1 instanceof Float || ob2 instanceof Float) {
                return Float.valueOf(((Number)ob1).floatValue() + ((Number)ob2).floatValue());
            }
            if (ob1 instanceof Long || ob2 instanceof Long) {
                return ((Number)ob1).longValue() + ((Number)ob2).longValue();
            }
            if (ob1 instanceof Integer || ob2 instanceof Integer) {
                return ((Number)ob1).intValue() + ((Number)ob2).intValue();
            }
            if (ob1 instanceof Short || ob2 instanceof Short) {
                return ((Number)ob1).shortValue() + ((Number)ob2).shortValue();
            }
            if (ob1 instanceof Byte || ob2 instanceof Byte) {
                return ((Number)ob1).byteValue() + ((Number)ob2).byteValue();
            }
            return ((Number)ob1).doubleValue() + ((Number)ob2).doubleValue();
        }
        if (ob1 instanceof Collection) {
            if (ob2 instanceof Collection) {
                if (o == Operator.PLUS) {
                    Collection c = Operation.createNewCollection((Collection)ob1);
                    c.addAll((Collection)ob2);
                    return c;
                }
                ((Collection)ob1).addAll((Collection)ob2);
                return ob1;
            }
            if (o == Operator.PLUS) {
                Collection c = Operation.createNewCollection((Collection)ob1);
                c.add(ob2);
                return c;
            }
            ((Collection)ob1).add(ob2);
            return ob1;
        }
        return String.valueOf(ob1) + String.valueOf(ob2);
    }

    private static Collection createNewCollection(Collection c) {
        try {
            Collection l = (Collection)c.getClass().newInstance();
            l.addAll(c);
            return l;
        }
        catch (InstantiationException e) {
            throw Unchecked.rethrow((Exception)e);
        }
        catch (IllegalAccessException e) {
            throw Unchecked.rethrow((Exception)e);
        }
    }

    private static Object minus(Object ob1, Object ob2) {
        if (ob1 instanceof Double || ob2 instanceof Double) {
            return (ob1 != null ? ((Number)ob1).doubleValue() : 0.0) - ((Number)ob2).doubleValue();
        }
        if (ob1 instanceof Float || ob2 instanceof Float) {
            return Float.valueOf((ob1 != null ? ((Number)ob1).floatValue() : 0.0f) - ((Number)ob2).floatValue());
        }
        if (ob1 instanceof Long || ob2 instanceof Long) {
            return (ob1 != null ? ((Number)ob1).longValue() : 0L) - ((Number)ob2).longValue();
        }
        if (ob1 instanceof Integer || ob2 instanceof Integer) {
            return (ob1 != null ? ((Number)ob1).intValue() : 0) - ((Number)ob2).intValue();
        }
        if (ob1 instanceof Short || ob2 instanceof Short) {
            return (ob1 != null ? ((Number)ob1).shortValue() : (short)0) - ((Number)ob2).shortValue();
        }
        if (ob1 instanceof Byte || ob2 instanceof Byte) {
            return (ob1 != null ? ((Number)ob1).byteValue() : (byte)0) - ((Number)ob2).byteValue();
        }
        return (ob1 != null ? ((Number)ob1).doubleValue() : 0.0) - ((Number)ob2).doubleValue();
    }

    private static Object gt(Object ob1, Object ob2) {
        if (ob1 instanceof Double || ob2 instanceof Double) {
            return ((Number)ob1).doubleValue() > ((Number)ob2).doubleValue();
        }
        if (ob1 instanceof Float || ob2 instanceof Float) {
            return ((Number)ob1).floatValue() > ((Number)ob2).floatValue();
        }
        if (ob1 instanceof Long || ob2 instanceof Long) {
            return ((Number)ob1).longValue() > ((Number)ob2).longValue();
        }
        if (ob1 instanceof Integer || ob2 instanceof Integer) {
            return ((Number)ob1).intValue() > ((Number)ob2).intValue();
        }
        if (ob1 instanceof Short || ob2 instanceof Short) {
            return ((Number)ob1).shortValue() > ((Number)ob2).shortValue();
        }
        if (ob1 instanceof Byte || ob2 instanceof Byte) {
            return ((Number)ob1).byteValue() > ((Number)ob2).byteValue();
        }
        return ((Number)ob1).doubleValue() > ((Number)ob2).doubleValue();
    }

    private static Object lt(Object ob1, Object ob2) {
        if (ob1 instanceof Double || ob2 instanceof Double) {
            return ((Number)ob1).doubleValue() < ((Number)ob2).doubleValue();
        }
        if (ob1 instanceof Float || ob2 instanceof Float) {
            return ((Number)ob1).floatValue() < ((Number)ob2).floatValue();
        }
        if (ob1 instanceof Long || ob2 instanceof Long) {
            return ((Number)ob1).longValue() < ((Number)ob2).longValue();
        }
        if (ob1 instanceof Integer || ob2 instanceof Integer) {
            return ((Number)ob1).intValue() < ((Number)ob2).intValue();
        }
        if (ob1 instanceof Short || ob2 instanceof Short) {
            return ((Number)ob1).shortValue() < ((Number)ob2).shortValue();
        }
        if (ob1 instanceof Byte || ob2 instanceof Byte) {
            return ((Number)ob1).byteValue() < ((Number)ob2).byteValue();
        }
        return ((Number)ob1).doubleValue() < ((Number)ob2).doubleValue();
    }

    private static Object gte(Object ob1, Object ob2) {
        if (ob1 instanceof Double || ob2 instanceof Double) {
            return ((Number)ob1).doubleValue() >= ((Number)ob2).doubleValue();
        }
        if (ob1 instanceof Float || ob2 instanceof Float) {
            return ((Number)ob1).floatValue() >= ((Number)ob2).floatValue();
        }
        if (ob1 instanceof Long || ob2 instanceof Long) {
            return ((Number)ob1).longValue() >= ((Number)ob2).longValue();
        }
        if (ob1 instanceof Integer || ob2 instanceof Integer) {
            return ((Number)ob1).intValue() >= ((Number)ob2).intValue();
        }
        if (ob1 instanceof Short || ob2 instanceof Short) {
            return ((Number)ob1).shortValue() >= ((Number)ob2).shortValue();
        }
        if (ob1 instanceof Byte || ob2 instanceof Byte) {
            return ((Number)ob1).byteValue() >= ((Number)ob2).byteValue();
        }
        return ((Number)ob1).doubleValue() >= ((Number)ob2).doubleValue();
    }

    private static Object lte(Object ob1, Object ob2) {
        if (ob1 instanceof Double || ob2 instanceof Double) {
            return ((Number)ob1).doubleValue() <= ((Number)ob2).doubleValue();
        }
        if (ob1 instanceof Float || ob2 instanceof Float) {
            return ((Number)ob1).floatValue() <= ((Number)ob2).floatValue();
        }
        if (ob1 instanceof Long || ob2 instanceof Long) {
            return ((Number)ob1).longValue() <= ((Number)ob2).longValue();
        }
        if (ob1 instanceof Integer || ob2 instanceof Integer) {
            return ((Number)ob1).intValue() <= ((Number)ob2).intValue();
        }
        if (ob1 instanceof Short || ob2 instanceof Short) {
            return ((Number)ob1).shortValue() <= ((Number)ob2).shortValue();
        }
        if (ob1 instanceof Byte || ob2 instanceof Byte) {
            return ((Number)ob1).byteValue() <= ((Number)ob2).byteValue();
        }
        return ((Number)ob1).doubleValue() <= ((Number)ob2).doubleValue();
    }

    private static boolean e(Object ob1, Object ob2) {
        if (ob1 == null || ob2 == null) {
            return false;
        }
        if (ob1 == ob2) {
            return true;
        }
        return ob1.equals(ob2);
    }

    private static Object ne(Object ob1, Object ob2) {
        return !Operation.e(ob1, ob2);
    }

    static Object multiply(Object ob1, Object ob2) {
        if (ob1 instanceof Double || ob2 instanceof Double) {
            return ((Number)ob1).doubleValue() * ((Number)ob2).doubleValue();
        }
        if (ob1 instanceof Float || ob2 instanceof Float) {
            return Float.valueOf(((Number)ob1).floatValue() * ((Number)ob2).floatValue());
        }
        if (ob1 instanceof Long || ob2 instanceof Long) {
            return ((Number)ob1).longValue() * ((Number)ob2).longValue();
        }
        if (ob1 instanceof Integer || ob2 instanceof Integer) {
            return ((Number)ob1).intValue() * ((Number)ob2).intValue();
        }
        if (ob1 instanceof Short || ob2 instanceof Short) {
            return ((Number)ob1).shortValue() * ((Number)ob2).shortValue();
        }
        if (ob1 instanceof Byte || ob2 instanceof Byte) {
            return ((Number)ob1).byteValue() * ((Number)ob2).byteValue();
        }
        return ((Number)ob1).doubleValue() * ((Number)ob2).doubleValue();
    }

    private static Object divide(Object ob1, Object ob2) {
        if (ob1 instanceof Double || ob2 instanceof Double) {
            return ((Number)ob1).doubleValue() / ((Number)ob2).doubleValue();
        }
        if (ob1 instanceof Float || ob2 instanceof Float) {
            return Float.valueOf(((Number)ob1).floatValue() / ((Number)ob2).floatValue());
        }
        if (EvalTools.defaultEvaluatingStrategy == EvalTools.EvaluatingStrategy.DOUBLE) {
            return ((Number)ob1).doubleValue() / ((Number)ob2).doubleValue();
        }
        if (EvalTools.defaultEvaluatingStrategy == EvalTools.EvaluatingStrategy.FLOAT) {
            return Float.valueOf(((Number)ob1).floatValue() / ((Number)ob2).floatValue());
        }
        if (ob1 instanceof Long || ob2 instanceof Long) {
            return ((Number)ob1).longValue() / ((Number)ob2).longValue();
        }
        if (ob1 instanceof Integer || ob2 instanceof Integer) {
            return ((Number)ob1).intValue() / ((Number)ob2).intValue();
        }
        if (ob1 instanceof Short || ob2 instanceof Short) {
            return ((Number)ob1).shortValue() / ((Number)ob2).shortValue();
        }
        if (ob1 instanceof Byte || ob2 instanceof Byte) {
            return ((Number)ob1).byteValue() / ((Number)ob2).byteValue();
        }
        return ((Number)ob1).doubleValue() / ((Number)ob2).doubleValue();
    }

    private static Object increment(Object ob1) {
        if (ob1 instanceof Double) {
            return ((Number)ob1).doubleValue() + 1.0;
        }
        if (ob1 instanceof Float) {
            return Float.valueOf(((Number)ob1).floatValue() + 1.0f);
        }
        if (ob1 instanceof Long) {
            return ((Number)ob1).longValue() + 1L;
        }
        if (ob1 instanceof Short) {
            return ((Number)ob1).shortValue() + 1;
        }
        if (ob1 instanceof Integer) {
            return ((Number)ob1).intValue() + 1;
        }
        if (ob1 instanceof Byte) {
            return ((Number)ob1).byteValue() + 1;
        }
        return ((Number)ob1).doubleValue() + 1.0;
    }

    private static Object decrement(Object ob1) {
        if (ob1 instanceof Double) {
            return ((Number)ob1).doubleValue() - 1.0;
        }
        if (ob1 instanceof Float) {
            return Float.valueOf(((Number)ob1).floatValue() - 1.0f);
        }
        if (ob1 instanceof Long) {
            return ((Number)ob1).longValue() - 1L;
        }
        if (ob1 instanceof Integer) {
            return ((Number)ob1).intValue() - 1;
        }
        if (ob1 instanceof Short) {
            return ((Number)ob1).shortValue() - 1;
        }
        if (ob1 instanceof Byte) {
            return ((Number)ob1).byteValue() - 1;
        }
        return ((Number)ob1).doubleValue() - 1.0;
    }
}

