/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.evaluation;

import java.util.HashMap;
import java.util.Map;

enum Operator {
    PLUS("+", Requirement.BOTH, 1, false),
    PLUS2("++", Requirement.ANY, 3, false),
    MINUS("-", Requirement.BOTH, 1, false),
    MINUS2("--", Requirement.ANY, 3, false),
    MULTIPLY("*", Requirement.BOTH, 2, false),
    DIVIDE("/", Requirement.BOTH, 2, false),
    EQUAL("=", Requirement.BOTH, -2, false),
    APPEND("<<", Requirement.BOTH, -2, false),
    EQUAL2("==", Requirement.BOTH, 0, true),
    RANGE("..", Requirement.BOTH, 0, true),
    AND("&", Requirement.BOTH, -1, true),
    AND2("&&", Requirement.BOTH, -1, true),
    OR("|", Requirement.BOTH, -1, true),
    OR2("||", Requirement.BOTH, -1, true),
    NOT("!", Requirement.RIGHR, 1, true),
    NOT_EQUAL("!=", Requirement.BOTH, 1, true),
    PLUS_EQUAL("+=", Requirement.BOTH, -2, false),
    MINUS_EQUAL("-=", Requirement.BOTH, -2, false),
    MULTIPLY_EQUAL("*=", Requirement.BOTH, -2, false),
    DIVIDE_EQUAL("/=", Requirement.BOTH, -2, false),
    LOWER_EQUAL("<=", Requirement.BOTH, 1, true),
    GREATE_EQUAL(">=", Requirement.BOTH, 1, true),
    LOWER("<", Requirement.BOTH, 1, true),
    GREATE(">", Requirement.BOTH, 1, true),
    TERNARY("?", Requirement.BOTH, 4, true),
    ELVIS("?:", Requirement.BOTH, 4, true),
    COLON(":", Requirement.BOTH, 4, true),
    GET("%get%", Requirement.BOTH, 0, false);

    private static final Map<String, Operator> operators;
    public final String text;
    public final Requirement requirement;
    public final int priority;
    public final boolean logical;

    private Operator(String text, Requirement requirement, int priority, boolean logical) {
        this.text = text;
        this.requirement = requirement;
        this.priority = priority;
        this.logical = logical;
    }

    public static Operator get(String text) {
        return operators.get(text);
    }

    public String toString() {
        return this.text;
    }

    static {
        operators = new HashMap<String, Operator>();
        for (Operator op : Operator.values()) {
            operators.put(op.text, op);
        }
    }

    public static enum Requirement {
        LEFT,
        RIGHR,
        BOTH,
        ANY;

    }
}

