/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.evaluation;

import com.wizzardo.tools.evaluation.Expression;
import com.wizzardo.tools.evaluation.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TemplateBuilder
extends Expression {
    private List<Expression> parts = new ArrayList<Expression>();

    @Override
    public void setVariable(Variable v) {
        for (Expression e : this.parts) {
            e.setVariable(v);
        }
    }

    @Override
    public Expression clone() {
        TemplateBuilder tb = new TemplateBuilder();
        for (Expression e : this.parts) {
            tb.parts.add(e.clone());
        }
        return tb;
    }

    @Override
    public Object get(Map<String, Object> model) {
        if (this.hardcoded) {
            return this.result;
        }
        if (this.parts.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean hardcoded = true;
        for (Expression e : this.parts) {
            sb.append(e.get(model));
            hardcoded &= e.hardcoded;
        }
        String result = sb.toString();
        if (hardcoded) {
            this.hardcoded = hardcoded;
            this.result = result;
        }
        return result;
    }

    public TemplateBuilder append(Expression e) {
        this.parts.add(e);
        return this;
    }

    public TemplateBuilder append(String s) {
        this.parts.add(new Expression.Holder(s, true));
        return this;
    }
}

