/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.evaluation;

import com.wizzardo.tools.evaluation.EvalTools;
import com.wizzardo.tools.evaluation.Expression;
import com.wizzardo.tools.evaluation.Variable;
import com.wizzardo.tools.misc.Unchecked;
import java.util.HashMap;
import java.util.Map;

public class UserFunction
extends Expression {
    private Expression eh;
    private String[] argsNames;
    private String name;
    private Expression[] args;
    private Map<String, UserFunction> functions;
    private boolean notCreateOwnModel = false;

    public UserFunction(String name, String exp, String ... argsNames) {
        this.exp = exp;
        this.name = name;
        this.argsNames = argsNames;
    }

    public UserFunction(String name, Expression eh, String ... argsNames) {
        this.eh = eh;
        this.name = name;
        this.argsNames = argsNames;
    }

    @Override
    public void setVariable(Variable v) {
        if (this.eh != null) {
            this.eh.setVariable(v);
        }
        if (this.args != null) {
            for (Expression e : this.args) {
                e.setVariable(v);
            }
        }
    }

    public void prepare(Map<String, Object> model) {
        if (this.eh == null) {
            this.eh = EvalTools.prepare(this.exp, model, this.functions);
        }
    }

    @Override
    public UserFunction clone() {
        String[] args = null;
        if (this.argsNames != null) {
            args = new String[this.argsNames.length];
            System.arraycopy(this.argsNames, 0, args, 0, args.length);
        }
        if (this.eh == null) {
            return new UserFunction(this.name, this.exp, args);
        }
        return new UserFunction(this.name, this.eh.clone(), args);
    }

    public void setArgs(Expression[] args) {
        this.args = args;
    }

    public void setUserFunctions(Map<String, UserFunction> functions) {
        this.functions = functions;
    }

    public boolean isNotCreateOwnModel() {
        return this.notCreateOwnModel;
    }

    public void setNotCreateOwnModel(boolean b) {
        this.notCreateOwnModel = b;
    }

    public String getArgumentName(int i) {
        if (this.argsNames == null) {
            return null;
        }
        return this.argsNames[i];
    }

    @Override
    public Object get(Map<String, Object> model) {
        Map<String, Object> m = this.notCreateOwnModel ? model : (model != null ? new HashMap<String, Object>(model) : new HashMap<String, Object>());
        try {
            if (this.argsNames != null && this.args != null) {
                for (int i = 0; i < this.argsNames.length; ++i) {
                    m.put(this.argsNames[i], this.args[i].get(model));
                }
            }
            if (this.eh == null) {
                this.eh = EvalTools.prepare(this.exp, m, this.functions);
            }
            Object r = this.eh.get(m);
            if (model != null) {
                for (Map.Entry<String, Object> entry : model.entrySet()) {
                    if (m.get(entry.getKey()) == entry.getValue()) continue;
                    entry.setValue(m.get(entry.getKey()));
                }
            }
            return r;
        }
        catch (Exception e) {
            throw Unchecked.rethrow((Exception)e);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name + " = " + this.exp;
    }
}

