/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.misc;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RobotTools
extends Robot {
    private int rand;
    private int add;
    private int constant;
    private boolean debug = false;
    private Toolkit t = Toolkit.getDefaultToolkit();

    public void setDebugModeOn() {
        this.debug = true;
    }

    public void setDebugModeOff() {
        this.debug = false;
    }

    public void ctrlPlus(int key) {
        this.setAutoDelay(30);
        this.keyPress(17);
        this.keyPress(key);
        if (this.debug) {
            System.out.println("ctrl + " + (char)key);
            System.out.println(new Date());
            System.out.println("");
        }
        this.keyRelease(key);
        this.keyRelease(17);
        this.updateDelay();
    }

    public void setClipboard(String s) {
        this.t.getSystemClipboard().setContents(new StringSelection(s), null);
    }

    public String getClipboard() {
        String s = null;
        try {
            s = (String)this.t.getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException ex) {
            Logger.getLogger(Robot.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Robot.class.getName()).log(Level.SEVERE, null, ex);
        }
        return s;
    }

    public void altPlus(int key) {
        this.setAutoDelay(30);
        this.keyPress(18);
        this.keyPress(key);
        if (this.debug) {
            System.out.println("alt + " + (char)key);
            System.out.println(new Date());
            System.out.println("");
        }
        this.keyRelease(key);
        this.keyRelease(18);
        this.updateDelay();
    }

    public void ctrlPlusC() {
        this.ctrlPlus(67);
    }

    public void ctrlPlusV() {
        this.ctrlPlus(86);
    }

    public void mouseShift(int xFrom, int yFrom, int xTo, int yTo) {
        PointerInfo pi = MouseInfo.getPointerInfo();
        this.mouseMove(xFrom, yFrom);
        this.mousePress(16);
        this.mouseMove(xTo, yTo);
        this.setAutoDelay(30);
        this.mouseRelease(16);
        if (this.debug) {
            System.out.println("mouseShift");
            System.out.println(new Date());
            System.out.println("");
        }
        this.mouseMove(pi.getLocation().x, pi.getLocation().y);
        this.updateDelay();
    }

    public void mouseShift(Point from, Point to) {
        this.mouseShift(from.x, from.y, to.x, to.y);
    }

    public void mouseClickLeft(int x, int y) {
        PointerInfo pi = MouseInfo.getPointerInfo();
        this.mouseMove(x, y);
        this.mouseClick(16);
        if (this.debug) {
            System.out.println("mouseClickLeft");
            System.out.println(new Date());
            System.out.println("");
        }
        this.mouseMove(pi.getLocation().x, pi.getLocation().y);
    }

    public void mouseClickLeft(Point p) {
        this.mouseClickLeft(p.x, p.y);
    }

    public void mouseClickRight(int x, int y) {
        PointerInfo pi = MouseInfo.getPointerInfo();
        this.mouseMove(x, y);
        this.mouseClick(4);
        if (this.debug) {
            System.out.println("mouseClickRight");
            System.out.println(new Date());
            System.out.println("");
        }
        this.mouseMove(pi.getLocation().x, pi.getLocation().y);
    }

    public void mouseClickRight(Point p) {
        this.mouseClickRight(p.x, p.y);
    }

    private void mouseClick(int button) {
        this.setAutoDelay(10);
        this.mousePress(button);
        this.mouseRelease(button);
        this.updateDelay();
    }

    public void setDelay(int rand, int add) {
        this.rand = rand;
        this.add = add;
        this.constant = rand == 0 & add == 0 ? 0 : 100;
        this.setAutoDelay((int)((long)(this.constant + add) + Math.round(Math.random() * (double)rand)));
    }

    private void updateDelay() {
        this.setAutoDelay((int)((long)(this.constant + this.add) + Math.round(Math.random() * (double)this.rand)));
    }

    public synchronized Color getPixelColor(Point p) {
        return this.getPixelColor(p.x, p.y);
    }
}

