/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.misc;

public class Stopwatch {
    private long start;
    private long stop = -1L;
    private String message;
    private boolean nano;

    public Stopwatch(String message) {
        this(message, false);
    }

    public Stopwatch(String message, boolean nano) {
        this.message = message;
        this.nano = nano;
        this.restart();
    }

    public void stop() {
        this.stop = this.nano ? System.nanoTime() : System.currentTimeMillis();
    }

    public void restart() {
        this.stop = -1L;
        this.start = this.nano ? System.nanoTime() : System.currentTimeMillis();
    }

    public void restart(String message) {
        this.message = message;
        this.restart();
    }

    public String toString() {
        if (this.stop == -1L) {
            this.stop();
        }
        return this.message + ": " + (this.stop - this.start) + (this.nano ? "ns" : "ms");
    }

    public long getValue() {
        return this.stop - this.start;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public long getDuration() {
        if (this.stop == -1L) {
            this.stop();
        }
        return this.stop - this.start;
    }

    public boolean isNano() {
        return this.nano;
    }
}

