/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.http;

import com.wizzardo.tools.http.ConnectionMethod;
import com.wizzardo.tools.http.ContentType;
import com.wizzardo.tools.http.HttpSession;
import com.wizzardo.tools.http.RequestArguments;
import com.wizzardo.tools.http.Response;
import com.wizzardo.tools.misc.Unchecked;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class Request
extends RequestArguments<Request> {
    protected String url;
    protected HttpSession session;

    public Request(String url) {
        this.url = url;
    }

    @Override
    public Request createRequest(String url) {
        return super.createRequest(url).setSession(this.session);
    }

    public String getUrl() {
        try {
            return this.createURL(this.url, this.params);
        }
        catch (UnsupportedEncodingException e) {
            return this.url;
        }
    }

    public Response execute() throws IOException {
        return this.execute(0);
    }

    public Response get() throws IOException {
        this.setMethod(ConnectionMethod.GET);
        return this.execute(0);
    }

    public Response post() throws IOException {
        this.setMethod(ConnectionMethod.POST);
        return this.execute(0);
    }

    protected Request setSession(HttpSession session) {
        this.session = session;
        return this;
    }

    @Override
    protected Request self() {
        return this;
    }

    private Response execute(int retryNumber) throws IOException {
        try {
            HttpsURLConnection https;
            String url = this.url;
            if (this.data != null || this.method != ConnectionMethod.PUT && this.method != ConnectionMethod.POST) {
                url = this.createURL(url, this.params);
            }
            URL u = new URL(url);
            HttpURLConnection c = this.proxy != null ? (HttpURLConnection)u.openConnection(this.proxy) : (HttpURLConnection)u.openConnection();
            c.setInstanceFollowRedirects(false);
            c.setRequestMethod(this.method.toString());
            for (Map.Entry header : this.headers.entrySet()) {
                c.setRequestProperty((String)header.getKey(), (String)header.getValue());
            }
            if (this.hostnameVerifier != null && url.startsWith("https")) {
                https = (HttpsURLConnection)c;
                https.setHostnameVerifier(this.hostnameVerifier);
            }
            if (this.sslFactory != null && url.startsWith("https")) {
                https = (HttpsURLConnection)c;
                https.setSSLSocketFactory(this.sslFactory);
            }
            if (this.method == ConnectionMethod.POST || this.method == ConnectionMethod.PUT) {
                OutputStream out;
                c.setDoOutput(true);
                if (!this.multipart) {
                    if (this.data == null) {
                        c.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        this.data = this.createPostParameters(this.params, this.charsetForEncoding).getBytes(this.charsetForEncoding);
                    }
                    c.addRequestProperty("Content-Length", String.valueOf(this.data.length));
                    out = c.getOutputStream();
                    out.write(this.data);
                    out.flush();
                    out.close();
                } else {
                    c.setRequestProperty("Connection", "Keep-Alive");
                    c.setRequestProperty("Content-Type", "multipart/form-data; boundary=----WebKitFormBoundaryZzaC4MkAfrAMfJCJ");
                    c.setRequestProperty("Content-Length", String.valueOf(this.getLength()));
                    out = c.getOutputStream();
                    for (Map.Entry param : this.params.entrySet()) {
                        for (String value : (List)param.getValue()) {
                            String type;
                            out.write("------WebKitFormBoundaryZzaC4MkAfrAMfJCJ\r\n".getBytes());
                            String string = type = this.dataTypes.get(param.getKey()) != null ? (String)this.dataTypes.get(param.getKey()) : ContentType.BINARY.value;
                            if (value.startsWith("file://")) {
                                File f = new File(value.substring(7));
                                out.write(("Content-Disposition: form-data; name=\"" + (String)param.getKey() + "\"; filename=\"" + f.getName() + "\"\r\n").getBytes());
                                out.write(("Content-Type: " + type + "\r\n").getBytes());
                                out.write("\r\n".getBytes());
                                FileInputStream in = new FileInputStream(f);
                                int r = 0;
                                byte[] b = new byte[10240];
                                while ((r = in.read(b)) != -1) {
                                    out.write(b, 0, r);
                                    out.flush();
                                }
                                in.close();
                            } else if (value.startsWith("array://")) {
                                out.write(("Content-Disposition: form-data; name=\"" + (String)param.getKey() + "\"; filename=\"" + value.substring(8) + "\"\r\n").getBytes());
                                out.write(("Content-Type: " + type + "\r\n").getBytes());
                                out.write("\r\n".getBytes());
                                out.write((byte[])this.dataArrays.get(param.getKey()));
                            } else {
                                out.write(("Content-Disposition: form-data; name=\"" + (String)param.getKey() + "\"" + "\r\n\r\n").getBytes());
                                out.write(value.getBytes());
                            }
                            out.write("\r\n".getBytes());
                        }
                    }
                    out.write("------WebKitFormBoundaryZzaC4MkAfrAMfJCJ--".getBytes());
                    out.flush();
                    out.close();
                }
            }
            if (this.redirects && (c.getResponseCode() == 301 || c.getResponseCode() == 302)) {
                Response r = new Response(c, this.session);
                String path = r.getHeader("Location");
                if (!path.startsWith("http://") && !path.startsWith("https://")) {
                    path = u.getProtocol() + "://" + u.getHost() + path;
                }
                return this.session.createRequest(path).get();
            }
            return new Response(c, this.session);
        }
        catch (SocketTimeoutException e) {
            if (retryNumber < this.maxRetryCount) {
                try {
                    Thread.sleep(this.pauseBetweenRetries);
                }
                catch (InterruptedException ex1) {
                    throw Unchecked.rethrow((Exception)ex1);
                }
                return this.execute(++retryNumber);
            }
            throw new SocketTimeoutException();
        }
    }

    private int getLength() {
        int l = 0;
        l += "------WebKitFormBoundaryZzaC4MkAfrAMfJCJ\r\n".length() * (this.params.size() + 1) + 2;
        for (Map.Entry en : this.params.entrySet()) {
            for (String value : (List)en.getValue()) {
                if (value.startsWith("file://") || value.startsWith("array://")) {
                    String type = this.dataTypes.get(en.getKey()) != null ? (String)this.dataTypes.get(en.getKey()) : ContentType.BINARY.value;
                    l += ("Content-Type: " + type + "\r\n").length();
                    if (value.startsWith("file://")) {
                        l += "Content-Disposition: form-data; name=\"\"; filename=\"\"\r\n\r\n\r\n".length() + ((String)en.getKey()).getBytes().length + new File(value.substring(7)).getName().getBytes().length + value.length();
                        continue;
                    }
                    l += "Content-Disposition: form-data; name=\"\"; filename=\"\"\r\n\r\n\r\n".length() + ((String)en.getKey()).getBytes().length + ((byte[])this.dataArrays.get(en.getKey())).length + value.length();
                    continue;
                }
                l += "Content-Disposition: form-data; name=\"\"\r\n\r\n\r\n".length() + ((String)en.getKey()).getBytes().length + value.getBytes().length;
            }
        }
        return l;
    }

    private String createPostParameters(Map<String, List<String>> params, String urlEncoding) throws UnsupportedEncodingException {
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, List<String>>> iter = params.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, List<String>> entry = iter.next();
            boolean and = false;
            for (String value : entry.getValue()) {
                if (and) {
                    sb.append('&');
                } else {
                    and = true;
                }
                if (urlEncoding != null) {
                    sb.append(URLEncoder.encode(entry.getKey(), urlEncoding)).append("=");
                    sb.append(URLEncoder.encode(value, urlEncoding));
                    continue;
                }
                sb.append(URLEncoder.encode(entry.getKey(), "utf-8")).append("=");
                sb.append(URLEncoder.encode(value, "utf-8"));
            }
            if (!iter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    private String createURL(String url, Map<String, List<String>> params) throws UnsupportedEncodingException {
        if (params == null || params.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        if (!params.isEmpty()) {
            sb.append("?").append(this.createPostParameters(params, null).replace("+", "%20"));
        }
        return sb.toString();
    }
}

