/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.http;

import com.wizzardo.tools.http.Cookie;
import com.wizzardo.tools.http.HttpSession;
import com.wizzardo.tools.io.IOTools;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;

public class Response {
    private static ThreadLocal<SimpleDateFormat> dateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat get() {
            SimpleDateFormat format = (SimpleDateFormat)super.get();
            if (format == null) {
                format = new SimpleDateFormat("EEE, dd-MMM-yyyy kk:mm:ss z", Locale.US);
                this.set(format);
            }
            return format;
        }
    };
    private HttpURLConnection connection;
    private List<Cookie> cookies;
    private HttpSession session;

    protected Response(HttpURLConnection connection, HttpSession session) {
        this.connection = connection;
        this.session = session;
        if (session != null) {
            session.appendCookies(this.parseCookies());
        }
    }

    public String asString() throws IOException {
        int i;
        String encoding = this.connection.getHeaderField("Content-Type");
        encoding = encoding != null ? ((i = encoding.indexOf("charset=")) > 0 ? encoding.substring(i + "charset=".length()) : "utf-8") : "utf-8";
        return this.asString(encoding);
    }

    public byte[] asBytes() throws IOException {
        return IOTools.bytes((InputStream)this.asStream());
    }

    public InputStream asStream() throws IOException {
        InputStream inputStream;
        InputStream inputStream2 = inputStream = this.connection.getResponseCode() < 400 ? this.connection.getInputStream() : this.connection.getErrorStream();
        if ("gzip".equals(this.connection.getHeaderField("Content-Encoding"))) {
            inputStream = new GZIPInputStream(inputStream);
        } else if ("deflate".equals(this.connection.getHeaderField("Content-Encoding"))) {
            inputStream = new DeflaterInputStream(inputStream);
        }
        return inputStream;
    }

    public String asString(String charset) throws IOException {
        byte[] bytes = this.asBytes();
        return new String(bytes, charset);
    }

    public List<Cookie> getCookies() {
        if (this.session != null) {
            return this.session.getCookies(this.connection.getURL());
        }
        return this.parseCookies();
    }

    public List<Cookie> cookies() {
        return this.getCookies();
    }

    private List<Cookie> parseCookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        Map<String, List<String>> headers = this.connection.getHeaderFields();
        if (headers.containsKey("Set-Cookie")) {
            for (String raw : headers.get("Set-Cookie")) {
                String[] data = raw.split("; *");
                String[] kv = data[0].split("=", 2);
                Cookie cookie = new Cookie(kv[0], kv[1]);
                for (int i = 1; i < data.length; ++i) {
                    kv = data[i].split("=", 2);
                    if (kv[0].equalsIgnoreCase("expires")) {
                        try {
                            cookie.expired = dateFormatThreadLocal.get().parse(kv[1]);
                        }
                        catch (ParseException ignore) {}
                        continue;
                    }
                    if (kv[0].equalsIgnoreCase("path")) {
                        cookie.path = kv[1];
                        continue;
                    }
                    if (!kv[0].equalsIgnoreCase("domain")) continue;
                    cookie.domain = kv[1];
                }
                if (cookie.path == null) {
                    cookie.path = "/";
                }
                if (cookie.domain == null) {
                    cookie.domain = this.connection.getURL().getHost();
                }
                cookies.add(cookie);
            }
        }
        this.cookies = cookies;
        return cookies;
    }

    public String getHeader(String key) {
        return this.connection.getHeaderField(key);
    }

    public Map<String, List<String>> getHeaders() {
        return this.connection.getHeaderFields();
    }

    public String header(String key) {
        return this.getHeader(key);
    }

    public Map<String, List<String>> headers() {
        return this.getHeaders();
    }

    public int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }
}

