/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.image;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.wizzardo.tools.image.JpegEncoder;
import com.wizzardo.tools.image.Lanczos3Filter;
import com.wizzardo.tools.image.ResampleOp;
import com.wizzardo.tools.io.FileTools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;

public class ImageTools {
    private static ICC_Profile CMYK_PROFILE;

    public static void setCmykProfile(File iccProfile) throws IOException {
        ImageTools.setCmykProfile(new FileInputStream(iccProfile));
    }

    public static void setCmykProfile(InputStream iccProfile) throws IOException {
        CMYK_PROFILE = ICC_Profile.getInstance(iccProfile);
    }

    public static BufferedImage toGrayScale2(BufferedImage source) {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        BufferedImage im = new BufferedImage(source.getWidth(), source.getHeight(), 10);
        op.filter(source, im);
        return im;
    }

    public static BufferedImage toGrayScale(BufferedImage source) {
        BufferedImage im = new BufferedImage(source.getWidth(), source.getHeight(), 10);
        im.getGraphics().drawImage(source, 0, 0, null);
        return im;
    }

    public static void saveJPG(BufferedImage im, String file, int quality) throws IOException {
        ImageTools.saveJPG(im, new FileOutputStream(file), quality);
    }

    public static void saveJPG(BufferedImage im, File file, int quality) throws IOException {
        ImageTools.saveJPG(im, new FileOutputStream(file), quality);
    }

    public static byte[] saveJPGtoBytes(BufferedImage im, int quality) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ImageTools.saveJPG(im, bytes, quality);
        return bytes.toByteArray();
    }

    public static void saveJPG(BufferedImage im, OutputStream out, int quality) throws IOException {
        JpegEncoder encoder = new JpegEncoder(im, quality, out);
        encoder.Compress();
        out.close();
    }

    public static void savePNG(BufferedImage im, String file) throws IOException {
        ImageIO.write((RenderedImage)im, "png", new File(file));
    }

    public static void savePNG(BufferedImage im, File file) throws IOException {
        ImageIO.write((RenderedImage)im, "png", file);
    }

    public static void savePNG(BufferedImage im, OutputStream out) throws IOException {
        ImageIO.write((RenderedImage)im, "png", out);
    }

    public static byte[] savePNGtoBytes(BufferedImage im) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)im, "png", bytes);
        return bytes.toByteArray();
    }

    public static BufferedImage crop(BufferedImage src, int x1, int y1, int x2, int y2) {
        int x = x1 > x2 ? x2 : x1;
        int y = y1 > y2 ? y2 : y1;
        return src.getSubimage(x, y, Math.abs(x2 - x1), Math.abs(y2 - y1));
    }

    public static BufferedImage read(File f) throws IOException {
        return ImageTools.read(FileTools.bytes((File)f));
    }

    public static BufferedImage read(byte[] bytes) throws IOException {
        if (CMYK_PROFILE == null) {
            return ImageTools.read(new ByteArrayInputStream(bytes));
        }
        try {
            return ImageIO.read(new ByteArrayInputStream(bytes));
        }
        catch (IIOException e) {
            return ImageTools.readAndConvertFromCMYK(new ByteArrayInputStream(bytes));
        }
    }

    public static BufferedImage read(InputStream in) throws IOException {
        return ImageIO.read(in);
    }

    public static BufferedImage readAndConvertFromCMYK(InputStream in) throws IOException {
        if (CMYK_PROFILE == null) {
            throw new IOException("You need to setup CMYK profile first by method setCmykProfile");
        }
        return ImageTools.readAndConvertFromCMYK(in, CMYK_PROFILE);
    }

    public static BufferedImage readAndConvertFromCMYK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
        BufferedImage src = decoder.decodeAsBufferedImage();
        WritableRaster srcRaster = src.getRaster();
        BufferedImage result = new BufferedImage(srcRaster.getWidth(), srcRaster.getHeight(), 1);
        WritableRaster resultRaster = result.getRaster();
        ColorSpace sRGBColorSpace = ColorSpace.getInstance(1000);
        for (int x = srcRaster.getMinX(); x < srcRaster.getWidth(); ++x) {
            for (int y = srcRaster.getMinY(); y < srcRaster.getHeight(); ++y) {
                float[] pixel = srcRaster.getPixel(x, y, (float[])null);
                pixel[3] = 255.0f - pixel[3];
                srcRaster.setPixel(x, y, pixel);
            }
        }
        ColorConvertOp cmykToRgb = new ColorConvertOp(new ICC_ColorSpace(cmykProfile), sRGBColorSpace, null);
        cmykToRgb.filter(srcRaster, resultRaster);
        return result;
    }

    public static BufferedImage read(String f) throws IOException {
        return ImageTools.read(new File(f));
    }

    public static BufferedImage trim(BufferedImage src) {
        return ImageTools.trim(src, 0);
    }

    public static BufferedImage trim(BufferedImage src, int diff) {
        return ImageTools.trimHorizontal(ImageTools.trimVertical(src, diff), diff);
    }

    public static BufferedImage trimHorizontal(BufferedImage src) {
        return ImageTools.trimHorizontal(src, 0);
    }

    public static BufferedImage trimVertical(BufferedImage src) {
        return ImageTools.trimVertical(src, 0);
    }

    public static BufferedImage trimHorizontal(BufferedImage src, int diff) {
        int x;
        int color = src.getRGB(0, 0);
        boolean clear = true;
        for (x = 0; x < src.getWidth() && clear; ++x) {
            for (int y = 0; clear && y < src.getHeight(); ++y) {
                clear = ImageTools.diff(color, src.getRGB(x, y)) <= diff;
            }
        }
        int left = --x > 0 ? x - 1 : 0;
        clear = true;
        for (x = src.getWidth() - 1; x >= 0 && clear; --x) {
            for (int y = 0; clear && y < src.getHeight(); ++y) {
                clear = ImageTools.diff(color, src.getRGB(x, y)) <= diff;
            }
        }
        int right = ++x < src.getWidth() ? x + 1 : src.getWidth();
        return ImageTools.crop(src, left, 0, right, src.getHeight());
    }

    public static BufferedImage trimVertical(BufferedImage src, int diff) {
        int y;
        int color = src.getRGB(0, 0);
        boolean clear = true;
        for (y = 0; y < src.getHeight() && clear; ++y) {
            for (int x = 0; clear && x < src.getWidth(); ++x) {
                clear = ImageTools.diff(color, src.getRGB(x, y)) <= diff;
            }
        }
        int top = --y > 0 ? y - 1 : 0;
        clear = true;
        for (y = src.getHeight() - 1; y >= 0 && clear; --y) {
            for (int x = 0; clear && x < src.getWidth(); ++x) {
                clear = ImageTools.diff(color, src.getRGB(x, y)) <= diff;
            }
        }
        int bottom = ++y < src.getHeight() ? y + 1 : src.getHeight();
        return ImageTools.crop(src, 0, top, src.getWidth(), bottom);
    }

    public static int alpha(int rgb) {
        return rgb >> 24 & 0xFF;
    }

    public static int red(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int green(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int blue(int rgb) {
        return rgb >> 0 & 0xFF;
    }

    public static int diff(Color c1, Color c2) {
        return ImageTools.diff(c1.getRGB(), c2.getRGB());
    }

    public static int diff(int c1, int c2) {
        return (int)Math.sqrt(Math.pow(ImageTools.alpha(c1) - ImageTools.alpha(c2), 2.0) + Math.pow(ImageTools.red(c1) - ImageTools.red(c2), 2.0) + Math.pow(ImageTools.green(c1) - ImageTools.green(c2), 2.0) + Math.pow(ImageTools.blue(c1) - ImageTools.blue(c2), 2.0));
    }

    public static void drawThickLine(Graphics g, int x1, int y1, int x2, int y2, int thickness, Color c) {
        g.setColor(c);
        int dX = x2 - x1;
        int dY = y2 - y1;
        double lineLength = Math.sqrt(dX * dX + dY * dY);
        double scale = (double)thickness / (2.0 * lineLength);
        double ddx = -scale * (double)dY;
        double ddy = scale * (double)dX;
        double d = ddy > 0.0 ? 0.5 : -0.5;
        int dx = (int)(ddx += ddx > 0.0 ? 0.5 : -0.5);
        int dy = (int)(ddy += d);
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        xPoints[0] = x1 + dx;
        yPoints[0] = y1 + dy;
        xPoints[1] = x1 - dx;
        yPoints[1] = y1 - dy;
        xPoints[2] = x2 - dx;
        yPoints[2] = y2 - dy;
        xPoints[3] = x2 + dx;
        yPoints[3] = y2 + dy;
        g.fillPolygon(xPoints, yPoints, 4);
    }

    public static BufferedImage resizeToWidth(BufferedImage im, int width) throws IOException {
        double scale = (double)width * 1.0 / (double)im.getWidth();
        return ImageTools.resize(im, scale);
    }

    public static BufferedImage resizeToHeight(BufferedImage im, int height) throws IOException {
        double scale = (double)height * 1.0 / (double)im.getHeight();
        return ImageTools.resize(im, scale);
    }

    public static BufferedImage resizeToFit(BufferedImage im, int width, int height) throws IOException {
        double scale = Math.min((double)width * 1.0 / (double)im.getWidth(), (double)height * 1.0 / (double)im.getHeight());
        return ImageTools.resize(im, scale);
    }

    public static BufferedImage resize(BufferedImage im, double scale) {
        int width = (int)((double)im.getWidth() * scale + 0.5);
        int height = (int)((double)im.getHeight() * scale + 0.5);
        ResampleOp resizeOp = new ResampleOp(new Lanczos3Filter(), width, height);
        return resizeOp.filter(im, null);
    }

    public static BufferedImage applyAlphaMask(BufferedImage src, BufferedImage mask) {
        WritableRaster alpha = mask.getAlphaRaster();
        int[] data = new int[mask.getWidth() * mask.getHeight()];
        alpha.getPixels(0, 0, mask.getWidth(), mask.getHeight(), data);
        if (src.getAlphaRaster() == null) {
            BufferedImage t = new BufferedImage(src.getWidth(), src.getHeight(), 2);
            t.getGraphics().drawImage(src, 0, 0, null);
            src = t;
        }
        src.getAlphaRaster().setPixels(0, 0, mask.getWidth(), mask.getHeight(), data);
        return src;
    }

    public static BufferedImage applyMask(BufferedImage src, BufferedImage mask) {
        if (src.getAlphaRaster() == null) {
            BufferedImage t = new BufferedImage(src.getWidth(), src.getHeight(), 2);
            t.getGraphics().drawImage(src, 0, 0, null);
            src = t;
        }
        int w = Math.min(src.getWidth(), mask.getWidth());
        int h = Math.min(src.getHeight(), mask.getHeight());
        int[] data = mask.getRGB(0, 0, w, h, null, 0, w);
        for (int i = 0; i < data.length; ++i) {
            data[i] = ImageTools.red(data[i]);
        }
        src.getAlphaRaster().setPixels(0, 0, w, h, data);
        return src;
    }

    public static BufferedImage drawOver(BufferedImage src, BufferedImage img) {
        src.getGraphics().drawImage(img, 0, 0, null);
        return src;
    }

    public static BufferedImage resizeCanvas(BufferedImage src, int width, int height, Color background) {
        return ImageTools.resizeCanvas(src, width, height, background, Position.CENTER);
    }

    public static BufferedImage resizeCanvas(BufferedImage src, int width, int height, Color background, Position p) {
        int y;
        int x;
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics g = img.getGraphics();
        if (background != null) {
            g.setColor(background);
            g.fillRect(0, 0, img.getWidth(), img.getHeight());
        }
        switch (p) {
            case TOP: {
                x = (width - src.getWidth()) / 2;
                y = 0;
                break;
            }
            case BOTTOM: {
                x = (width - src.getWidth()) / 2;
                y = height - src.getHeight();
                break;
            }
            case LEFT: {
                x = 0;
                y = (height - src.getHeight()) / 2;
                break;
            }
            case RIGHT: {
                x = width - src.getWidth();
                y = (height - src.getHeight()) / 2;
                break;
            }
            case LEFT_TOP: {
                x = 0;
                y = 0;
                break;
            }
            case LEFT_BOTTOM: {
                x = 0;
                y = height - src.getHeight();
                break;
            }
            case RIGHT_TOP: {
                x = width - src.getWidth();
                y = 0;
                break;
            }
            case RIGHT_BOTTOM: {
                x = width - src.getWidth();
                y = height - src.getHeight();
                break;
            }
            default: {
                x = (width - src.getWidth()) / 2;
                y = (height - src.getHeight()) / 2;
            }
        }
        g.drawImage(src, x, y, null);
        return img;
    }

    public static BufferedImage colorToAlpha(BufferedImage im, Color c) {
        BufferedImage img = new BufferedImage(im.getWidth(), im.getHeight(), 6);
        int[] temp = new int[4];
        WritableRaster src = im.getRaster();
        WritableRaster result = img.getRaster();
        boolean hasAlpha = im.getColorModel().hasAlpha();
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        for (int x = 0; x < im.getWidth(); ++x) {
            for (int y = 0; y < im.getHeight(); ++y) {
                ImageTools.colorToAlpha(src.getPixel(x, y, temp), hasAlpha, r, g, b);
                result.setPixel(x, y, temp);
            }
        }
        return img;
    }

    private static void colorToAlpha(int[] c, boolean hasAlpha, int r1, int g1, int b1) {
        int a;
        int b;
        int g;
        int r;
        if (hasAlpha) {
            r = c[0];
            g = c[1];
            b = c[2];
            a = c[3];
        } else {
            a = 255;
            r = c[0];
            g = c[1];
            b = c[2];
        }
        float red = r1 == 0 ? (float)r : (r > r1 ? (float)(r - r1) / (255.0f - (float)r1) : (r < r1 ? (float)(r1 - r) / ((float)r1 * 1.0f) : 0.0f));
        float green = g1 == 0 ? (float)g : (g > g1 ? (float)(g - g1) / (255.0f - (float)g1) : (g < g1 ? (float)(g1 - g) / ((float)g1 * 1.0f) : 0.0f));
        float blue = b1 == 0 ? (float)b : (b > b1 ? (float)(b - b1) / (255.0f - (float)b1) : (b < b1 ? (float)(b1 - b) / ((float)b1 * 1.0f) : 0.0f));
        float alpha = red > green ? (red > blue ? red : blue) : (green > blue ? green : blue);
        if ((double)alpha < 0.001) {
            c[3] = (int)(alpha * 255.0f);
        }
        r = (int)((float)(r - r1) / alpha + (float)r1 + 0.5f);
        g = (int)((float)(g - g1) / alpha + (float)g1 + 0.5f);
        b = (int)((float)(b - b1) / alpha + (float)b1 + 0.5f);
        a = (int)((float)a * alpha + 0.5f);
        c[0] = r;
        c[1] = g;
        c[2] = b;
        c[3] = a;
    }

    public static String toString(Color c) {
        return "[" + c.getAlpha() + "," + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "]";
    }

    public static BufferedImage rotate(BufferedImage img, double angle) {
        double angleRadians = Math.toRadians(angle);
        int width = img.getWidth();
        int height = img.getHeight();
        double x = width / 2;
        double y = height / 2;
        double cos = Math.abs(Math.cos(angleRadians));
        double sin = Math.abs(Math.sin(angleRadians));
        int w = (int)((double)width * cos + (double)height * sin + 0.5);
        int h = (int)((double)width * sin + (double)height * cos + 0.5);
        BufferedImage result = new BufferedImage(w, h, img.getType());
        Graphics2D g = result.createGraphics();
        g.translate((w - img.getWidth()) / 2, (h - img.getHeight()) / 2);
        g.rotate(angleRadians, x, y);
        g.drawRenderedImage(img, null);
        g.dispose();
        return result;
    }

    public static enum Position {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        CENTER,
        LEFT_TOP,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

