/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.image;

import java.awt.Image;
import java.awt.image.PixelGrabber;

class JpegInfo {
    private String comment;
    private Image imageobj;
    int imageHeight;
    int imageWidth;
    int[] BlockWidth;
    int[] BlockHeight;
    int Precision = 8;
    int NumberOfComponents = 3;
    float[][][] Components;
    int[] CompID = new int[]{1, 2, 3};
    int[] HsampFactor = new int[]{1, 1, 1};
    int[] VsampFactor = new int[]{1, 1, 1};
    int[] QtableNumber = new int[]{0, 1, 1};
    int[] DCtableNumber = new int[]{0, 1, 1};
    int[] ACtableNumber = new int[]{0, 1, 1};
    boolean[] lastColumnIsDummy = new boolean[]{false, false, false};
    boolean[] lastRowIsDummy = new boolean[]{false, false, false};
    int Ss = 0;
    int Se = 63;
    int Ah = 0;
    int Al = 0;
    private int[] compWidth;
    private int[] compHeight;

    public JpegInfo(Image image) {
        this.Components = new float[this.NumberOfComponents][][];
        this.compWidth = new int[this.NumberOfComponents];
        this.compHeight = new int[this.NumberOfComponents];
        this.BlockWidth = new int[this.NumberOfComponents];
        this.BlockHeight = new int[this.NumberOfComponents];
        this.imageobj = image;
        this.imageWidth = image.getWidth(null);
        this.imageHeight = image.getHeight(null);
        this.comment = "JPEG Encoder Copyright 1998, James R. Weeks and BioElectroMech.  ";
        this.getYCCArray();
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    private void getYCCArray() {
        int y;
        int[] values = new int[this.imageWidth * this.imageHeight];
        PixelGrabber grabber = new PixelGrabber(this.imageobj.getSource(), 0, 0, this.imageWidth, this.imageHeight, values, 0, this.imageWidth);
        int maxHsampFactor = 1;
        int maxVsampFactor = 1;
        for (y = 0; y < this.NumberOfComponents; ++y) {
            maxHsampFactor = Math.max(maxHsampFactor, this.HsampFactor[y]);
            maxVsampFactor = Math.max(maxVsampFactor, this.VsampFactor[y]);
        }
        for (y = 0; y < this.NumberOfComponents; ++y) {
            this.compWidth[y] = (this.imageWidth % 8 != 0 ? (int)Math.ceil((double)this.imageWidth / 8.0) * 8 : this.imageWidth) / maxHsampFactor * this.HsampFactor[y];
            if (this.compWidth[y] != this.imageWidth / maxHsampFactor * this.HsampFactor[y]) {
                this.lastColumnIsDummy[y] = true;
            }
            this.BlockWidth[y] = (int)Math.ceil((double)this.compWidth[y] / 8.0);
            this.compHeight[y] = (this.imageHeight % 8 != 0 ? (int)Math.ceil((double)this.imageHeight / 8.0) * 8 : this.imageHeight) / maxVsampFactor * this.VsampFactor[y];
            if (this.compHeight[y] != this.imageHeight / maxVsampFactor * this.VsampFactor[y]) {
                this.lastRowIsDummy[y] = true;
            }
            this.BlockHeight[y] = (int)Math.ceil((double)this.compHeight[y] / 8.0);
        }
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        float[][] Y = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cr1 = new float[this.compHeight[0]][this.compWidth[0]];
        float[][] Cb1 = new float[this.compHeight[0]][this.compWidth[0]];
        int index = 0;
        for (y = 0; y < this.imageHeight; ++y) {
            for (int x = 0; x < this.imageWidth; ++x) {
                int r = values[index] >> 16 & 0xFF;
                int g = values[index] >> 8 & 0xFF;
                int b = values[index] & 0xFF;
                Y[y][x] = (float)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                Cb1[y][x] = 128.0f + (float)(-0.16874 * (double)r - 0.33126 * (double)g + 0.5 * (double)b);
                Cr1[y][x] = 128.0f + (float)(0.5 * (double)r - 0.41869 * (double)g - 0.08131 * (double)b);
                ++index;
            }
        }
        this.Components[0] = Y;
        this.Components[1] = Cb1;
        this.Components[2] = Cr1;
    }

    float[][] DownSample(float[][] C, int comp) {
        int inrow = 0;
        int incol = 0;
        float[][] output = new float[this.compHeight[comp]][this.compWidth[comp]];
        for (int outrow = 0; outrow < this.compHeight[comp]; ++outrow) {
            int bias = 1;
            for (int outcol = 0; outcol < this.compWidth[comp]; ++outcol) {
                output[outrow][outcol] = (C[inrow][incol++] + C[inrow++][incol--] + C[inrow][incol++] + C[inrow--][incol++] + (float)bias) / 4.0f;
                bias ^= 3;
            }
            inrow += 2;
            incol = 0;
        }
        return output;
    }
}

