/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.json;

import com.wizzardo.tools.misc.ExceptionDrivenStringBuilder;
import com.wizzardo.tools.misc.Unchecked;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

abstract class Appender {
    public static final Charset UTF8 = Charset.forName("utf-8");

    Appender() {
    }

    public abstract void append(String var1);

    public abstract void append(String var1, int var2, int var3);

    public abstract void append(char[] var1, int var2, int var3);

    public abstract void append(char var1);

    public void append(int s) {
        this.append(String.valueOf(s));
    }

    public void append(long s) {
        this.append(String.valueOf(s));
    }

    public void append(boolean s) {
        this.append(String.valueOf(s));
    }

    public void append(float s) {
        this.append(String.valueOf(s));
    }

    public void append(double s) {
        this.append(String.valueOf(s));
    }

    public abstract void flush();

    public void append(Object ob) {
        this.append(String.valueOf(ob));
    }

    public void append(char[] chars) {
        this.append(chars, 0, chars.length);
    }

    static Appender create() {
        return new StringBuilderAppender();
    }

    static Appender create(StringBuilder sb) {
        return new StringBuilderAppender(sb);
    }

    static Appender create(ExceptionDrivenStringBuilder sb) {
        return new ExceptionDrivenStringBuilderAppender(sb);
    }

    static Appender create(OutputStream out) {
        return new StreamAppender(out);
    }

    private static class StreamAppender
    extends Appender {
        private OutputStreamWriter out;

        StreamAppender(OutputStream out) {
            this.out = new OutputStreamWriter(out, UTF8);
        }

        @Override
        public void append(String s) {
            try {
                this.out.write(s);
            }
            catch (IOException e) {
                throw Unchecked.rethrow((Exception)e);
            }
        }

        @Override
        public void append(String s, int from, int to) {
            try {
                this.out.append(s, from, to);
            }
            catch (IOException e) {
                throw Unchecked.rethrow((Exception)e);
            }
        }

        @Override
        public void append(char[] s, int from, int to) {
            try {
                this.out.write(s, from, to - from);
            }
            catch (IOException e) {
                throw Unchecked.rethrow((Exception)e);
            }
        }

        @Override
        public void append(char s) {
            try {
                this.out.append(s);
            }
            catch (IOException e) {
                throw Unchecked.rethrow((Exception)e);
            }
        }

        @Override
        public void flush() {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                throw Unchecked.rethrow((Exception)e);
            }
        }
    }

    private static class ExceptionDrivenStringBuilderAppender
    extends Appender {
        private ExceptionDrivenStringBuilder sb;

        ExceptionDrivenStringBuilderAppender(ExceptionDrivenStringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void append(String s) {
            this.sb.append(s);
        }

        @Override
        public void append(String s, int from, int to) {
            this.sb.append(s, from, to);
        }

        @Override
        public void append(char[] s, int from, int to) {
            this.sb.append(s, from, to - from);
        }

        @Override
        public void append(char s) {
            this.sb.append(s);
        }

        @Override
        public void append(int s) {
            this.sb.append(s);
        }

        @Override
        public void append(long s) {
            this.sb.append(s);
        }

        @Override
        public void append(boolean s) {
            this.sb.append(s);
        }

        @Override
        public void append(float s) {
            this.sb.append(s);
        }

        @Override
        public void append(double s) {
            this.sb.append(s);
        }

        @Override
        public void flush() {
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    private static class StringBuilderAppender
    extends Appender {
        private StringBuilder sb;

        StringBuilderAppender() {
            this(new StringBuilder());
        }

        StringBuilderAppender(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void append(String s) {
            this.sb.append(s);
        }

        @Override
        public void append(String s, int from, int to) {
            this.sb.append(s, from, to);
        }

        @Override
        public void append(char[] s, int from, int to) {
            this.sb.append(s, from, to - from);
        }

        @Override
        public void append(char s) {
            this.sb.append(s);
        }

        @Override
        public void append(int s) {
            this.sb.append(s);
        }

        @Override
        public void append(long s) {
            this.sb.append(s);
        }

        @Override
        public void append(boolean s) {
            this.sb.append(s);
        }

        @Override
        public void append(float s) {
            this.sb.append(s);
        }

        @Override
        public void append(double s) {
            this.sb.append(s);
        }

        @Override
        public void flush() {
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

