/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.json;

import com.wizzardo.tools.json.Binder;
import com.wizzardo.tools.json.FieldInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class Generic<T> {
    final Class<T> clazz;
    final Generic[] typeParameters;
    final Generic parent;
    final Binder.Serializer serializer;
    private Map<String, Generic> types;
    private Map<String, FieldInfo> fields;

    public Generic(Type c) {
        this(c, (Map<String, Generic>)null);
    }

    public Generic(Class<T> c, Class ... generics) {
        this.clazz = c;
        this.parent = null;
        this.serializer = Binder.classToSerializer(this.clazz);
        if (generics == null) {
            this.typeParameters = new Generic[0];
            return;
        }
        this.typeParameters = new Generic[generics.length];
        for (int i = 0; i < generics.length; ++i) {
            this.typeParameters[i] = new Generic<T>(generics[i]);
        }
        this.types = this.getTypes(c, this.typeParameters);
    }

    public Generic(Class<T> c, Generic ... generics) {
        this.clazz = c;
        this.parent = null;
        this.serializer = Binder.classToSerializer(this.clazz);
        this.typeParameters = generics == null ? new Generic[0] : generics;
        this.types = this.getTypes(c, this.typeParameters);
    }

    private Map<String, Generic> getTypes(Class<T> c, Generic[] generics) {
        TypeVariable<Class<T>>[] variables = this.clazz.getTypeParameters();
        if (variables.length == 0 || generics.length == 0) {
            return null;
        }
        HashMap<String, Generic> types = new HashMap<String, Generic>();
        for (int i = 0; i < variables.length && i < generics.length; ++i) {
            types.put(variables[i].getName(), generics[i]);
        }
        return types;
    }

    Generic(Type c, Map<String, Generic> types) {
        if (c instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)c;
            this.clazz = (Class)type.getRawType();
            Type[] args = type.getActualTypeArguments();
            TypeVariable<Class<T>>[] variables = this.clazz.getTypeParameters();
            this.types = new HashMap<String, Generic>();
            this.typeParameters = new Generic[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.typeParameters[i] = new Generic<T>(args[i], types);
                this.types.put(variables[i].getName(), this.typeParameters[i]);
            }
            this.parent = this.clazz.getGenericSuperclass() != null ? new Generic<T>(this.clazz.getGenericSuperclass(), this.types) : null;
        } else if (c instanceof TypeVariable) {
            if (types != null) {
                Generic g = types.get(((TypeVariable)c).getName());
                this.clazz = g.clazz;
                this.parent = g.parent;
                this.typeParameters = g.typeParameters;
            } else {
                this.clazz = Object.class;
                this.parent = null;
                this.typeParameters = new Generic[0];
            }
        } else if (c instanceof GenericArrayType) {
            this.parent = null;
            this.clazz = Array.class;
            this.typeParameters = new Generic[]{new Generic<T>(((GenericArrayType)c).getGenericComponentType())};
        } else {
            Class cl = (Class)c;
            if (cl.isArray()) {
                this.clazz = Array.class;
                this.serializer = Binder.classToSerializer(this.clazz);
                this.typeParameters = new Generic[]{new Generic<T>(cl.getComponentType())};
                this.parent = null;
                return;
            }
            this.clazz = cl;
            this.typeParameters = new Generic[0];
            this.parent = !this.clazz.isEnum() && this.clazz.getGenericSuperclass() != null ? new Generic<T>(this.clazz.getGenericSuperclass(), types) : null;
        }
        this.serializer = Binder.classToSerializer(this.clazz);
    }

    public String toString() {
        return this.clazz.getSimpleName();
    }

    public Generic getGenericType(Field f) {
        Generic g = this;
        while (g != null && g.clazz != f.getDeclaringClass()) {
            g = g.parent;
        }
        if (g != null && f.getGenericType() instanceof TypeVariable) {
            return g.types.get(((TypeVariable)f.getGenericType()).getName());
        }
        return null;
    }

    public Map<String, FieldInfo> getFields() {
        if (this.fields != null) {
            return this.fields;
        }
        this.fields = Binder.getFields(this.clazz);
        return this.fields;
    }
}

