/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.json;

import com.wizzardo.tools.json.Binder;
import com.wizzardo.tools.json.Generic;
import com.wizzardo.tools.json.JavaMapBinder;
import com.wizzardo.tools.json.JavaObjectBinder;
import com.wizzardo.tools.json.JsonBinder;
import com.wizzardo.tools.json.JsonFieldSetter;
import com.wizzardo.tools.json.JsonItem;
import com.wizzardo.tools.json.StringConverter;
import com.wizzardo.tools.reflection.FieldReflection;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class JavaArrayBinder
implements JsonBinder {
    private Collection l;
    private Binder.SerializerType serializer;
    private Class clazz;
    private Generic generic;
    private JsonFieldSetter valueSetter;

    public JavaArrayBinder(Generic generic) {
        this.generic = generic != null ? generic : new Generic((Type)((Object)Object.class));
        this.clazz = this.generic.clazz;
        this.serializer = Binder.classToSerializer((Class)this.clazz).type;
        if (this.serializer == Binder.SerializerType.ARRAY) {
            this.l = new ArrayList();
        } else if (this.serializer == Binder.SerializerType.COLLECTION) {
            this.l = Binder.createCollection(this.clazz);
        } else {
            throw new IllegalArgumentException("this binder only for collections and arrays! not for " + this.clazz);
        }
        if (generic.typeParameters.length == 1) {
            this.valueSetter = this.getValueSetter(generic.typeParameters[0].clazz);
        }
    }

    protected JsonFieldSetter getValueSetter(Class clazz) {
        final StringConverter converter = StringConverter.getConverter(clazz);
        if (converter == null) {
            return null;
        }
        return new JsonFieldSetter.ObjectSetter(){

            @Override
            public void setString(Object object, String value) {
                JavaArrayBinder.this.l.add(converter.convert(value));
            }

            public void setObject(Object object, Object value) {
                JavaArrayBinder.this.l.add(value);
            }

            public FieldReflection.Type getType() {
                return converter.type;
            }
        };
    }

    @Override
    public void add(Object value) {
        this.l.add(value);
    }

    @Override
    public void add(JsonItem value) {
        throw new UnsupportedOperationException("only raw objects are supported");
    }

    @Override
    public Object getObject() {
        if (this.serializer == Binder.SerializerType.COLLECTION) {
            return this.l;
        }
        List l = (List)this.l;
        Object array = Binder.createArray(this.generic, l.size());
        Class type = this.generic.typeParameters[0].clazz;
        for (int i = 0; i < l.size(); ++i) {
            Array.set(array, i, JsonItem.getAs(l.get(i), type));
        }
        return array;
    }

    public Generic getGeneric() {
        if (this.generic != null && this.generic.typeParameters.length != 0) {
            return this.generic.typeParameters[0];
        }
        return null;
    }

    @Override
    public JsonFieldSetter getFieldSetter() {
        return this.valueSetter;
    }

    @Override
    public JsonBinder getObjectBinder() {
        if (Map.class.isAssignableFrom(this.generic.typeParameters[0].clazz)) {
            return new JavaMapBinder(this.generic.typeParameters[0]);
        }
        return new JavaObjectBinder(this.generic.typeParameters[0]);
    }

    @Override
    public JsonBinder getArrayBinder() {
        return new JavaArrayBinder(this.getGeneric());
    }

    @Override
    public void setTemporaryKey(String key) {
        throw new UnsupportedOperationException("arrays has no keys");
    }
}

