/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.json;

import com.wizzardo.tools.json.Binder;
import com.wizzardo.tools.json.Generic;
import com.wizzardo.tools.json.JavaArrayBinder;
import com.wizzardo.tools.json.JavaObjectBinder;
import com.wizzardo.tools.json.JsonBinder;
import com.wizzardo.tools.json.JsonFieldSetter;
import com.wizzardo.tools.json.StringConverter;
import com.wizzardo.tools.reflection.FieldReflection;
import java.lang.reflect.Type;
import java.util.Map;

public class JavaMapBinder
extends JavaObjectBinder {
    private Map that;
    private Generic[] type;
    private boolean valueIsMap;
    private JsonFieldSetter valueSetter;
    private StringConverter keyConverter;

    public JavaMapBinder(Generic generic) {
        super(generic);
        this.that = (Map)this.object;
        this.type = this.getTypes(generic);
        this.valueIsMap = Map.class.isAssignableFrom(this.type[1].clazz);
        this.keyConverter = StringConverter.getConverter(this.type[0].clazz);
        this.valueSetter = this.getValueSetter(this.type[1].clazz);
    }

    protected JsonFieldSetter getValueSetter(Class classValue) {
        final StringConverter valueConverter = StringConverter.getConverter(classValue);
        if (valueConverter == null || this.keyConverter == null) {
            return null;
        }
        return new JsonFieldSetter.ObjectSetter(){

            @Override
            public void setString(Object object, String value) {
                JavaMapBinder.this.put(JavaMapBinder.this.keyConverter, valueConverter, value);
            }

            public void setObject(Object object, Object value) {
                JavaMapBinder.this.put(JavaMapBinder.this.keyConverter, value);
            }

            public FieldReflection.Type getType() {
                return valueConverter.type;
            }
        };
    }

    protected void put(StringConverter keyConverter, StringConverter valueConverter, String value) {
        this.put(keyConverter, valueConverter.convert(value));
    }

    protected void put(StringConverter keyConverter, Object value) {
        this.that.put(keyConverter.convert(this.tempKey), value);
    }

    @Override
    protected Map createInstance(Class clazz) {
        return Binder.createMap(clazz);
    }

    private Generic[] getTypes(Generic generic) {
        if (generic == null) {
            return new Generic[]{new Generic((Type)((Object)Object.class)), new Generic((Type)((Object)Object.class))};
        }
        if (generic.typeParameters.length != 2) {
            return this.getTypes(generic.parent);
        }
        return generic.typeParameters;
    }

    @Override
    public void add(Object value) {
        this.put(this.keyConverter, value);
    }

    @Override
    public JsonBinder getObjectBinder() {
        if (this.valueIsMap) {
            return new JavaMapBinder(this.type[1]);
        }
        return new JavaObjectBinder(this.type[1]);
    }

    @Override
    public JsonBinder getArrayBinder() {
        return new JavaArrayBinder(this.type[1]);
    }

    @Override
    public JsonFieldSetter getFieldSetter() {
        return this.valueSetter;
    }
}

