/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.json;

import com.wizzardo.tools.json.Binder;
import com.wizzardo.tools.json.FieldInfo;
import com.wizzardo.tools.json.Generic;
import com.wizzardo.tools.json.JavaArrayBinder;
import com.wizzardo.tools.json.JavaMapBinder;
import com.wizzardo.tools.json.JsonBinder;
import com.wizzardo.tools.json.JsonFieldSetter;
import com.wizzardo.tools.json.JsonItem;
import java.util.Map;

class JavaObjectBinder
implements JsonBinder {
    protected Object object;
    protected Class clazz;
    protected Generic generic;
    protected Map<String, FieldInfo> fields;
    protected String tempKey;

    public JavaObjectBinder(Generic generic) {
        this.clazz = generic.clazz;
        this.generic = generic;
        this.object = this.createInstance(this.clazz);
        this.fields = Binder.getFields(this.clazz);
    }

    protected Object createInstance(Class clazz) {
        return Binder.createObject(clazz);
    }

    private FieldInfo getField() {
        return this.fields.get(this.tempKey);
    }

    @Override
    public void add(Object value) {
        FieldInfo fieldInfo = this.getField();
        if (fieldInfo == null) {
            return;
        }
        fieldInfo.setter.setObject(this.object, value);
    }

    @Override
    public void add(JsonItem value) {
        throw new UnsupportedOperationException("only raw objects are supported");
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public JsonBinder getObjectBinder() {
        FieldInfo info = this.getField();
        if (info == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(info.field.getType())) {
            return new JavaMapBinder(info.generic);
        }
        return new JavaObjectBinder(info.generic);
    }

    @Override
    public JsonBinder getArrayBinder() {
        Generic type;
        FieldInfo info = this.getField();
        if (info == null) {
            return null;
        }
        if (this.generic != null && (type = this.generic.getGenericType(info.field)) != null) {
            return new JavaArrayBinder(type);
        }
        return new JavaArrayBinder(info.generic);
    }

    @Override
    public void setTemporaryKey(String key) {
        this.tempKey = key;
    }

    @Override
    public JsonFieldSetter getFieldSetter() {
        FieldInfo f = this.getField();
        if (f != null) {
            return f.setter;
        }
        return null;
    }
}

