/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.json;

import com.wizzardo.tools.json.Appender;
import com.wizzardo.tools.json.JsonBinder;
import com.wizzardo.tools.json.JsonItem;
import com.wizzardo.tools.json.JsonObject;
import com.wizzardo.tools.json.JsonTools;
import com.wizzardo.tools.json.JsonUtils;
import com.wizzardo.tools.misc.ExceptionDrivenStringBuilder;
import com.wizzardo.tools.misc.pool.Holder;
import java.util.ArrayList;
import java.util.Collection;

public class JsonArray
extends ArrayList<JsonItem> {
    static int parse(char[] s, int from, int to, JsonBinder json) {
        int i;
        block6: for (i = ++from; i < to; ++i) {
            char current = s[i];
            if (current <= ' ') continue;
            switch (current) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    i = JsonUtils.parseNumber(json, s, i, to);
                    break;
                }
                case '{': {
                    if (json == null) {
                        i = JsonObject.parse(s, i, to, null);
                        break;
                    }
                    JsonBinder ob = json.getObjectBinder();
                    i = JsonObject.parse(s, i, to, ob);
                    if (ob == null) break;
                    json.add(ob.getObject());
                    break;
                }
                case '[': {
                    if (json == null) {
                        i = JsonArray.parse(s, i, to, null);
                        break;
                    }
                    JsonBinder ob = json.getArrayBinder();
                    i = JsonArray.parse(s, i, to, ob);
                    if (ob == null) break;
                    json.add(ob.getObject());
                    break;
                }
                case ']': {
                    break block6;
                }
                default: {
                    i = JsonUtils.parseValue(json, s, i, to, ']');
                }
            }
            while ((current = s[i]) <= ' ') {
                ++i;
            }
            if (current == ',') continue;
            if (current == ']') break;
            throw new IllegalStateException("here must be ',' or ']' , but found: " + current);
        }
        return i + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Holder holder = JsonTools.builderPool.holder();
        try {
            ExceptionDrivenStringBuilder builder = (ExceptionDrivenStringBuilder)holder.get();
            Appender sb = Appender.create(builder);
            this.toJson(sb);
            String string = sb.toString();
            return string;
        }
        finally {
            holder.close();
        }
    }

    void toJson(Appender sb) {
        sb.append('[');
        boolean comma = false;
        for (JsonItem item : this) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            if (item == null) {
                sb.append("null");
                continue;
            }
            item.toJson(sb);
        }
        sb.append(']');
    }

    public JsonArray append(Object ob) {
        if (ob instanceof JsonItem) {
            this.add((JsonItem)ob);
        } else {
            this.add(new JsonItem(ob));
        }
        return this;
    }

    public JsonArray appendAll(Collection l) {
        if (l == null) {
            this.append(new JsonItem(null));
        } else {
            for (Object ob : l) {
                this.append(ob);
            }
        }
        return this;
    }
}

