/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.json;

import com.wizzardo.tools.json.JsonUtils;
import com.wizzardo.tools.json.StringConverter;
import com.wizzardo.tools.reflection.FieldReflection;
import java.lang.reflect.Field;

abstract class JsonFieldSetter
extends FieldReflection {
    protected JsonFieldSetter() {
    }

    protected JsonFieldSetter(Field f) {
        super(f);
    }

    public static JsonFieldSetter createSetter(Field f) {
        Class<?> cl = f.getType();
        if (cl == Integer.TYPE) {
            return new IntSetter(f);
        }
        if (cl == Long.TYPE) {
            return new LongSetter(f);
        }
        if (cl == Byte.TYPE) {
            return new ByteSetter(f);
        }
        if (cl == Short.TYPE) {
            return new ShortSetter(f);
        }
        if (cl == Float.TYPE) {
            return new FloatSetter(f);
        }
        if (cl == Double.TYPE) {
            return new DoubleSetter(f);
        }
        if (cl == Character.TYPE) {
            return new CharSetter(f);
        }
        if (cl == Boolean.TYPE) {
            return new BooleanSetter(f);
        }
        if (cl.isEnum()) {
            return new EnumSetter(f);
        }
        if (cl == Boolean.class) {
            return new BoxedSetter(f, StringConverter.TO_BOOLEAN);
        }
        if (cl == Integer.class) {
            return new BoxedSetter(f, StringConverter.TO_INTEGER);
        }
        if (cl == Long.class) {
            return new BoxedSetter(f, StringConverter.TO_LONG);
        }
        if (cl == Byte.class) {
            return new BoxedSetter(f, StringConverter.TO_BYTE);
        }
        if (cl == Short.class) {
            return new BoxedSetter(f, StringConverter.TO_SHORT);
        }
        if (cl == Character.class) {
            return new BoxedSetter(f, StringConverter.TO_CHARACTER);
        }
        if (cl == Float.class) {
            return new BoxedSetter(f, StringConverter.TO_FLOAT);
        }
        if (cl == Double.class) {
            return new BoxedSetter(f, StringConverter.TO_DOUBLE);
        }
        return new ObjectSetter(f);
    }

    public void setString(Object object, String value) {
        this.setObject(object, value);
    }

    public static class BoxedSetter
    extends ObjectSetter {
        private final StringConverter converter;

        BoxedSetter(Field f, StringConverter converter) {
            super(f);
            this.converter = converter;
        }

        @Override
        public void setString(Object object, String value) {
            this.setObject(object, this.converter.convert(value));
        }

        public FieldReflection.Type getType() {
            return this.converter.type;
        }
    }

    public static class EnumSetter
    extends JsonFieldSetter {
        EnumSetter(Field f) {
            super(f);
        }

        @Override
        public void setString(Object object, String value) {
            Class<?> cl = this.field.getType();
            this.setObject(object, JsonUtils.asEnum(cl, value));
        }
    }

    public static class ObjectSetter
    extends JsonFieldSetter {
        protected ObjectSetter() {
        }

        ObjectSetter(Field f) {
            super(f);
        }

        public void setInteger(Object object, int value) {
            this.setObject(object, value);
        }

        public void setLong(Object object, long value) {
            this.setObject(object, value);
        }

        public void setByte(Object object, byte value) {
            this.setObject(object, value);
        }

        public void setShort(Object object, short value) {
            this.setObject(object, value);
        }

        public void setFloat(Object object, float value) {
            this.setObject(object, Float.valueOf(value));
        }

        public void setDouble(Object object, double value) {
            this.setObject(object, value);
        }

        public void setChar(Object object, char value) {
            this.setObject(object, Character.valueOf(value));
        }

        public void setBoolean(Object object, boolean value) {
            this.setObject(object, value);
        }
    }

    public static class BooleanSetter
    extends JsonFieldSetter {
        BooleanSetter(Field f) {
            super(f);
        }

        @Override
        public void setString(Object object, String value) {
            this.setBoolean(object, Boolean.parseBoolean(value));
        }
    }

    public static class CharSetter
    extends JsonFieldSetter {
        CharSetter(Field f) {
            super(f);
        }

        @Override
        public void setString(Object object, String value) {
            if (value.length() > 1) {
                this.setChar(object, (char)Integer.parseInt(value));
            } else {
                this.setChar(object, value.charAt(0));
            }
        }
    }

    public static class DoubleSetter
    extends JsonFieldSetter {
        DoubleSetter(Field f) {
            super(f);
        }

        @Override
        public void setString(Object object, String value) {
            this.setDouble(object, Double.parseDouble(value));
        }
    }

    public static class FloatSetter
    extends JsonFieldSetter {
        FloatSetter(Field f) {
            super(f);
        }

        @Override
        public void setString(Object object, String value) {
            this.setFloat(object, Float.parseFloat(value));
        }
    }

    public static class LongSetter
    extends JsonFieldSetter {
        LongSetter(Field f) {
            super(f);
        }

        @Override
        public void setString(Object object, String value) {
            this.setLong(object, Long.parseLong(value));
        }
    }

    public static class IntSetter
    extends JsonFieldSetter {
        IntSetter(Field f) {
            super(f);
        }

        @Override
        public void setString(Object object, String value) {
            this.setInteger(object, Integer.parseInt(value));
        }
    }

    public static class ShortSetter
    extends JsonFieldSetter {
        ShortSetter(Field f) {
            super(f);
        }

        @Override
        public void setString(Object object, String value) {
            this.setShort(object, Short.parseShort(value));
        }
    }

    public static class ByteSetter
    extends JsonFieldSetter {
        ByteSetter(Field f) {
            super(f);
        }

        @Override
        public void setString(Object object, String value) {
            this.setByte(object, Byte.parseByte(value));
        }
    }
}

