/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.json;

import com.wizzardo.tools.json.Appender;
import com.wizzardo.tools.json.Binder;
import com.wizzardo.tools.json.JsonArray;
import com.wizzardo.tools.json.JsonObject;
import com.wizzardo.tools.json.JsonTools;
import com.wizzardo.tools.json.JsonUtils;
import com.wizzardo.tools.misc.DateIso8601;
import com.wizzardo.tools.misc.ExceptionDrivenStringBuilder;
import com.wizzardo.tools.misc.pool.Holder;
import java.util.Date;

public class JsonItem {
    Object ob;

    public JsonItem(Object ob) {
        this.ob = ob;
    }

    public boolean isNull() {
        return this.ob == null;
    }

    public String asString() {
        return String.valueOf(this.ob);
    }

    public Object get() {
        return this.ob;
    }

    public Long asLong() {
        return this.asLong(null);
    }

    public Long asLong(Long def) {
        if (this.ob == null) {
            return def;
        }
        if (this.ob instanceof Number) {
            return ((Number)this.ob).longValue();
        }
        try {
            String s = this.ob.toString();
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            Long l = s.startsWith("0x") ? Long.valueOf(Long.parseLong(s.substring(2), 16)) : Long.valueOf(Long.parseLong(s));
            this.ob = l;
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public Integer asInteger() {
        return this.asInteger(null);
    }

    public Integer asInteger(Integer def) {
        if (this.ob == null) {
            return def;
        }
        if (this.ob instanceof Number) {
            return ((Number)this.ob).intValue();
        }
        try {
            String s = this.ob.toString();
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            Integer i = s.startsWith("0x") ? Integer.valueOf((int)Long.parseLong(s.substring(2), 16)) : Integer.valueOf(Integer.parseInt(s));
            this.ob = i;
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public Character asChar() {
        return this.asChar(null);
    }

    public Character asChar(Character def) {
        Character ch;
        if (this.ob == null) {
            return def;
        }
        if (this.ob.getClass() == Character.class) {
            return (Character)this.ob;
        }
        if (this.ob instanceof Number) {
            return Character.valueOf((char)((Number)this.ob).intValue());
        }
        String s = this.ob.toString();
        if (s.length() > 1) {
            int i = this.asInteger(-1);
            if (i == -1) {
                return def;
            }
            ch = Character.valueOf((char)i);
        } else {
            ch = Character.valueOf(s.charAt(0));
        }
        this.ob = ch;
        return ch;
    }

    public Byte asByte() {
        return this.asByte(null);
    }

    public Byte asByte(Byte def) {
        if (this.ob == null) {
            return def;
        }
        if (this.ob instanceof Number) {
            return ((Number)this.ob).byteValue();
        }
        try {
            String s = this.ob.toString();
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            Byte i = s.startsWith("0x") ? Byte.valueOf((byte)Long.parseLong(s.substring(2), 16)) : Byte.valueOf(Byte.parseByte(s));
            this.ob = i;
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public Short asShort() {
        return this.asShort(null);
    }

    public Short asShort(Short def) {
        if (this.ob == null) {
            return def;
        }
        if (this.ob instanceof Number) {
            return ((Number)this.ob).shortValue();
        }
        try {
            String s = this.ob.toString();
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            Short i = s.startsWith("0x") ? Short.valueOf((short)Long.parseLong(s.substring(2), 16)) : Short.valueOf(Short.parseShort(s));
            this.ob = i;
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public Double asDouble() {
        return this.asDouble(null);
    }

    public Double asDouble(Double def) {
        if (this.ob == null) {
            return def;
        }
        if (this.ob instanceof Number) {
            return ((Number)this.ob).doubleValue();
        }
        try {
            String s = this.ob.toString();
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            Double d = Double.parseDouble(s);
            this.ob = d;
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public Float asFloat() {
        return this.asFloat(null);
    }

    public Float asFloat(Float def) {
        if (this.ob == null) {
            return def;
        }
        if (this.ob instanceof Number) {
            return Float.valueOf(((Number)this.ob).floatValue());
        }
        try {
            String s = this.ob.toString();
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            Float f = Float.valueOf(Float.parseFloat(s));
            this.ob = f;
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public Boolean asBoolean() {
        return this.asBoolean(null);
    }

    public Boolean asBoolean(Boolean def) {
        if (this.ob == null) {
            return def;
        }
        if (this.ob instanceof Boolean) {
            return (Boolean)this.ob;
        }
        if (this.ob instanceof String) {
            Boolean b = Boolean.parseBoolean(this.ob.toString());
            this.ob = b;
            return b;
        }
        return def;
    }

    public <T extends Enum<T>> Enum<T> asEnum(Class<T> cl) {
        return JsonUtils.asEnum(cl, this.asString());
    }

    public JsonObject asJsonObject() {
        return (JsonObject)this.ob;
    }

    public JsonArray asJsonArray() {
        return (JsonArray)this.ob;
    }

    public boolean isJsonArray() {
        return this.ob instanceof JsonArray;
    }

    public boolean isJsonObject() {
        return this.ob instanceof JsonObject;
    }

    public static <T> T getAs(Object value, Class<T> clazz) {
        if (clazz.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return new JsonItem(value).getAs(clazz);
    }

    public <T> T getAs(Class<T> clazz) {
        if (this.ob == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.ob.getClass())) {
            return (T)this.ob;
        }
        if (String.class == clazz) {
            return (T)this.asString();
        }
        if (Integer.class == clazz || Integer.TYPE == clazz) {
            return (T)this.asInteger();
        }
        if (Double.class == clazz || Double.TYPE == clazz) {
            return (T)this.asDouble();
        }
        if (Long.class == clazz || Long.TYPE == clazz) {
            return (T)this.asLong();
        }
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return (T)this.asBoolean();
        }
        if (Float.class == clazz || Float.TYPE == clazz) {
            return (T)this.asFloat();
        }
        if (Byte.class == clazz || Byte.TYPE == clazz) {
            return (T)this.asByte();
        }
        if (Short.class == clazz || Short.TYPE == clazz) {
            return (T)this.asShort();
        }
        if (Character.class == clazz || Character.TYPE == clazz) {
            return (T)this.asChar();
        }
        if (Date.class == clazz) {
            return (T)DateIso8601.parse((String)this.asString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Holder holder = JsonTools.builderPool.holder();
        try {
            ExceptionDrivenStringBuilder builder = (ExceptionDrivenStringBuilder)holder.get();
            Appender sb = Appender.create(builder);
            this.toJson(sb);
            String string = sb.toString();
            return string;
        }
        finally {
            holder.close();
        }
    }

    void toJson(Appender sb) {
        if (this.ob == null) {
            sb.append("null");
        } else if (this.ob instanceof JsonObject) {
            ((JsonObject)this.ob).toJson(sb);
        } else if (this.ob instanceof JsonArray) {
            ((JsonArray)this.ob).toJson(sb);
        } else if (this.ob.getClass() == String.class) {
            sb.append('\"');
            JsonTools.escape(this.ob.toString(), sb);
            sb.append('\"');
        } else {
            Binder.toJSON(this.ob, sb);
        }
    }

    protected void set(Object value) {
        this.ob = value;
    }
}

