/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.json;

import com.wizzardo.tools.json.Appender;
import com.wizzardo.tools.json.JsonArray;
import com.wizzardo.tools.json.JsonBinder;
import com.wizzardo.tools.json.JsonItem;
import com.wizzardo.tools.json.JsonTools;
import com.wizzardo.tools.json.JsonUtils;
import com.wizzardo.tools.misc.ExceptionDrivenStringBuilder;
import com.wizzardo.tools.misc.pool.Holder;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonObject
extends LinkedHashMap<String, JsonItem> {
    static int parse(char[] s, int from, int to, JsonBinder json) {
        int i;
        block6: for (i = ++from; i < to; ++i) {
            char current = s[i];
            if (current <= ' ') continue;
            if (current == '}') break;
            i = JsonUtils.parseKey(json, s, i, to);
            i = JsonUtils.skipSpaces(s, i, to);
            current = s[i];
            switch (current) {
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    i = JsonUtils.parseNumber(json, s, i, to);
                    break;
                }
                case '{': {
                    if (json == null) {
                        i = JsonObject.parse(s, i, to, null);
                        break;
                    }
                    JsonBinder ob = json.getObjectBinder();
                    i = JsonObject.parse(s, i, to, ob);
                    if (ob == null) break;
                    json.add(ob.getObject());
                    break;
                }
                case '[': {
                    if (json == null) {
                        i = JsonArray.parse(s, i, to, null);
                        break;
                    }
                    JsonBinder ob = json.getArrayBinder();
                    i = JsonArray.parse(s, i, to, ob);
                    if (ob == null) break;
                    json.add(ob.getObject());
                    break;
                }
                case '}': {
                    break block6;
                }
                default: {
                    i = JsonUtils.parseValue(json, s, i, to, '}');
                }
            }
            i = JsonUtils.skipSpaces(s, i, to);
            current = s[i];
            if (current == ',') continue;
            if (current == '}') break;
            throw new IllegalStateException("here must be ',' or '}' , but found: " + current);
        }
        return i + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Holder holder = JsonTools.builderPool.holder();
        try {
            ExceptionDrivenStringBuilder builder = (ExceptionDrivenStringBuilder)holder.get();
            Appender sb = Appender.create(builder);
            this.toJson(sb);
            String string = sb.toString();
            return string;
        }
        finally {
            holder.close();
        }
    }

    void toJson(Appender sb) {
        sb.append('{');
        boolean comma = false;
        for (Map.Entry entry : this.entrySet()) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append('\"');
            sb.append((String)entry.getKey());
            sb.append('\"');
            sb.append(':');
            if (entry.getValue() == null) {
                sb.append("null");
                continue;
            }
            ((JsonItem)entry.getValue()).toJson(sb);
        }
        sb.append('}');
    }

    public boolean isNull(String key) {
        return ((JsonItem)this.get(key)).isNull();
    }

    public boolean isJsonArray(String key) {
        return ((JsonItem)this.get(key)).isJsonArray();
    }

    public boolean isJsonObject(String key) {
        return ((JsonItem)this.get(key)).isJsonObject();
    }

    public String getAsString(String key) {
        return this.getAsString(key, null);
    }

    public String getAsString(String key, String def) {
        JsonItem item = (JsonItem)this.get(key);
        return item == null ? def : item.asString();
    }

    public Long getAsLong(String key) {
        return this.getAsLong(key, null);
    }

    public Long getAsLong(String key, Long def) {
        JsonItem item = (JsonItem)this.get(key);
        return item == null ? def : item.asLong(def);
    }

    public Integer getAsInteger(String key) {
        return this.getAsInteger(key, null);
    }

    public Integer getAsInteger(String key, Integer def) {
        JsonItem item = (JsonItem)this.get(key);
        return item == null ? def : item.asInteger(def);
    }

    public Double getAsDouble(String key) {
        return this.getAsDouble(key, null);
    }

    public Double getAsDouble(String key, Double def) {
        JsonItem item = (JsonItem)this.get(key);
        return item == null ? def : item.asDouble(def);
    }

    public Float getAsFloat(String key) {
        return this.getAsFloat(key, null);
    }

    public Float getAsFloat(String key, Float def) {
        JsonItem item = (JsonItem)this.get(key);
        return item == null ? def : item.asFloat(def);
    }

    public Boolean getAsBoolean(String key) {
        return this.getAsBoolean(key, null);
    }

    public Boolean getAsBoolean(String key, Boolean def) {
        JsonItem item = (JsonItem)this.get(key);
        return item == null ? def : item.asBoolean(def);
    }

    public JsonObject getAsJsonObject(String key) {
        JsonItem item = (JsonItem)this.get(key);
        return item == null ? null : item.asJsonObject();
    }

    public JsonArray getAsJsonArray(String key) {
        JsonItem item = (JsonItem)this.get(key);
        return item == null ? null : item.asJsonArray();
    }

    public JsonObject append(String key, Object ob) {
        if (ob instanceof JsonItem) {
            this.put(key, (JsonItem)ob);
        } else {
            this.put(key, new JsonItem(ob));
        }
        return this;
    }
}

