/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.json;

import com.wizzardo.tools.json.Appender;
import com.wizzardo.tools.json.Binder;
import com.wizzardo.tools.json.Generic;
import com.wizzardo.tools.json.JsonArray;
import com.wizzardo.tools.json.JsonBinder;
import com.wizzardo.tools.json.JsonItem;
import com.wizzardo.tools.json.JsonObject;
import com.wizzardo.tools.misc.Consumer;
import com.wizzardo.tools.misc.ExceptionDrivenStringBuilder;
import com.wizzardo.tools.misc.Supplier;
import com.wizzardo.tools.misc.pool.Holder;
import com.wizzardo.tools.misc.pool.Pool;
import com.wizzardo.tools.misc.pool.PoolBuilder;
import com.wizzardo.tools.reflection.StringReflection;
import java.io.OutputStream;

public class JsonTools {
    private static final char[] INT_VALUES;
    private static final char[] UNESCAPES;
    private static final char[] ESCAPES;
    static Pool<ExceptionDrivenStringBuilder> builderPool;

    public static JsonItem parse(String s) {
        return new JsonItem(JsonTools.parse(s, (Generic)null));
    }

    public static <T> T parse(String s, Class<T> clazz) {
        return JsonTools.parse(s, new Generic(clazz));
    }

    public static <T> T parse(String s, Class<T> clazz, Class ... generic) {
        return JsonTools.parse(s, new Generic<T>(clazz, generic));
    }

    public static <T> T parse(String s, Class<T> clazz, Generic ... generic) {
        return JsonTools.parse(s, new Generic<T>(clazz, generic));
    }

    public static <T> T parse(String s, Generic<T> generic) {
        s = s.trim();
        char[] data = StringReflection.chars((String)s);
        int offset = 0;
        if (data.length != s.length()) {
            offset = StringReflection.offset((String)s);
        }
        return JsonTools.parse(data, offset, s.length(), generic);
    }

    public static JsonItem parse(char[] s) {
        return new JsonItem(JsonTools.parse(s, 0, s.length, null));
    }

    public static <T> T parse(char[] s, Class<T> clazz, Class ... generic) {
        return JsonTools.parse(s, 0, s.length, new Generic<T>(clazz, generic));
    }

    public static <T> T parse(char[] s, Class<T> clazz, Generic ... generic) {
        return JsonTools.parse(s, 0, s.length, new Generic<T>(clazz, generic));
    }

    public static <T> T parse(char[] s, int from, int to, Generic<T> generic) {
        if (s[from] == '{') {
            JsonBinder binder = Binder.getObjectBinder(generic);
            JsonObject.parse(s, from, to, binder);
            return (T)binder.getObject();
        }
        if (s[from] == '[') {
            JsonBinder binder = Binder.getArrayBinder(generic);
            JsonArray.parse(s, from, to, binder);
            return (T)binder.getObject();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeToBytes(Object src) {
        Holder holder = builderPool.holder();
        try {
            ExceptionDrivenStringBuilder builder = (ExceptionDrivenStringBuilder)holder.get();
            Binder.toJSON(src, Appender.create(builder));
            byte[] byArray = builder.toUtf8Bytes();
            return byArray;
        }
        finally {
            holder.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serialize(Object src) {
        Holder holder = builderPool.holder();
        try {
            ExceptionDrivenStringBuilder builder = (ExceptionDrivenStringBuilder)holder.get();
            Appender sb = Appender.create(builder);
            Binder.toJSON(src, sb);
            String string = sb.toString();
            return string;
        }
        finally {
            holder.close();
        }
    }

    public static void serialize(Object src, OutputStream out) {
        Appender appender = Appender.create(out);
        Binder.toJSON(src, appender);
        appender.flush();
    }

    public static void serialize(Object src, StringBuilder out) {
        Binder.toJSON(src, Appender.create(out));
    }

    public static String unescape(char[] chars, int from, int to) {
        StringBuilder sb = new StringBuilder(to - from);
        for (int i = from; i < to; ++i) {
            char ch = chars[i];
            if (ch != '\\') continue;
            sb.append(chars, from, i - from);
            if (to <= ++i) {
                throw new IndexOutOfBoundsException("unexpected end");
            }
            ch = UNESCAPES[chars[i]];
            if (ch == '\u0000') {
                throw new IllegalStateException("unexpected escaped char: " + chars[i]);
            }
            if (ch == '\u0080') {
                if (to < i + 5) {
                    throw new IndexOutOfBoundsException("can't decode unicode character");
                }
                sb.append(JsonTools.decodeUtf(chars, i += 4));
            } else {
                sb.append(ch);
            }
            from = i + 1;
        }
        if (from < to) {
            sb.append(chars, from, to - from);
        }
        return sb.toString();
    }

    public static String escape(String s) {
        Appender sb = Appender.create();
        JsonTools.escape(s, sb);
        return sb.toString();
    }

    static void escape(String s, Appender sb) {
        int to;
        int offset;
        char[] chars = StringReflection.chars((String)s);
        int from = offset = chars.length == (to = s.length()) ? 0 : StringReflection.offset((String)s);
        int l = (to += from) - 1;
        for (int i = from; i < l; i += 2) {
            from = JsonTools.check(from, i, chars, sb);
            from = JsonTools.check(from, i + 1, chars, sb);
        }
        if ((l + offset) % 2 == 0) {
            from = JsonTools.check(from, l, chars, sb);
        }
        if (from < to) {
            JsonTools.append(chars, from, to, sb);
        }
    }

    private static int check(int from, int i, char[] chars, Appender sb) {
        char ch = chars[i];
        if (ch < '\u007f') {
            if (ESCAPES[ch] != '\u0000') {
                from = JsonTools.append(chars, from, i, sb);
                JsonTools.escapeChar(ESCAPES[ch], ch, sb);
            }
        } else if (ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
            from = JsonTools.append(chars, from, i, sb);
            JsonTools.appendUnicodeChar(ch, sb);
        }
        return from;
    }

    static void escape(char ch, Appender sb) {
        if (ch < '\u007f') {
            if (ESCAPES[ch] != '\u0000') {
                JsonTools.escapeChar(ESCAPES[ch], ch, sb);
            } else {
                sb.append(ch);
            }
        } else if (ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
            JsonTools.appendUnicodeChar(ch, sb);
        } else {
            sb.append(ch);
        }
    }

    private static void appendUnicodeChar(char ch, Appender sb) {
        String ss = Integer.toHexString(ch);
        sb.append("\\u");
        for (int k = 0; k < 4 - ss.length(); ++k) {
            sb.append('0');
        }
        sb.append(ss.toUpperCase());
    }

    private static int append(char[] s, int from, int to, Appender sb) {
        sb.append(s, from, to);
        return to + 1;
    }

    private static void escapeChar(char escaped, char src, Appender sb) {
        if (escaped == '\u0080') {
            JsonTools.appendUnicodeChar(src, sb);
        } else {
            sb.append('\\');
            sb.append(escaped);
        }
    }

    static char decodeUtf(char[] chars, int last) {
        char value = '\u0000';
        value = (char)(value + JsonTools.getHexValue(chars[last]));
        value = (char)(value + JsonTools.getHexValue(chars[last - 1]) * 16);
        value = (char)(value + JsonTools.getHexValue(chars[last - 2]) * 256);
        value = (char)(value + JsonTools.getHexValue(chars[last - 3]) * 4096);
        return value;
    }

    static char getHexValue(char c) {
        if (c >= '\u0080') {
            throw new IllegalStateException("unexpected char for hex value: " + c);
        }
        if ((c = INT_VALUES[c]) == '\u0080') {
            throw new IllegalStateException("unexpected char for hex value");
        }
        return c;
    }

    static {
        int i;
        INT_VALUES = new char[128];
        UNESCAPES = new char[128];
        ESCAPES = new char[128];
        for (i = 0; i < 32; ++i) {
            JsonTools.ESCAPES[i] = 128;
        }
        JsonTools.ESCAPES[34] = 34;
        JsonTools.ESCAPES[92] = 92;
        JsonTools.ESCAPES[10] = 110;
        JsonTools.ESCAPES[13] = 114;
        JsonTools.ESCAPES[8] = 98;
        JsonTools.ESCAPES[9] = 116;
        JsonTools.ESCAPES[12] = 102;
        for (i = 0; i < INT_VALUES.length; ++i) {
            JsonTools.INT_VALUES[i] = 128;
        }
        JsonTools.INT_VALUES[48] = '\u0000';
        JsonTools.INT_VALUES[49] = '\u0001';
        JsonTools.INT_VALUES[50] = 2;
        JsonTools.INT_VALUES[51] = 3;
        JsonTools.INT_VALUES[52] = 4;
        JsonTools.INT_VALUES[53] = 5;
        JsonTools.INT_VALUES[54] = 6;
        JsonTools.INT_VALUES[55] = 7;
        JsonTools.INT_VALUES[56] = 8;
        JsonTools.INT_VALUES[57] = 9;
        JsonTools.INT_VALUES[97] = 10;
        JsonTools.INT_VALUES[98] = 11;
        JsonTools.INT_VALUES[99] = 12;
        JsonTools.INT_VALUES[100] = 13;
        JsonTools.INT_VALUES[101] = 14;
        JsonTools.INT_VALUES[102] = 15;
        JsonTools.INT_VALUES[65] = 10;
        JsonTools.INT_VALUES[66] = 11;
        JsonTools.INT_VALUES[67] = 12;
        JsonTools.INT_VALUES[68] = 13;
        JsonTools.INT_VALUES[69] = 14;
        JsonTools.INT_VALUES[70] = 15;
        JsonTools.UNESCAPES[34] = 34;
        JsonTools.UNESCAPES[92] = 92;
        JsonTools.UNESCAPES[98] = 8;
        JsonTools.UNESCAPES[102] = 12;
        JsonTools.UNESCAPES[110] = 10;
        JsonTools.UNESCAPES[114] = 13;
        JsonTools.UNESCAPES[116] = 9;
        JsonTools.UNESCAPES[47] = 47;
        JsonTools.UNESCAPES[117] = 128;
        builderPool = new PoolBuilder().supplier((Supplier)new Supplier<ExceptionDrivenStringBuilder>(){

            public ExceptionDrivenStringBuilder supply() {
                return new ExceptionDrivenStringBuilder();
            }
        }).resetter((Consumer)new Consumer<ExceptionDrivenStringBuilder>(){

            public void consume(ExceptionDrivenStringBuilder sb) {
                sb.setLength(0);
            }
        }).build();
    }
}

