/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.json;

import com.wizzardo.tools.json.FieldInfo;
import com.wizzardo.tools.json.JsonBinder;
import com.wizzardo.tools.json.JsonFieldSetter;
import com.wizzardo.tools.json.JsonItem;
import com.wizzardo.tools.json.JsonTools;
import com.wizzardo.tools.misc.CharTree;
import com.wizzardo.tools.reflection.FieldReflection;

class JsonUtils {
    private static long[] fractionalShift = new long[19];

    JsonUtils() {
    }

    static int trimRight(char[] s, int from, int to) {
        while (from < to && s[to - 1] <= ' ') {
            --to;
        }
        return to;
    }

    static boolean isNull(char[] s, int from, int length) {
        return length == 4 && s[from] == 'n' && s[from + 1] == 'u' && s[from + 2] == 'l' && s[from + 3] == 'l';
    }

    static boolean isTrue(char[] s, int from, int length) {
        return length == 4 && s[from] == 't' && s[from + 1] == 'r' && s[from + 2] == 'u' && s[from + 3] == 'e';
    }

    static boolean isFalse(char[] s, int from, int length) {
        return length == 5 && s[from] == 'f' && s[from + 1] == 'a' && s[from + 2] == 'l' && s[from + 3] == 's' && s[from + 4] == 'e';
    }

    static int skipSpaces(char[] s, int from, int to) {
        while (from < to && s[from] <= ' ') {
            ++from;
        }
        return from;
    }

    static int parseNumber(JsonBinder binder, char[] s, int from, int to) {
        JsonFieldSetter setter;
        boolean minus;
        int i = from;
        boolean bl = minus = s[from] == '-';
        if (minus) {
            ++i;
        }
        if (i == to) {
            throw new IllegalStateException("no number found, only '-'");
        }
        boolean floatValue = false;
        long l = 0L;
        char ch = '\u0000';
        while (i < to) {
            ch = s[i];
            if (ch < '0' || ch > '9') {
                if (ch != '.') break;
                floatValue = true;
                break;
            }
            l = l * 10L + (long)(ch - 48);
            ++i;
        }
        if (binder == null) {
            return i;
        }
        double d = 0.0;
        if (floatValue) {
            long number = l;
            int fractionalPartStart = ++i;
            while (i < to && (ch = s[i]) >= '0' && ch <= '9') {
                number = number * 10L + (long)(ch - 48);
                ++i;
            }
            d = minus ? -((double)number) / (double)fractionalShift[i - fractionalPartStart] : (double)number / (double)fractionalShift[i - fractionalPartStart];
        }
        if (minus) {
            l = -l;
        }
        if (ch == 'e' || ch == 'E') {
            if (!floatValue) {
                d = l;
                floatValue = true;
            }
            int degree = 0;
            boolean bl2 = minus = s[++i] == '-';
            if (minus) {
                ++i;
            }
            while (i < to && (ch = s[i]) >= '0' && ch <= '9') {
                degree = degree * 10 + (ch - 48);
                ++i;
            }
            double d2 = d = minus ? d / Math.pow(10.0, degree) : d * Math.pow(10.0, degree);
        }
        if ((setter = binder.getFieldSetter()) != null) {
            JsonUtils.setNumber(setter, binder.getObject(), l, d, floatValue);
            return i;
        }
        if (!floatValue) {
            binder.add(l);
        } else {
            binder.add(d);
        }
        return i;
    }

    private static void setNumber(FieldReflection setter, Object object, long l, double d, boolean floatValue) {
        switch (setter.getType()) {
            case INTEGER: {
                setter.setInteger(object, (int)l);
                break;
            }
            case LONG: {
                setter.setLong(object, l);
                break;
            }
            case BYTE: {
                setter.setByte(object, (byte)l);
                break;
            }
            case SHORT: {
                setter.setShort(object, (short)l);
                break;
            }
            case CHAR: {
                setter.setChar(object, (char)l);
                break;
            }
            case FLOAT: {
                if (floatValue) {
                    setter.setFloat(object, (float)d);
                    break;
                }
                setter.setFloat(object, (float)l);
                break;
            }
            case DOUBLE: {
                if (floatValue) {
                    setter.setDouble(object, d);
                    break;
                }
                setter.setDouble(object, (double)l);
                break;
            }
            case BOOLEAN: {
                setter.setBoolean(object, l != 0L);
            }
        }
    }

    static int parseValue(JsonBinder binder, char[] s, int from, int to, char end) {
        String value;
        int i;
        char ch = s[from];
        char quote = '\u0000';
        if (ch == '\"' || ch == '\'') {
            quote = ch;
            ++from;
        }
        boolean escape = false;
        boolean needDecoding = false;
        if (quote == '\u0000') {
            for (i = from; i < to && (ch = s[i]) > ' ' && ch != ',' && ch != end; ++i) {
                if (ch != '\\') continue;
                needDecoding = true;
            }
        } else {
            while (i < to) {
                if (escape) {
                    escape = false;
                } else {
                    ch = s[i];
                    if (ch == quote) break;
                    if (ch == '\\') {
                        needDecoding = true;
                        escape = true;
                    }
                }
                ++i;
            }
        }
        int k = i++;
        if (quote == '\u0000') {
            k = JsonUtils.trimRight(s, from, k);
        }
        if (binder == null) {
            return i;
        }
        JsonFieldSetter setter = binder.getFieldSetter();
        int l = k - from;
        if (!needDecoding) {
            if (JsonUtils.isNull(s, from, l)) {
                JsonUtils.setNull(setter, binder);
                return i;
            }
            if (JsonUtils.isTrue(s, from, l)) {
                JsonUtils.setBoolean(setter, binder, true);
                return i;
            }
            if (JsonUtils.isFalse(s, from, l)) {
                JsonUtils.setBoolean(setter, binder, false);
                return i;
            }
            value = new String(s, from, l);
        } else {
            value = JsonTools.unescape(s, from, k);
        }
        JsonUtils.setString(setter, binder, value);
        return i;
    }

    private static void setString(JsonFieldSetter setter, JsonBinder binder, String value) {
        if (setter != null) {
            try {
                setter.setString(binder.getObject(), value);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not set '" + value + "' (" + value.getClass() + ") to " + (Object)((Object)setter));
            }
        } else {
            binder.add(value);
        }
    }

    private static void setBoolean(JsonFieldSetter setter, JsonBinder binder, boolean value) {
        if (setter != null) {
            setter.setBoolean(binder.getObject(), value);
        } else {
            binder.add(value);
        }
    }

    private static void setNull(JsonFieldSetter setter, JsonBinder binder) {
        if (setter != null) {
            setter.setObject(binder.getObject(), null);
        } else {
            binder.add(new JsonItem(null));
        }
    }

    static int parseKey(JsonBinder binder, char[] s, int from, int to) {
        int rightBorder;
        int i = from;
        char ch = s[i];
        char quote = '\u0000';
        if (ch == '\'' || ch == '\"') {
            quote = ch;
            ++i;
            ++from;
        }
        CharTree.CharTreeNode node = FieldInfo.charTree.getRoot();
        boolean escape = false;
        boolean needDecoding = false;
        if (quote == '\u0000') {
            while (i < to && (ch = s[i]) > ' ' && ch != ':' && ch != '}') {
                if (ch == '\\') {
                    needDecoding = true;
                }
                ++i;
            }
            rightBorder = JsonUtils.trimRight(s, from, i);
        } else {
            if (node != null) {
                while (i < to) {
                    if (escape) {
                        escape = false;
                    } else {
                        ch = s[i];
                        if (ch == quote) break;
                        if (ch == '\\') {
                            needDecoding = true;
                            escape = true;
                        }
                        if ((node = node.next(ch)) == null) break;
                    }
                    ++i;
                }
            }
            if (s[i] != quote) {
                while (i < to) {
                    if (escape) {
                        escape = false;
                    } else {
                        ch = s[i];
                        if (ch == quote) break;
                        if (ch == '\\') {
                            needDecoding = true;
                            escape = true;
                        }
                    }
                    ++i;
                }
            }
            rightBorder = i++;
        }
        i = JsonUtils.skipSpaces(s, i, to);
        if (rightBorder == from) {
            throw new IllegalStateException("key not found");
        }
        if (s[i] != ':') {
            throw new IllegalStateException("here must be key-value separator ':', but found: " + s[i]);
        }
        if (binder == null) {
            return i + 1;
        }
        String value = null;
        if (!needDecoding) {
            if (node != null) {
                value = (String)node.getValue();
            }
            if (value == null) {
                value = new String(s, from, rightBorder - from);
            }
        } else {
            value = JsonTools.unescape(s, from, rightBorder);
        }
        binder.setTemporaryKey(value);
        return i + 1;
    }

    public static <T extends Enum<T>> Enum<T> asEnum(Class<T> cl, String name) {
        return Enum.valueOf(cl, name);
    }

    static {
        JsonUtils.fractionalShift[0] = 1L;
        for (int i = 1; i < fractionalShift.length; ++i) {
            JsonUtils.fractionalShift[i] = fractionalShift[i - 1] * 10L;
        }
    }
}

