/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.misc;

import java.util.ArrayList;
import java.util.List;

public class CharTree<V> {
    private CharTreeNode<V> root;

    public CharTreeNode<V> getRoot() {
        return this.root;
    }

    public CharTree<V> append(String s, V value) {
        return this.append(s.toCharArray(), value);
    }

    public CharTree<V> appendReverse(String s, V value) {
        return this.append(CharTree.reverse(s.toCharArray()), value);
    }

    public CharTree<V> append(char[] chars, V value) {
        if (this.root == null) {
            this.root = new SingleCharTreeNode();
        }
        char b = chars[0];
        this.root = this.root.append(b);
        CharTreeNode<V> temp = this.root.next(b);
        CharTreeNode<V> prev = this.root;
        char p = b;
        for (int i = 1; i < chars.length; ++i) {
            b = chars[i];
            CharTreeNode<V> next = temp.append(b);
            prev.set(p, next);
            prev = next;
            temp = next.next(b);
            p = b;
        }
        temp.value = value;
        return this;
    }

    public boolean contains(String name) {
        return this.get(name) != null;
    }

    public boolean contains(char[] chars) {
        return this.contains(chars, 0, chars.length);
    }

    public boolean contains(char[] chars, int offset, int length) {
        return this.get(chars, offset, length) != null;
    }

    public V get(char[] chars) {
        return this.get(chars, 0, chars.length);
    }

    public V get(char[] chars, int offset, int length) {
        CharTreeNode<V> node = this.root;
        for (int i = offset; i < offset + length && node != null; node = node.next(chars[i]), ++i) {
        }
        return node == null ? null : (V)node.value;
    }

    public V get(String s) {
        CharTreeNode<V> node = this.root;
        int length = s.length();
        for (int i = 0; i < length && node != null; node = node.next(s.charAt(i)), ++i) {
        }
        return node == null ? null : (V)node.value;
    }

    public V findStarts(char[] chars) {
        return this.findStarts(chars, 0, chars.length);
    }

    public V findStarts(char[] chars, int offset, int length) {
        CharTreeNode<V> node = this.root;
        for (int i = offset; i < offset + length && node != null && node.value == null; node = node.next(chars[i]), ++i) {
        }
        return node == null ? null : (V)node.value;
    }

    public V findStarts(String s) {
        CharTreeNode<V> node = this.root;
        int length = s.length();
        for (int i = 0; i < length && node != null && node.value == null; node = node.next(s.charAt(i)), ++i) {
        }
        return node == null ? null : (V)node.value;
    }

    public List<V> findAllStarts(char[] chars) {
        return this.findAllStarts(chars, 0, chars.length);
    }

    public List<V> findAllStarts(char[] chars, int offset, int length) {
        CharTreeNode<V> node = this.root;
        ArrayList list = new ArrayList();
        for (int i = offset; i < offset + length && node != null; node = node.next(chars[i]), ++i) {
            this.addIfNotNull(list, node);
        }
        return list;
    }

    public List<V> findAllStarts(String s) {
        CharTreeNode<V> node = this.root;
        ArrayList list = new ArrayList();
        int length = s.length();
        for (int i = 0; i < length && node != null; node = node.next(s.charAt(i)), ++i) {
            this.addIfNotNull(list, node);
        }
        return list;
    }

    public V findEnds(char[] chars) {
        return this.findEnds(chars, 0, chars.length);
    }

    public V findEnds(char[] chars, int offset, int length) {
        CharTreeNode<V> node = this.root;
        int l = chars.length - 1;
        for (int i = offset; i < offset + length && node != null && node.value == null; node = node.next(chars[l - i]), ++i) {
        }
        return node == null ? null : (V)node.value;
    }

    public V findEnds(String s) {
        CharTreeNode<V> node = this.root;
        int length = s.length();
        for (int i = 0; i < length && node != null && node.value == null; node = node.next(s.charAt(length - i - 1)), ++i) {
        }
        return node == null ? null : (V)node.value;
    }

    public List<V> findAllEnds(char[] chars) {
        return this.findAllEnds(chars, 0, chars.length);
    }

    public List<V> findAllEnds(char[] chars, int offset, int length) {
        CharTreeNode<V> node = this.root;
        int l = chars.length - 1;
        ArrayList list = new ArrayList();
        for (int i = offset; i < offset + length && node != null; node = node.next(chars[l - i]), ++i) {
            this.addIfNotNull(list, node);
        }
        return list;
    }

    public List<V> findAllEnds(String s) {
        CharTreeNode<V> node = this.root;
        int length = s.length();
        ArrayList list = new ArrayList();
        for (int i = 0; i < length && node != null; node = node.next(s.charAt(length - i - 1)), ++i) {
            this.addIfNotNull(list, node);
        }
        return list;
    }

    private void addIfNotNull(List<V> list, CharTreeNode<V> node) {
        if (node != null && node.value != null) {
            list.add(node.value);
        }
    }

    public static char[] reverse(char[] chars) {
        int i = 0;
        for (int j = chars.length - 1; i < j; ++i, --j) {
            char c = chars[i];
            chars[i] = chars[j];
            chars[j] = c;
        }
        return chars;
    }

    static class SingleCharTreeNode<V>
    extends CharTreeNode<V> {
        private char b;
        private CharTreeNode<V> next;

        SingleCharTreeNode() {
        }

        @Override
        public CharTreeNode<V> next(char b) {
            if (b == this.b) {
                return this.next;
            }
            return null;
        }

        @Override
        public CharTreeNode<V> append(char b) {
            if (this.next != null && this.b != b) {
                ArrayCharTreeNode<V> node = new ArrayCharTreeNode<V>(Math.max(this.b, b));
                node.set(this.b, this.next);
                node.append(b);
                return node;
            }
            if (this.b == b) {
                return this;
            }
            this.b = b;
            this.next = new SingleCharTreeNode<V>();
            return this;
        }

        @Override
        public CharTreeNode<V> set(char b, CharTreeNode<V> n) {
            if (this.next != null && this.b != b) {
                ArrayCharTreeNode<V> node = new ArrayCharTreeNode<V>(Math.max(this.b, b));
                node.set(this.b, this.next);
                node.set(b, n);
                return node;
            }
            if (this.b == b) {
                this.next = n;
                return this;
            }
            this.b = b;
            this.next = n;
            return this;
        }

        public String toString() {
            return "single " + this.b;
        }
    }

    public static class ArrayCharTreeNode<V>
    extends CharTreeNode<V> {
        private CharTreeNode<V>[] nodes;

        public ArrayCharTreeNode(int size) {
            this.increase(size);
        }

        @Override
        public CharTreeNode<V> next(char b) {
            if (b >= this.nodes.length) {
                return null;
            }
            return this.nodes[b];
        }

        @Override
        public CharTreeNode<V> append(char b) {
            this.increase(b + '\u0001');
            if (this.nodes[b] == null) {
                this.nodes[b] = new SingleCharTreeNode();
            }
            return this;
        }

        @Override
        public CharTreeNode<V> set(char b, CharTreeNode<V> node) {
            this.increase(b + '\u0001');
            this.nodes[b] = node;
            return this;
        }

        private void increase(int size) {
            if (this.nodes == null) {
                this.nodes = new CharTreeNode[size];
            } else if (this.nodes.length < size) {
                CharTreeNode[] temp = new CharTreeNode[size];
                System.arraycopy(this.nodes, 0, temp, 0, this.nodes.length);
                this.nodes = temp;
            }
        }
    }

    public static abstract class CharTreeNode<V> {
        protected V value;

        public abstract CharTreeNode<V> next(char var1);

        public abstract CharTreeNode<V> append(char var1);

        public abstract CharTreeNode<V> set(char var1, CharTreeNode<V> var2);

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

