/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.misc;

import com.wizzardo.tools.reflection.StringReflection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateIso8601 {
    private static final TimeZone Z = TimeZone.getTimeZone("GMT");
    private static final TimeZone LOCAL = TimeZone.getDefault();
    private static final int HOUR = 3600000;
    private static final int MINUTE = 60000;

    public static Date parse(String s) {
        boolean plus;
        char[] chars;
        Calendar calendar = GregorianCalendar.getInstance();
        int length = s.length();
        int i = length == (chars = StringReflection.chars((String)s)).length ? 0 : StringReflection.offset((String)s);
        calendar.set(1, DateIso8601.getInt4(chars, i));
        i = 4;
        char c = chars[i];
        if (c == '-') {
            c = chars[++i];
        }
        calendar.set(2, DateIso8601.getInt2(chars, i, c) - 1);
        c = chars[i += 2];
        if (c == '-') {
            c = chars[++i];
        }
        calendar.set(5, DateIso8601.getInt2(chars, i, c));
        if ((i += 2) >= length) {
            calendar.setTimeZone(Z);
            DateIso8601.clearTime(calendar);
            return calendar.getTime();
        }
        DateIso8601.checkOr(chars[i], 'T', ' ');
        calendar.set(11, DateIso8601.getInt2(chars, i + 1));
        if ((i += 3) >= length) {
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.setTimeZone(LOCAL);
            return calendar.getTime();
        }
        c = chars[i];
        if (c == ':') {
            c = chars[++i];
        }
        if (DateIso8601.isInt(c)) {
            calendar.set(12, DateIso8601.getInt2(chars, i, c));
            if ((i += 2) >= length) {
                calendar.set(13, 0);
                calendar.set(14, 0);
                calendar.setTimeZone(LOCAL);
                return calendar.getTime();
            }
            c = chars[i];
            if (c == ':') {
                c = chars[++i];
            }
            if (DateIso8601.isInt(c)) {
                calendar.set(13, DateIso8601.getInt2(chars, i, c));
                if ((i += 2) >= length) {
                    calendar.set(14, 0);
                    calendar.setTimeZone(LOCAL);
                    return calendar.getTime();
                }
                c = chars[i];
                if (c == '.') {
                    c = chars[++i];
                }
                if (DateIso8601.isInt(c)) {
                    calendar.set(14, DateIso8601.getInt3(chars, i, c));
                    i += 3;
                } else {
                    calendar.set(14, 0);
                }
            } else {
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
        } else {
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        if (i == length) {
            calendar.setTimeZone(LOCAL);
            return calendar.getTime();
        }
        if (chars[i] == 'Z') {
            calendar.setTimeZone(Z);
            return calendar.getTime();
        }
        c = chars[i];
        boolean bl = plus = c == '+';
        if (!plus) {
            DateIso8601.check(c, '-');
        }
        int hours = DateIso8601.getInt2(chars, i + 1);
        if ((i += 3) >= length) {
            calendar.setTimeZone(new SimpleTimeZone(hours * 3600000 * (plus ? 1 : -1)));
            return calendar.getTime();
        }
        c = chars[i];
        if (c == ':') {
            c = chars[++i];
        }
        int minutes = DateIso8601.getInt2(chars, i, c);
        calendar.setTimeZone(new SimpleTimeZone((hours * 3600000 + minutes * 60000) * (plus ? 1 : -1)));
        return calendar.getTime();
    }

    private static int getInt(char c) {
        if (!DateIso8601.isInt(c)) {
            throw new IllegalArgumentException("char should be an int, but was: " + c);
        }
        return c - 48;
    }

    private static boolean isInt(char c) {
        return c >= '0' && c <= '9';
    }

    private static void check(char c, char check) {
        if (c != check) {
            throw new IllegalArgumentException("char should be an '" + check + "', but was: " + c);
        }
    }

    private static void checkOr(char c, char check, char check2) {
        if (c != check && c != check2) {
            throw new IllegalArgumentException("char should be an '" + check + "' or '" + check2 + "', but was: " + c);
        }
    }

    private static int getInt2(char[] chars, int offset) {
        int i = DateIso8601.getInt(chars[offset]);
        return i * 10 + DateIso8601.getInt(chars[offset + 1]);
    }

    private static int getInt2(char[] chars, int offset, char first) {
        int i = DateIso8601.getInt(first);
        return i * 10 + DateIso8601.getInt(chars[offset + 1]);
    }

    private static int getInt3(char[] chars, int offset, char first) {
        int i = DateIso8601.getInt(first);
        i = i * 10 + DateIso8601.getInt(chars[offset + 1]);
        return i * 10 + DateIso8601.getInt(chars[offset + 2]);
    }

    private static int getInt3(char[] chars, int offset) {
        int i = DateIso8601.getInt(chars[offset]);
        i = i * 10 + DateIso8601.getInt(chars[offset + 1]);
        return i * 10 + DateIso8601.getInt(chars[offset + 2]);
    }

    private static int getInt4(char[] chars, int offset) {
        int i = DateIso8601.getInt(chars[offset]);
        i = i * 10 + DateIso8601.getInt(chars[offset + 1]);
        i = i * 10 + DateIso8601.getInt(chars[offset + 2]);
        return i * 10 + DateIso8601.getInt(chars[offset + 3]);
    }

    private static void clearTime(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.setTimeZone(Z);
    }

    public static String format(Date date) {
        return DateIso8601.format(date, Z);
    }

    public static String format(Date date, TimeZone timeZone) {
        return StringReflection.createString((char[])DateIso8601.formatToChars(date, timeZone));
    }

    public static char[] formatToChars(Date date) {
        return DateIso8601.formatToChars(date, Z);
    }

    public static char[] formatToChars(Date date, TimeZone timeZone) {
        Calendar calendar = GregorianCalendar.getInstance(timeZone);
        calendar.setTime(date);
        int offset = calendar.get(16) + calendar.get(15);
        char[] chars = offset == 0 ? new char[24] : new char[28];
        int i = 0;
        int t = calendar.get(1);
        DateIso8601.append4(chars, t, i);
        i += 4;
        chars[i++] = 45;
        t = calendar.get(2) + 1;
        DateIso8601.append2(chars, t, i);
        i += 2;
        chars[i++] = 45;
        t = calendar.get(5);
        DateIso8601.append2(chars, t, i);
        i += 2;
        chars[i++] = 84;
        t = calendar.get(11);
        DateIso8601.append2(chars, t, i);
        i += 2;
        chars[i++] = 58;
        t = calendar.get(12);
        DateIso8601.append2(chars, t, i);
        i += 2;
        chars[i++] = 58;
        t = calendar.get(13);
        DateIso8601.append2(chars, t, i);
        i += 2;
        chars[i++] = 46;
        t = calendar.get(14);
        DateIso8601.append3(chars, t, i);
        i += 3;
        if (offset == 0) {
            chars[i] = 90;
        } else {
            chars[i] = offset < 0 ? 45 : 43;
            int h = offset / 3600000;
            int m = (offset - h * 3600000) / 60000;
            DateIso8601.append2(chars, h, i + 1);
            DateIso8601.append2(chars, m, i + 3);
        }
        return chars;
    }

    private static void append4(char[] chars, int value, int offset) {
        chars[offset + 3] = (char)(48 + value % 10);
        if ((value /= 10) > 0) {
            chars[offset + 2] = (char)(48 + value % 10);
        } else {
            chars[offset + 2] = 48;
            chars[offset + 1] = 48;
            chars[offset] = 48;
        }
        if ((value /= 10) > 0) {
            chars[offset + 1] = (char)(48 + value % 10);
        } else {
            chars[offset + 1] = 48;
            chars[offset] = 48;
        }
        chars[offset] = (value /= 10) > 0 ? (int)(48 + value % 10) : 48;
    }

    private static void append3(char[] chars, int value, int offset) {
        chars[offset + 2] = (char)(48 + value % 10);
        if ((value /= 10) > 0) {
            chars[offset + 1] = (char)(48 + value % 10);
        } else {
            chars[offset + 1] = 48;
            chars[offset] = 48;
        }
        chars[offset] = (value /= 10) > 0 ? (int)(48 + value % 10) : 48;
    }

    private static void append2(char[] chars, int value, int offset) {
        chars[offset + 1] = (char)(48 + value % 10);
        chars[offset] = (value /= 10) > 0 ? (int)(48 + value % 10) : 48;
    }

    private static class SimpleTimeZone
    extends TimeZone {
        private int rawOffset;

        private SimpleTimeZone(int rawOffset) {
            this.rawOffset = rawOffset;
        }

        @Override
        public int getOffset(int era, int year, int month, int day, int dayOfWeek, int milliseconds) {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        @Override
        public void setRawOffset(int offsetMillis) {
            this.rawOffset = offsetMillis;
        }

        @Override
        public int getRawOffset() {
            return this.rawOffset;
        }

        @Override
        public boolean useDaylightTime() {
            return false;
        }

        @Override
        public boolean inDaylightTime(Date date) {
            return false;
        }
    }
}

