/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.misc;

import com.wizzardo.tools.misc.Consumer;
import com.wizzardo.tools.misc.NumberToChars;
import com.wizzardo.tools.misc.Supplier;
import com.wizzardo.tools.misc.UTF8;

public class ExceptionDrivenStringBuilder
implements Appendable {
    private static final char[] CHARS_TRUE = new char[]{'t', 'r', 'u', 'e'};
    private static final char[] CHARS_FALSE = new char[]{'f', 'a', 'l', 's', 'e'};
    private static final char[] CHARS_NULL = new char[]{'n', 'u', 'l', 'l'};
    protected int limit = 16;
    protected char[] buffer = new char[this.limit];
    protected int length = 0;
    protected UTF8 utf8Buffer;

    private void ensureCapacity(int length) {
        if (length >= this.limit) {
            char[] temp = new char[Math.max((int)((double)this.limit * 1.5), length)];
            System.arraycopy(this.buffer, 0, temp, 0, this.length > this.buffer.length ? this.buffer.length : this.length);
            this.buffer = temp;
            this.limit = length;
        }
    }

    @Override
    public ExceptionDrivenStringBuilder append(CharSequence csq) {
        return this.append(csq, 0, csq == null ? 4 : csq.length());
    }

    @Override
    public ExceptionDrivenStringBuilder append(CharSequence csq, int start, int end) {
        if (csq == null) {
            return this.append(CHARS_NULL, 0, 4);
        }
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public ExceptionDrivenStringBuilder append(char ch) {
        try {
            this.buffer[this.length++] = ch;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.ensureCapacity(this.length);
            this.buffer[this.length - 1] = ch;
        }
        catch (IndexOutOfBoundsException ex) {
            this.buffer[this.length - 1] = ch;
            return this.append(ch);
        }
        return this;
    }

    public ExceptionDrivenStringBuilder append(String s) {
        return this.append(s, 0, s == null ? 4 : s.length());
    }

    public ExceptionDrivenStringBuilder append(String s, int from, int to) {
        if (s == null) {
            return this.append(CHARS_NULL, 0, 4);
        }
        int l = to - from;
        try {
            s.getChars(from, to, this.buffer, this.length);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.ensureCapacity(this.length + l);
            return this.append(s, from, to);
        }
        catch (IndexOutOfBoundsException ex) {
            this.ensureCapacity(this.length + l);
            return this.append(s, from, to);
        }
        this.length += l;
        return this;
    }

    public ExceptionDrivenStringBuilder append(char[] chars) {
        return this.append(chars, 0, chars.length);
    }

    public ExceptionDrivenStringBuilder append(char[] chars, int from, int length) {
        try {
            System.arraycopy(chars, from, this.buffer, this.length, length);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.ensureCapacity(length + this.length);
            return this.append(chars, from, length);
        }
        catch (IndexOutOfBoundsException ex) {
            this.ensureCapacity(length + this.length);
            return this.append(chars, from, length);
        }
        this.length += length;
        return this;
    }

    public void setLength(int length) {
        this.ensureCapacity(length);
        this.length = length;
    }

    public ExceptionDrivenStringBuilder append(Object ob) {
        return this.append(String.valueOf(ob));
    }

    public ExceptionDrivenStringBuilder append(int i) {
        try {
            this.length = NumberToChars.toChars(i, this.buffer, this.length);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.ensureCapacity(this.length + 11);
            return this.append(i);
        }
        catch (IndexOutOfBoundsException ex) {
            this.ensureCapacity(this.length + 11);
            return this.append(i);
        }
        return this;
    }

    public ExceptionDrivenStringBuilder append(long i) {
        try {
            this.length = NumberToChars.toChars(i, this.buffer, this.length);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.ensureCapacity(this.length + 20);
            return this.append(i);
        }
        catch (IndexOutOfBoundsException ex) {
            this.ensureCapacity(this.length + 20);
            return this.append(i);
        }
        return this;
    }

    public ExceptionDrivenStringBuilder append(boolean b) {
        if (b) {
            this.append(CHARS_TRUE);
        } else {
            this.append(CHARS_FALSE);
        }
        return this;
    }

    public ExceptionDrivenStringBuilder append(float i) {
        return this.append(String.valueOf(i));
    }

    public ExceptionDrivenStringBuilder append(double i) {
        return this.append(String.valueOf(i));
    }

    public String toString() {
        return new String(this.buffer, 0, this.length);
    }

    public int length() {
        return this.length;
    }

    public byte[] toUtf8Bytes() {
        if (this.utf8Buffer == null) {
            this.utf8Buffer = new UTF8();
        }
        return this.utf8Buffer.toBytes(this.buffer, 0, this.length);
    }

    public ExceptionDrivenStringBuilder append(Consumer<ExceptionDrivenStringBuilder> consumer) {
        consumer.consume(this);
        return this;
    }

    public ExceptionDrivenStringBuilder append(Supplier<? extends CharSequence> supplier) {
        return this.append(supplier.supply());
    }
}

