/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.misc;

import java.util.Arrays;

public class UTF8 {
    protected byte[] buffer;

    public byte[] toBytes(char[] chars, int offset, int length) {
        if (this.buffer == null || this.buffer.length < length * 4) {
            this.buffer = new byte[length * 4];
        }
        return UTF8.encodeAndTrim(chars, offset, length, this.buffer);
    }

    public byte[] toBytes(char[] chars) {
        return this.toBytes(chars, 0, chars.length);
    }

    public static byte[] encode(char[] chars) {
        return UTF8.encode(chars, 0, chars.length);
    }

    public static byte[] encode(char[] chars, int off, int length) {
        byte[] bytes = new byte[length * 4];
        int l = UTF8.encode(chars, off, length, bytes);
        return Arrays.copyOf(bytes, l);
    }

    public static byte[] encodeAndTrim(char[] chars, int off, int length, byte[] bytes) {
        int l = UTF8.encode(chars, off, length, bytes);
        return Arrays.copyOf(bytes, l);
    }

    public static int encode(char[] chars, int off, int length, byte[] bytes) {
        int limit = off + length;
        int l = 0;
        while (off < limit && chars[off] < '\u0080') {
            bytes[l++] = (byte)chars[off++];
        }
        while (off < limit) {
            char ch;
            if ((ch = chars[off++]) < '\u0080') {
                bytes[l++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                bytes[l++] = (byte)(0xC0 | ch >> 6);
                bytes[l++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (ch >= '\ud800' && ch < '\ue000') {
                int r;
                int n = r = off < limit ? UTF8.parseSurrogate(ch, chars[off]) : -1;
                if (r < 0) {
                    bytes[l++] = 63;
                    continue;
                }
                bytes[l++] = (byte)(0xF0 | r >> 18);
                bytes[l++] = (byte)(0x80 | r >> 12 & 0x3F);
                bytes[l++] = (byte)(0x80 | r >> 6 & 0x3F);
                bytes[l++] = (byte)(0x80 | r & 0x3F);
                ++off;
                continue;
            }
            bytes[l++] = (byte)(0xE0 | ch >> 12);
            bytes[l++] = (byte)(0x80 | ch >> 6 & 0x3F);
            bytes[l++] = (byte)(0x80 | ch & 0x3F);
        }
        return l;
    }

    private static int parseSurrogate(char ch, char ch2) {
        if (ch >= '\ud800' && ch < '\udc00') {
            if (ch2 >= '\udc00' && ch2 < '\ue000') {
                return ((ch & 0x3FF) << 10 | ch2 & 0x3FF) + 65536;
            }
            return -1;
        }
        if (ch >= '\udc00' && ch < '\ue000') {
            return -1;
        }
        return ch;
    }
}

