/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.misc.pool;

import com.wizzardo.tools.misc.Unchecked;
import com.wizzardo.tools.misc.pool.Holder;
import com.wizzardo.tools.misc.pool.Pool;
import java.util.Queue;

public abstract class AbstractQueuedPool<T>
implements Pool<T> {
    protected abstract Queue<Holder<T>> queue();

    @Override
    public T get() {
        Holder<T> item;
        T value;
        do {
            if ((item = this.queue().poll()) != null) continue;
            return this.create();
        } while ((value = item.get()) == null);
        return value;
    }

    @Override
    public Holder<T> holder() {
        Holder<T> item = this.queue().poll();
        if (item == null) {
            return this.createHolder(this.create());
        }
        return item;
    }

    @Override
    public void release(T t) {
        this.release(this.createHolder(t));
    }

    @Override
    public void release(Holder<T> holder) {
        this.queue().add(holder);
    }

    protected Holder<T> createHolder(T t) {
        return new SimpleHolder(t);
    }

    @Override
    public <R> R provide(Pool.Consumer<T, R> consumer) {
        Queue<Holder<T>> queue = this.queue();
        Holder<T> holder = queue.poll();
        if (holder == null) {
            holder = this.createHolder(this.create());
        }
        try {
            R r = consumer.consume(holder.get());
            return r;
        }
        catch (Exception e) {
            throw Unchecked.rethrow((Exception)e);
        }
        finally {
            queue.add(holder);
        }
    }

    protected class SimpleHolder
    implements Holder<T> {
        final T value;

        public SimpleHolder(T value) {
            this.value = value;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void close() {
            AbstractQueuedPool.this.release(this);
        }
    }
}

