/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.misc.pool;

import com.wizzardo.tools.misc.pool.Holder;
import com.wizzardo.tools.misc.pool.Pool;
import java.lang.ref.SoftReference;

public class SoftHolder<T>
implements Holder<T> {
    protected final Pool<T> pool;
    protected volatile SoftReference<T> ref;

    public SoftHolder(Pool<T> pool, T value) {
        this.pool = pool;
        this.ref = new SoftReference<T>(value);
    }

    @Override
    public T get() {
        T value = this.ref.get();
        if (value == null) {
            value = this.pool.create();
            this.ref = new SoftReference<T>(value);
        }
        return value;
    }

    @Override
    public void close() {
        this.pool.release(this);
    }
}

