/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.security;

import java.util.Arrays;

public class Base64 {
    private static final char[] CA;
    private static final char[] CA_URL_SAFE;
    private static final int[] IA;
    private static final int[] IA_URL_SAFE;

    public static final char[] encodeToChar(byte[] sArr, boolean lineSep) {
        return Base64.encodeToChar(sArr, lineSep, false);
    }

    public static final char[] encodeToChar(byte[] sArr, boolean lineSep, boolean urlSafe) {
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new char[0];
        }
        int eLen = sLen / 3 * 3;
        int cCnt = (sLen - 1) / 3 + 1 << 2;
        int dLen = cCnt + (lineSep ? (cCnt - 1) / 76 << 1 : 0);
        char[] dArr = new char[dLen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            if (!urlSafe) {
                dArr[d++] = CA[i >>> 18 & 0x3F];
                dArr[d++] = CA[i >>> 12 & 0x3F];
                dArr[d++] = CA[i >>> 6 & 0x3F];
                dArr[d++] = CA[i & 0x3F];
            } else {
                dArr[d++] = CA_URL_SAFE[i >>> 18 & 0x3F];
                dArr[d++] = CA_URL_SAFE[i >>> 12 & 0x3F];
                dArr[d++] = CA_URL_SAFE[i >>> 6 & 0x3F];
                dArr[d++] = CA_URL_SAFE[i & 0x3F];
            }
            if (!lineSep || ++cc != 19 || d >= dLen - 2) continue;
            dArr[d++] = 13;
            dArr[d++] = 10;
            cc = 0;
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            if (!urlSafe) {
                dArr[dLen - 4] = CA[i >> 12];
                dArr[dLen - 3] = CA[i >>> 6 & 0x3F];
                dArr[dLen - 2] = left == 2 ? CA[i & 0x3F] : 61;
                dArr[dLen - 1] = 61;
            } else {
                dArr[dLen - 4] = CA_URL_SAFE[i >> 12];
                dArr[dLen - 3] = CA_URL_SAFE[i >>> 6 & 0x3F];
                dArr[dLen - 2] = left == 2 ? CA_URL_SAFE[i & 0x3F] : 61;
                dArr[dLen - 1] = 61;
            }
        }
        return dArr;
    }

    public static final byte[] decode(char[] sArr) {
        return Base64.decode(sArr, false);
    }

    public static final byte[] decode(char[] sArr, boolean urlSafe) {
        int i;
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int sepCnt = 0;
        for (int i2 = 0; i2 < sLen; ++i2) {
            if (!urlSafe) {
                if (IA[sArr[i2]] >= 0) continue;
                ++sepCnt;
                continue;
            }
            if (IA_URL_SAFE[sArr[i2]] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        if (!urlSafe) {
            i = sLen;
            while (i > 1 && IA[sArr[--i]] <= 0) {
                if (sArr[i] != '=') continue;
                ++pad;
            }
        } else {
            i = sLen;
            while (i > 1 && IA_URL_SAFE[sArr[--i]] <= 0) {
                if (sArr[i] != '=') continue;
                ++pad;
            }
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i3 = 0;
            for (int j = 0; j < 4; ++j) {
                int c = !urlSafe ? IA[sArr[s++]] : IA_URL_SAFE[sArr[s++]];
                if (c >= 0) {
                    i3 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i3 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i3 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i3;
        }
        return dArr;
    }

    public static final byte[] decodeFast(char[] sArr) {
        return Base64.decodeFast(sArr, false);
    }

    public static final byte[] decodeFast(char[] sArr, boolean urlSafe) {
        int sIx;
        int sLen = sArr.length;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        if (!urlSafe) {
            for (sIx = 0; sIx < eIx && IA[sArr[sIx]] < 0; ++sIx) {
            }
        } else {
            while (sIx < eIx && IA_URL_SAFE[sArr[sIx]] < 0) {
                ++sIx;
            }
        }
        if (!urlSafe) {
            while (eIx > 0 && IA[sArr[eIx]] < 0) {
                --eIx;
            }
        } else {
            while (eIx > 0 && IA_URL_SAFE[sArr[eIx]] < 0) {
                --eIx;
            }
        }
        int pad = sArr[eIx] == '=' ? (sArr[eIx - 1] == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (sArr[76] == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = !urlSafe ? IA[sArr[sIx++]] << 18 | IA[sArr[sIx++]] << 12 | IA[sArr[sIx++]] << 6 | IA[sArr[sIx++]] : IA_URL_SAFE[sArr[sIx++]] << 18 | IA_URL_SAFE[sArr[sIx++]] << 12 | IA_URL_SAFE[sArr[sIx++]] << 6 | IA_URL_SAFE[sArr[sIx++]];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i = !urlSafe ? (i |= IA[sArr[sIx++]] << 18 - j * 6) : (i |= IA_URL_SAFE[sArr[sIx++]] << 18 - j * 6);
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public static final byte[] encodeToByte(byte[] sArr, boolean lineSep) {
        return Base64.encodeToByte(sArr, lineSep, false);
    }

    public static final byte[] encodeToByte(byte[] sArr, boolean lineSep, boolean urlSafe) {
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int eLen = sLen / 3 * 3;
        int cCnt = (sLen - 1) / 3 + 1 << 2;
        int dLen = cCnt + (lineSep ? (cCnt - 1) / 76 << 1 : 0);
        byte[] dArr = new byte[dLen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            if (!urlSafe) {
                dArr[d++] = (byte)CA[i >>> 18 & 0x3F];
                dArr[d++] = (byte)CA[i >>> 12 & 0x3F];
                dArr[d++] = (byte)CA[i >>> 6 & 0x3F];
                dArr[d++] = (byte)CA[i & 0x3F];
            } else {
                dArr[d++] = (byte)CA_URL_SAFE[i >>> 18 & 0x3F];
                dArr[d++] = (byte)CA_URL_SAFE[i >>> 12 & 0x3F];
                dArr[d++] = (byte)CA_URL_SAFE[i >>> 6 & 0x3F];
                dArr[d++] = (byte)CA_URL_SAFE[i & 0x3F];
            }
            if (!lineSep || ++cc != 19 || d >= dLen - 2) continue;
            dArr[d++] = 13;
            dArr[d++] = 10;
            cc = 0;
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            if (!urlSafe) {
                dArr[dLen - 4] = (byte)CA[i >> 12];
                dArr[dLen - 3] = (byte)CA[i >>> 6 & 0x3F];
                dArr[dLen - 2] = left == 2 ? (int)CA[i & 0x3F] : 61;
                dArr[dLen - 1] = 61;
            } else {
                dArr[dLen - 4] = (byte)CA_URL_SAFE[i >> 12];
                dArr[dLen - 3] = (byte)CA_URL_SAFE[i >>> 6 & 0x3F];
                dArr[dLen - 2] = left == 2 ? (int)CA_URL_SAFE[i & 0x3F] : 61;
                dArr[dLen - 1] = 61;
            }
        }
        return dArr;
    }

    public static final byte[] decode(byte[] sArr) {
        return Base64.decode(sArr, false);
    }

    public static final byte[] decode(byte[] sArr, boolean urlSafe) {
        int i;
        int sLen = sArr.length;
        int sepCnt = 0;
        for (int i2 = 0; i2 < sLen; ++i2) {
            if (!urlSafe) {
                if (IA[sArr[i2] & 0xFF] >= 0) continue;
                ++sepCnt;
                continue;
            }
            if (IA_URL_SAFE[sArr[i2] & 0xFF] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        if (!urlSafe) {
            i = sLen;
            while (i > 1 && IA[sArr[--i] & 0xFF] <= 0) {
                if (sArr[i] != 61) continue;
                ++pad;
            }
        } else {
            i = sLen;
            while (i > 1 && IA_URL_SAFE[sArr[--i] & 0xFF] <= 0) {
                if (sArr[i] != 61) continue;
                ++pad;
            }
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i3 = 0;
            for (int j = 0; j < 4; ++j) {
                int c = !urlSafe ? IA[sArr[s++] & 0xFF] : IA_URL_SAFE[sArr[s++] & 0xFF];
                if (c >= 0) {
                    i3 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i3 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i3 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i3;
        }
        return dArr;
    }

    public static final byte[] decodeFast(byte[] sArr) {
        return Base64.decodeFast(sArr, false);
    }

    public static final byte[] decodeFast(byte[] sArr, boolean urlSafe) {
        int sIx;
        int sLen = sArr.length;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        if (!urlSafe) {
            for (sIx = 0; sIx < eIx && IA[sArr[sIx] & 0xFF] < 0; ++sIx) {
            }
        } else {
            while (sIx < eIx && IA_URL_SAFE[sArr[sIx] & 0xFF] < 0) {
                ++sIx;
            }
        }
        if (!urlSafe) {
            while (eIx > 0 && IA[sArr[eIx] & 0xFF] < 0) {
                --eIx;
            }
        } else {
            while (eIx > 0 && IA_URL_SAFE[sArr[eIx] & 0xFF] < 0) {
                --eIx;
            }
        }
        int pad = sArr[eIx] == 61 ? (sArr[eIx - 1] == 61 ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (sArr[76] == 13 ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = !urlSafe ? IA[sArr[sIx++]] << 18 | IA[sArr[sIx++]] << 12 | IA[sArr[sIx++]] << 6 | IA[sArr[sIx++]] : IA_URL_SAFE[sArr[sIx++]] << 18 | IA_URL_SAFE[sArr[sIx++]] << 12 | IA_URL_SAFE[sArr[sIx++]] << 6 | IA_URL_SAFE[sArr[sIx++]];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i = !urlSafe ? (i |= IA[sArr[sIx++]] << 18 - j * 6) : (i |= IA_URL_SAFE[sArr[sIx++]] << 18 - j * 6);
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public static final String encodeToString(byte[] sArr) {
        return Base64.encodeToString(sArr, false, false);
    }

    public static final String encodeToString(byte[] sArr, boolean lineSep) {
        return Base64.encodeToString(sArr, lineSep, false);
    }

    public static final String encodeToString(byte[] sArr, boolean lineSep, boolean urlSafe) {
        return new String(Base64.encodeToChar(sArr, lineSep, urlSafe));
    }

    public static final byte[] decode(String str) {
        return Base64.decode(str, false);
    }

    public static final byte[] decode(String str, boolean urlSafe) {
        int i;
        int sLen;
        int n = sLen = str != null ? str.length() : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int sepCnt = 0;
        for (int i2 = 0; i2 < sLen; ++i2) {
            if (!urlSafe) {
                if (IA[str.charAt(i2)] >= 0) continue;
                ++sepCnt;
                continue;
            }
            if (IA_URL_SAFE[str.charAt(i2)] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        if (!urlSafe) {
            i = sLen;
            while (i > 1 && IA[str.charAt(--i)] <= 0) {
                if (str.charAt(i) != '=') continue;
                ++pad;
            }
        } else {
            i = sLen;
            while (i > 1 && IA_URL_SAFE[str.charAt(--i)] <= 0) {
                if (str.charAt(i) != '=') continue;
                ++pad;
            }
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i3 = 0;
            for (int j = 0; j < 4; ++j) {
                int c = !urlSafe ? IA[str.charAt(s++)] : IA_URL_SAFE[str.charAt(s++)];
                if (c >= 0) {
                    i3 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i3 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i3 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i3;
        }
        return dArr;
    }

    public static final byte[] decodeFast(String s) {
        return Base64.decodeFast(s, false);
    }

    public static final byte[] decodeFast(String s, boolean urlSafe) {
        int sIx;
        int sLen = s.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        if (!urlSafe) {
            for (sIx = 0; sIx < eIx && IA[s.charAt(sIx) & 0xFF] < 0; ++sIx) {
            }
        } else {
            while (sIx < eIx && IA_URL_SAFE[s.charAt(sIx) & 0xFF] < 0) {
                ++sIx;
            }
        }
        if (!urlSafe) {
            while (eIx > 0 && IA[s.charAt(eIx) & 0xFF] < 0) {
                --eIx;
            }
        } else {
            while (eIx > 0 && IA_URL_SAFE[s.charAt(eIx) & 0xFF] < 0) {
                --eIx;
            }
        }
        int pad = s.charAt(eIx) == '=' ? (s.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (s.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = !urlSafe ? IA[s.charAt(sIx++)] << 18 | IA[s.charAt(sIx++)] << 12 | IA[s.charAt(sIx++)] << 6 | IA[s.charAt(sIx++)] : IA_URL_SAFE[s.charAt(sIx++)] << 18 | IA_URL_SAFE[s.charAt(sIx++)] << 12 | IA_URL_SAFE[s.charAt(sIx++)] << 6 | IA_URL_SAFE[s.charAt(sIx++)];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i = !urlSafe ? (i |= IA[s.charAt(sIx++)] << 18 - j * 6) : (i |= IA_URL_SAFE[s.charAt(sIx++)] << 18 - j * 6);
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    static {
        int i;
        CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        CA_URL_SAFE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
        IA = new int[256];
        IA_URL_SAFE = new int[256];
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (i = 0; i < iS; ++i) {
            Base64.IA[Base64.CA[i]] = i;
        }
        Base64.IA[61] = 0;
        Arrays.fill(IA_URL_SAFE, -1);
        iS = CA_URL_SAFE.length;
        for (i = 0; i < iS; ++i) {
            Base64.IA_URL_SAFE[Base64.CA_URL_SAFE[i]] = i;
        }
        Base64.IA_URL_SAFE[61] = 0;
    }
}

