/*
 * Decompiled with CFR 0.152.
 */
package com.wizzardo.tools.security;

import com.wizzardo.tools.misc.Unchecked;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public abstract class Hash {
    private static final Charset UTF8 = Charset.forName("utf-8");
    private MessageDigest hash;

    public Hash(String name) {
        this.hash = this.init(name);
    }

    protected MessageDigest init(String name) {
        try {
            return MessageDigest.getInstance(name);
        }
        catch (NoSuchAlgorithmException ex) {
            throw Unchecked.rethrow((Exception)ex);
        }
    }

    protected abstract int hexStringLength();

    public Hash update(byte[] b, int offset, int length) {
        this.hash.update(b, offset, length);
        return this;
    }

    public Hash reset() {
        this.hash.reset();
        return this;
    }

    public String toString() {
        return this.asString();
    }

    public Hash update(byte[] b) {
        return this.update(b, 0, b.length);
    }

    public Hash update(String s) {
        return this.update(s.getBytes(UTF8));
    }

    public Hash update(byte b) {
        this.hash.update(b);
        return this;
    }

    public String asString() {
        return this.toHexString(this.asBytes());
    }

    public byte[] asBytes() {
        return this.hash.digest();
    }

    public void asBytes(byte[] bytes) {
        this.asBytes(bytes, 0);
    }

    public void asBytes(byte[] bytes, int offset) {
        try {
            this.hash.digest(bytes, offset, this.hash.getDigestLength());
        }
        catch (DigestException e) {
            throw Unchecked.rethrow((Exception)e);
        }
    }

    public Hash update(InputStream in) throws IOException {
        int r;
        byte[] b = new byte[10240];
        while ((r = in.read(b)) != -1) {
            this.update(b, 0, r);
        }
        return this;
    }

    private String toHexString(byte[] b) {
        String str = new BigInteger(1, b).toString(16);
        while (str.length() < this.hexStringLength()) {
            str = "0" + str;
        }
        return str;
    }

    public boolean check(String value, String hashString) {
        return this.update(value.getBytes()).asString().equalsIgnoreCase(hashString);
    }

    public boolean check(byte[] b, byte[] hashBytes) {
        return Arrays.equals(this.update(b).asBytes(), hashBytes);
    }
}

