/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.registry.client.util.json;

import com.xxl.registry.client.util.json.BasicJsonwriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicJsonReader {
    private static Logger logger = LoggerFactory.getLogger(BasicJsonwriter.class);

    public Map<String, Object> parseMap(String json) {
        if (json != null && (json = json.trim()).startsWith("{")) {
            return this.parseMapInternal(json);
        }
        throw new IllegalArgumentException("Cannot parse JSON");
    }

    public List<Object> parseList(String json) {
        if (json != null && (json = json.trim()).startsWith("[")) {
            return this.parseListInternal(json);
        }
        throw new IllegalArgumentException("Cannot parse JSON");
    }

    private List<Object> parseListInternal(String json) {
        ArrayList<Object> list = new ArrayList<Object>();
        json = BasicJsonReader.trimLeadingCharacter(BasicJsonReader.trimTrailingCharacter(json, ']'), '[');
        for (String value : this.tokenize(json)) {
            list.add(this.parseInternal(value));
        }
        return list;
    }

    private Object parseInternal(String json) {
        if (json.startsWith("[")) {
            return this.parseListInternal(json);
        }
        if (json.startsWith("{")) {
            return this.parseMapInternal(json);
        }
        if (json.startsWith("\"")) {
            return BasicJsonReader.trimTrailingCharacter(BasicJsonReader.trimLeadingCharacter(json, '\"'), '\"');
        }
        try {
            return Long.valueOf(json);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(json);
            }
            catch (NumberFormatException numberFormatException2) {
                return json;
            }
        }
    }

    private Map<String, Object> parseMapInternal(String json) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        json = BasicJsonReader.trimLeadingCharacter(BasicJsonReader.trimTrailingCharacter(json, '}'), '{');
        for (String pair : this.tokenize(json)) {
            String[] values = BasicJsonReader.trimArrayElements(BasicJsonReader.split(pair, ":"));
            String key = BasicJsonReader.trimLeadingCharacter(BasicJsonReader.trimTrailingCharacter(values[0], '\"'), '\"');
            Object value = this.parseInternal(values[1]);
            map.put(key, value);
        }
        return map;
    }

    private static String[] split(String toSplit, String delimiter) {
        if (toSplit != null && !toSplit.isEmpty() && delimiter != null && !delimiter.isEmpty()) {
            int offset = toSplit.indexOf(delimiter);
            if (offset < 0) {
                return null;
            }
            String beforeDelimiter = toSplit.substring(0, offset);
            String afterDelimiter = toSplit.substring(offset + delimiter.length());
            return new String[]{beforeDelimiter, afterDelimiter};
        }
        return null;
    }

    private static String[] trimArrayElements(String[] array) {
        if (array == null || array.length == 0) {
            return new String[0];
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String element = array[i];
            result[i] = element != null ? element.trim() : null;
        }
        return result;
    }

    private List<String> tokenize(String json) {
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        int inObject = 0;
        int inList = 0;
        boolean inValue = false;
        boolean inEscape = false;
        StringBuilder build = new StringBuilder();
        while (index < json.length()) {
            char current = json.charAt(index);
            if (inEscape) {
                build.append(current);
                ++index;
                inEscape = false;
                continue;
            }
            if (current == '{') {
                ++inObject;
            }
            if (current == '}') {
                --inObject;
            }
            if (current == '[') {
                ++inList;
            }
            if (current == ']') {
                --inList;
            }
            if (current == '\"') {
                boolean bl = inValue = !inValue;
            }
            if (current == ',' && inObject == 0 && inList == 0 && !inValue) {
                list.add(build.toString());
                build.setLength(0);
            } else if (current == '\\') {
                inEscape = true;
            } else {
                build.append(current);
            }
            ++index;
        }
        if (build.length() > 0) {
            list.add(build.toString());
        }
        return list;
    }

    private static String trimTrailingCharacter(String string, char c) {
        if (string.length() > 0 && string.charAt(string.length() - 1) == c) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String trimLeadingCharacter(String string, char c) {
        if (string.length() > 0 && string.charAt(0) == c) {
            return string.substring(1);
        }
        return string;
    }
}

